/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.optimize.solvers.accumulation.encoding.residual;

import org.deeplearning4j.optimize.solvers.accumulation.encoding.ResidualPostProcessor;
import org.nd4j.base.Preconditions;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.indexing.BooleanIndexing;
import org.nd4j.linalg.indexing.conditions.Condition;
import org.nd4j.linalg.indexing.conditions.Conditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResidualClippingPostProcessor
implements ResidualPostProcessor {
    private static final Logger log = LoggerFactory.getLogger(ResidualClippingPostProcessor.class);
    private final double thresholdMultipleClipValue;
    private final int frequency;

    public ResidualClippingPostProcessor(double thresholdMultipleClipValue, int frequency) {
        Preconditions.checkState((thresholdMultipleClipValue >= 1.0 ? 1 : 0) != 0, (String)"Threshold multiple must be a positive value and greater than 1.0 (1.0 means clip at 1x the current threshold)");
        this.thresholdMultipleClipValue = thresholdMultipleClipValue;
        this.frequency = frequency;
    }

    @Override
    public void processResidual(int iteration, int epoch, double lastThreshold, INDArray residualVector) {
        if (iteration > 0 && iteration % this.frequency == 0) {
            double currClip = lastThreshold * this.thresholdMultipleClipValue;
            BooleanIndexing.replaceWhere((INDArray)residualVector, (Number)currClip, (Condition)Conditions.greaterThan((Number)currClip));
            BooleanIndexing.replaceWhere((INDArray)residualVector, (Number)(-currClip), (Condition)Conditions.lessThan((Number)(-currClip)));
            log.debug("Applied residual clipping: iter={}, epoch={}, lastThreshold={}, multiple={}, clipValue={}", new Object[]{iteration, epoch, lastThreshold, this.thresholdMultipleClipValue, currClip});
        }
    }

    @Override
    public ResidualClippingPostProcessor clone() {
        return new ResidualClippingPostProcessor(this.thresholdMultipleClipValue, this.frequency);
    }
}

