/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import lombok.NonNull;
import org.apache.commons.io.IOUtils;
import org.deeplearning4j.nn.conf.MultiLayerConfiguration;
import org.deeplearning4j.nn.graph.ComputationGraph;
import org.deeplearning4j.nn.multilayer.MultiLayerNetwork;
import org.nd4j.validation.Nd4jCommonValidator;
import org.nd4j.validation.ValidationResult;

public class DL4JModelValidator {
    private DL4JModelValidator() {
    }

    public static ValidationResult validateMultiLayerNetwork(@NonNull File f) {
        String config;
        if (f == null) {
            throw new NullPointerException("f is marked @NonNull but is null");
        }
        List<String> requiredEntries = Arrays.asList("configuration.json", "coefficients.bin");
        ValidationResult vr = Nd4jCommonValidator.isValidZipFile((File)f, (boolean)false, requiredEntries);
        if (vr != null && !vr.isValid()) {
            vr.setFormatClass(MultiLayerNetwork.class);
            vr.setFormatType("MultiLayerNetwork");
            return vr;
        }
        try (ZipFile zf = new ZipFile(f);){
            ZipEntry ze = zf.getEntry("configuration.json");
            config = IOUtils.toString((Reader)new BufferedReader(new InputStreamReader(zf.getInputStream(ze), StandardCharsets.UTF_8)));
        }
        catch (IOException e) {
            return ValidationResult.builder().formatType("MultiLayerNetwork").formatClass(MultiLayerNetwork.class).valid(false).path(Nd4jCommonValidator.getPath((File)f)).issues(Collections.singletonList("Unable to read configuration from model zip file")).exception((Throwable)e).build();
        }
        try {
            MultiLayerConfiguration.fromJson(config);
        }
        catch (Throwable t) {
            return ValidationResult.builder().formatType("MultiLayerNetwork").formatClass(MultiLayerNetwork.class).valid(false).path(Nd4jCommonValidator.getPath((File)f)).issues(Collections.singletonList("Zip file JSON model configuration does not appear to represent a valid MultiLayerConfiguration")).exception(t).build();
        }
        return ValidationResult.builder().formatType("MultiLayerNetwork").formatClass(MultiLayerNetwork.class).valid(true).path(Nd4jCommonValidator.getPath((File)f)).build();
    }

    public static ValidationResult validateComputationGraph(@NonNull File f) {
        String config;
        if (f == null) {
            throw new NullPointerException("f is marked @NonNull but is null");
        }
        List<String> requiredEntries = Arrays.asList("configuration.json", "coefficients.bin");
        ValidationResult vr = Nd4jCommonValidator.isValidZipFile((File)f, (boolean)false, requiredEntries);
        if (vr != null && !vr.isValid()) {
            vr.setFormatClass(ComputationGraph.class);
            vr.setFormatType("ComputationGraph");
            return vr;
        }
        try (ZipFile zf = new ZipFile(f);){
            ZipEntry ze = zf.getEntry("configuration.json");
            config = IOUtils.toString((Reader)new BufferedReader(new InputStreamReader(zf.getInputStream(ze), StandardCharsets.UTF_8)));
        }
        catch (IOException e) {
            return ValidationResult.builder().formatType("ComputationGraph").formatClass(ComputationGraph.class).valid(false).path(Nd4jCommonValidator.getPath((File)f)).issues(Collections.singletonList("Unable to read configuration from model zip file")).exception((Throwable)e).build();
        }
        try {
            MultiLayerConfiguration.fromJson(config);
        }
        catch (Throwable t) {
            return ValidationResult.builder().formatType("ComputationGraph").formatClass(ComputationGraph.class).valid(false).path(Nd4jCommonValidator.getPath((File)f)).issues(Collections.singletonList("Zip file JSON model configuration does not appear to represent a valid ComputationGraphConfiguration")).exception(t).build();
        }
        return ValidationResult.builder().formatType("ComputationGraph").formatClass(ComputationGraph.class).valid(true).path(Nd4jCommonValidator.getPath((File)f)).build();
    }
}

