/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.layers.mkldnn;

import java.util.Collections;
import java.util.Map;
import org.deeplearning4j.nn.gradient.Gradient;
import org.deeplearning4j.nn.layers.mkldnn.BaseMKLDNNHelper;
import org.deeplearning4j.nn.layers.normalization.BatchNormalizationHelper;
import org.deeplearning4j.nn.workspace.ArrayType;
import org.deeplearning4j.nn.workspace.LayerWorkspaceMgr;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.memory.MemoryWorkspace;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.CustomOp;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.api.ops.OpContext;
import org.nd4j.linalg.api.ops.impl.layers.convolution.BatchNorm;
import org.nd4j.linalg.api.ops.impl.summarystats.Variance;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.primitives.Pair;
import org.nd4j.linalg.util.ArrayUtil;

public class MKLDNNBatchNormHelper
implements BatchNormalizationHelper {
    private static final int[] RANK2_DIMS = new int[]{0};
    private static final int[] RANK4_DIMS = new int[]{0, 2, 3};
    protected OpContext context;
    private INDArray meanCache;
    private INDArray varCache;

    public MKLDNNBatchNormHelper(DataType dataType) {
    }

    @Override
    public boolean checkSupported(double eps, boolean fixedGammaBeta) {
        return !fixedGammaBeta && BaseMKLDNNHelper.mklDnnEnabled();
    }

    @Override
    public Pair<Gradient, INDArray> backpropGradient(INDArray input, INDArray epsilon, int[] shape, INDArray gamma, INDArray dGammaView, INDArray dBetaView, double eps, LayerWorkspaceMgr workspaceMgr) {
        return null;
    }

    @Override
    public INDArray preOutput(INDArray x, boolean training, int[] shape, INDArray gamma, INDArray beta, INDArray mean, INDArray var, double decay, double eps, LayerWorkspaceMgr workspaceMgr) {
        INDArray v;
        INDArray m;
        if (x.dataType() != DataType.FLOAT) {
            return null;
        }
        if (this.context == null) {
            this.context = Nd4j.getExecutioner().buildContext();
            this.context.setIArguments(new long[]{ArrayUtil.fromBoolean((gamma != null ? 1 : 0) != 0), ArrayUtil.fromBoolean((beta != null ? 1 : 0) != 0), 1L});
            this.context.setTArguments(new double[]{eps});
        }
        if (training) {
            if (this.meanCache == null) {
                try (MemoryWorkspace ws = Nd4j.getMemoryManager().scopeOutOfWorkspaces();){
                    this.meanCache = Nd4j.createUninitialized((DataType)x.dataType(), (long[])new long[]{x.size(1)});
                    this.varCache = Nd4j.createUninitialized((DataType)x.dataType(), (long[])new long[]{x.size(1)});
                }
            }
            x.mean(this.meanCache, x.rank() == 2 ? RANK2_DIMS : RANK4_DIMS);
            Nd4j.exec((Op)new Variance(x, this.varCache, false, x.rank() == 2 ? RANK2_DIMS : RANK4_DIMS));
            m = this.meanCache;
            v = this.varCache;
        } else {
            m = mean.reshape(new long[]{mean.length()});
            v = var.reshape(new long[]{var.length()});
        }
        this.context.getInputArrays().clear();
        this.context.getOutputArrays().clear();
        this.context.setInputArray(0, x);
        this.context.setInputArray(1, m);
        this.context.setInputArray(2, v);
        if (gamma != null && beta != null) {
            this.context.setInputArray(3, gamma.rank() == 2 ? gamma.reshape(new long[]{gamma.length()}) : gamma);
            this.context.setInputArray(4, beta.rank() == 2 ? beta.reshape(new long[]{beta.length()}) : beta);
        }
        INDArray out = workspaceMgr.createUninitialized(ArrayType.ACTIVATIONS, x.dataType(), x.shape());
        this.context.setOutputArray(0, out);
        BatchNorm bn = new BatchNorm();
        Nd4j.exec((CustomOp)bn, (OpContext)this.context);
        return out;
    }

    @Override
    public INDArray getMeanCache(DataType dataType) {
        return this.meanCache;
    }

    @Override
    public INDArray getVarCache(DataType dataType) {
        return this.varCache;
    }

    @Override
    public Map<String, Long> helperMemoryUse() {
        return Collections.emptyMap();
    }
}

