/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.graph.vertex.impl;

import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.api.MaskState;
import org.deeplearning4j.nn.gradient.Gradient;
import org.deeplearning4j.nn.graph.ComputationGraph;
import org.deeplearning4j.nn.graph.vertex.BaseGraphVertex;
import org.deeplearning4j.nn.graph.vertex.VertexIndices;
import org.deeplearning4j.nn.workspace.ArrayType;
import org.deeplearning4j.nn.workspace.LayerWorkspaceMgr;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.memory.MemoryWorkspace;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BroadcastOp;
import org.nd4j.linalg.api.ops.impl.broadcast.BroadcastDivOp;
import org.nd4j.linalg.api.ops.impl.broadcast.BroadcastMulOp;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.ops.transforms.Transforms;
import org.nd4j.linalg.primitives.Pair;

public class L2NormalizeVertex
extends BaseGraphVertex {
    private static final int[] DEFAULT_RANK2_DIMS = new int[]{1};
    private static final int[] DEFAULT_RANK3_DIMS = new int[]{1, 2};
    private static final int[] DEFAULT_RANK4_DIMS = new int[]{1, 2, 3};
    private int[] dimension;
    private double eps;

    public L2NormalizeVertex(ComputationGraph graph, String name, int vertexIndex, int[] dimension, double eps, DataType dataType) {
        this(graph, name, vertexIndex, null, null, dimension, eps, dataType);
    }

    public L2NormalizeVertex(ComputationGraph graph, String name, int vertexIndex, VertexIndices[] inputVertices, VertexIndices[] outputVertices, int[] dimension, double eps, DataType dataType) {
        super(graph, name, vertexIndex, inputVertices, outputVertices, dataType);
        this.dimension = dimension;
        this.eps = eps;
    }

    @Override
    public boolean hasLayer() {
        return false;
    }

    @Override
    public Layer getLayer() {
        return null;
    }

    @Override
    public INDArray doForward(boolean training, LayerWorkspaceMgr workspaceMgr) {
        if (!this.canDoForward()) {
            throw new IllegalStateException("Cannot do forward pass: inputs not set (L2NormalizeVertex " + this.vertexName + " idx " + this.vertexIndex + ")");
        }
        INDArray x = this.inputs[0];
        int[] dimensions = this.getDimensions(x);
        INDArray xNorm2 = x.norm2(dimensions);
        Transforms.max((INDArray)xNorm2, (double)this.eps, (boolean)false);
        try (MemoryWorkspace ws = workspaceMgr.notifyScopeBorrowed(ArrayType.ACTIVATIONS);){
            if (x.rank() == 2) {
                INDArray iNDArray = x.divColumnVector(xNorm2);
                return iNDArray;
            }
            INDArray out = Nd4j.createUninitialized((long[])x.shape(), (char)x.ordering());
            INDArray iNDArray = Nd4j.getExecutioner().exec((BroadcastOp)new BroadcastDivOp(x, xNorm2, out, new int[]{0}));
            return iNDArray;
        }
    }

    @Override
    public Pair<Gradient, INDArray[]> doBackward(boolean tbptt, LayerWorkspaceMgr workspaceMgr) {
        INDArray dLdx;
        if (!this.canDoBackward()) {
            throw new IllegalStateException("Cannot do backward pass: errors not set (L2NormalizeVertex " + this.vertexName + " idx " + this.vertexIndex + ")");
        }
        INDArray x = this.inputs[0];
        int[] dimensions = this.getDimensions(x);
        INDArray norm = x.norm2(dimensions);
        INDArray norm3 = Transforms.pow((INDArray)norm, (Number)3.0, (boolean)true);
        Transforms.max((INDArray)norm, (double)this.eps, (boolean)false);
        Transforms.max((INDArray)norm3, (double)this.eps, (boolean)false);
        if (x.rank() == 2) {
            try (MemoryWorkspace ws = workspaceMgr.notifyScopeBorrowed(ArrayType.ACTIVATION_GRAD);){
                dLdx = this.epsilon.divColumnVector(norm);
            }
            INDArray xDivNorm3 = x.divColumnVector(norm3);
            dLdx.subi(xDivNorm3.muliColumnVector(this.epsilon.mul(x).sum(new int[]{1})));
        } else {
            INDArray dx = this.epsilon.mul(x).sum(dimensions);
            INDArray xDivNorm3 = Nd4j.createUninitialized((long[])x.shape(), (char)x.ordering());
            Nd4j.getExecutioner().exec((BroadcastOp)new BroadcastDivOp(x, norm3, xDivNorm3, new int[]{0}));
            Nd4j.getExecutioner().exec((BroadcastOp)new BroadcastMulOp(xDivNorm3, dx, xDivNorm3, new int[]{0}));
            dLdx = workspaceMgr.createUninitialized(ArrayType.ACTIVATION_GRAD, this.epsilon.dataType(), this.epsilon.shape(), this.epsilon.ordering());
            Nd4j.getExecutioner().exec((BroadcastOp)new BroadcastDivOp(this.epsilon, norm, dLdx, new int[]{0}));
            dLdx.subi(xDivNorm3);
        }
        return new Pair(null, (Object)new INDArray[]{dLdx});
    }

    private int[] getDimensions(INDArray x) {
        if (this.dimension == null || this.dimension.length < 1) {
            switch (x.rank()) {
                case 2: {
                    return DEFAULT_RANK2_DIMS;
                }
                case 3: {
                    return DEFAULT_RANK3_DIMS;
                }
                case 4: {
                    return DEFAULT_RANK4_DIMS;
                }
            }
            throw new RuntimeException();
        }
        return this.dimension;
    }

    @Override
    public void setBackpropGradientsViewArray(INDArray backpropGradientsViewArray) {
        if (backpropGradientsViewArray != null) {
            throw new RuntimeException("Vertex does not have gradients; gradients view array cannot be set here");
        }
    }

    @Override
    public Pair<INDArray, MaskState> feedForwardMaskArrays(INDArray[] maskArrays, MaskState currentMaskState, int minibatchSize) {
        if (maskArrays == null || maskArrays.length == 0) {
            return null;
        }
        return new Pair((Object)maskArrays[0], (Object)currentMaskState);
    }

    @Override
    public String toString() {
        return "L2NormalizeVertex(id=" + this.getVertexIndex() + ",name=\"" + this.getVertexName() + ",dim=\"" + this.dimension + "\")";
    }
}

