/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.deeplearning4j.nn.conf.BackpropType;
import org.deeplearning4j.nn.conf.CacheMode;
import org.deeplearning4j.nn.conf.InputPreProcessor;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.WorkspaceMode;
import org.deeplearning4j.nn.conf.distribution.Distribution;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.layers.BaseLayer;
import org.deeplearning4j.nn.conf.layers.BaseOutputLayer;
import org.deeplearning4j.nn.conf.layers.BaseRecurrentLayer;
import org.deeplearning4j.nn.conf.layers.DenseLayer;
import org.deeplearning4j.nn.conf.layers.EmbeddingLayer;
import org.deeplearning4j.nn.conf.layers.FeedForwardLayer;
import org.deeplearning4j.nn.conf.layers.GlobalPoolingLayer;
import org.deeplearning4j.nn.conf.layers.Layer;
import org.deeplearning4j.nn.conf.layers.OutputLayer;
import org.deeplearning4j.nn.conf.layers.recurrent.LastTimeStep;
import org.deeplearning4j.nn.conf.memory.LayerMemoryReport;
import org.deeplearning4j.nn.conf.memory.MemoryReport;
import org.deeplearning4j.nn.conf.memory.NetworkMemoryReport;
import org.deeplearning4j.nn.conf.serde.JsonMappers;
import org.deeplearning4j.nn.weights.IWeightInit;
import org.deeplearning4j.nn.weights.WeightInit;
import org.deeplearning4j.util.OutputLayerUtil;
import org.nd4j.linalg.activations.Activation;
import org.nd4j.linalg.activations.IActivation;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.lossfunctions.ILossFunction;
import org.nd4j.linalg.lossfunctions.LossFunctions;
import org.nd4j.linalg.lossfunctions.impl.LossBinaryXENT;
import org.nd4j.linalg.lossfunctions.impl.LossMCXENT;
import org.nd4j.linalg.lossfunctions.impl.LossMSE;
import org.nd4j.linalg.lossfunctions.impl.LossNegativeLogLikelihood;
import org.nd4j.shade.jackson.core.JsonProcessingException;
import org.nd4j.shade.jackson.core.TreeNode;
import org.nd4j.shade.jackson.databind.JsonNode;
import org.nd4j.shade.jackson.databind.ObjectMapper;
import org.nd4j.shade.jackson.databind.exc.InvalidTypeIdException;
import org.nd4j.shade.jackson.databind.node.ArrayNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiLayerConfiguration
implements Serializable,
Cloneable {
    private static final Logger log = LoggerFactory.getLogger(MultiLayerConfiguration.class);
    protected List<NeuralNetConfiguration> confs;
    protected Map<Integer, InputPreProcessor> inputPreProcessors = new HashMap<Integer, InputPreProcessor>();
    protected BackpropType backpropType = BackpropType.Standard;
    protected int tbpttFwdLength = 20;
    protected int tbpttBackLength = 20;
    protected boolean validateOutputLayerConfig = true;
    protected WorkspaceMode trainingWorkspaceMode = WorkspaceMode.ENABLED;
    protected WorkspaceMode inferenceWorkspaceMode = WorkspaceMode.ENABLED;
    protected CacheMode cacheMode;
    protected DataType dataType = DataType.FLOAT;
    protected int iterationCount = 0;
    protected int epochCount = 0;

    public int getEpochCount() {
        return this.epochCount;
    }

    public void setEpochCount(int epochCount) {
        this.epochCount = epochCount;
        for (int i = 0; i < this.confs.size(); ++i) {
            this.getConf(i).setEpochCount(epochCount);
        }
    }

    public String toYaml() {
        ObjectMapper mapper;
        ObjectMapper objectMapper = mapper = NeuralNetConfiguration.mapperYaml();
        synchronized (objectMapper) {
            try {
                return mapper.writeValueAsString((Object)this);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static MultiLayerConfiguration fromYaml(String json) {
        ObjectMapper mapper = NeuralNetConfiguration.mapperYaml();
        try {
            return (MultiLayerConfiguration)mapper.readValue(json, MultiLayerConfiguration.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String toJson() {
        ObjectMapper mapper;
        ObjectMapper objectMapper = mapper = NeuralNetConfiguration.mapper();
        synchronized (objectMapper) {
            try {
                return mapper.writeValueAsString((Object)this);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static MultiLayerConfiguration fromJson(String json) {
        MultiLayerConfiguration conf;
        ObjectMapper mapper = NeuralNetConfiguration.mapper();
        try {
            conf = (MultiLayerConfiguration)mapper.readValue(json, MultiLayerConfiguration.class);
        }
        catch (InvalidTypeIdException e) {
            if (e.getMessage().contains("@class")) {
                try {
                    return (MultiLayerConfiguration)JsonMappers.getLegacyMapper().readValue(json, MultiLayerConfiguration.class);
                }
                catch (InvalidTypeIdException e2) {
                    String msg = e2.getMessage();
                    if (msg != null && msg.contains("Could not resolve type id")) {
                        throw new RuntimeException("Error deserializing MultiLayerConfiguration - configuration may have a custom layer, vertex or preprocessor, in pre version 1.0.0-beta JSON format.\nModels in legacy format with custom layers should be loaded in 1.0.0-beta to 1.0.0-beta4 and saved again, before loading in the current version of DL4J", e);
                    }
                    throw new RuntimeException(e2);
                }
                catch (IOException e2) {
                    throw new RuntimeException(e2);
                }
            }
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            String msg = e.getMessage();
            if (msg != null && msg.contains("legacy")) {
                throw new RuntimeException("Error deserializing MultiLayerConfiguration - configuration may have a custom layer, vertex or preprocessor, in pre version 1.0.0-alpha JSON format. These layers can be deserialized by first registering them with NeuralNetConfiguration.registerLegacyCustomClassesForJSON(Class...)", e);
            }
            throw new RuntimeException(e);
        }
        int layerCount = 0;
        JsonNode confs = null;
        for (NeuralNetConfiguration nnc : conf.getConfs()) {
            Layer l;
            block35: {
                l = nnc.getLayer();
                if (l instanceof BaseOutputLayer && ((BaseOutputLayer)l).getLossFn() == null) {
                    BaseOutputLayer ol = (BaseOutputLayer)l;
                    try {
                        JsonNode jsonNode = mapper.readTree(json);
                        if (confs == null) {
                            confs = jsonNode.get("confs");
                        }
                        if (confs instanceof ArrayNode) {
                            ArrayNode layerConfs = (ArrayNode)confs;
                            JsonNode outputLayerNNCNode = layerConfs.get(layerCount);
                            if (outputLayerNNCNode == null) {
                                return conf;
                            }
                            JsonNode outputLayerNode = outputLayerNNCNode.get("layer");
                            JsonNode lossFunctionNode = null;
                            if (outputLayerNode.has("output")) {
                                lossFunctionNode = outputLayerNode.get("output").get("lossFunction");
                            } else if (outputLayerNode.has("rnnoutput")) {
                                lossFunctionNode = outputLayerNode.get("rnnoutput").get("lossFunction");
                            }
                            if (lossFunctionNode == null) break block35;
                            String lossFunctionEnumStr = lossFunctionNode.asText();
                            LossFunctions.LossFunction lossFunction = null;
                            try {
                                lossFunction = LossFunctions.LossFunction.valueOf((String)lossFunctionEnumStr);
                            }
                            catch (Exception e) {
                                log.warn("OutputLayer with null LossFunction or pre-0.6.0 loss function configuration detected: could not parse JSON", (Throwable)e);
                            }
                            if (lossFunction == null) break block35;
                            switch (lossFunction) {
                                case MSE: {
                                    ol.setLossFn((ILossFunction)new LossMSE());
                                    break;
                                }
                                case XENT: {
                                    ol.setLossFn((ILossFunction)new LossBinaryXENT());
                                    break;
                                }
                                case NEGATIVELOGLIKELIHOOD: {
                                    ol.setLossFn((ILossFunction)new LossNegativeLogLikelihood());
                                    break;
                                }
                                case MCXENT: {
                                    ol.setLossFn((ILossFunction)new LossMCXENT());
                                    break;
                                }
                                default: {
                                    log.warn("OutputLayer with null LossFunction or pre-0.6.0 loss function configuration detected: could not set loss function for {}", (Object)lossFunction);
                                }
                            }
                            break block35;
                        }
                        log.warn("OutputLayer with null LossFunction or pre-0.6.0 loss function configuration detected: could not parse JSON: layer 'confs' field is not an ArrayNode (is: {})", confs != null ? confs.getClass() : null);
                    }
                    catch (IOException e) {
                        log.warn("OutputLayer with null LossFunction or pre-0.6.0 loss function configuration detected: could not parse JSON", (Throwable)e);
                        break;
                    }
                }
            }
            if (l instanceof BaseLayer && ((BaseLayer)l).getActivationFn() == null) {
                try {
                    JsonNode jsonNode = mapper.readTree(json);
                    if (confs == null) {
                        confs = jsonNode.get("confs");
                    }
                    if (confs instanceof ArrayNode) {
                        ArrayNode layerConfs = (ArrayNode)confs;
                        JsonNode outputLayerNNCNode = layerConfs.get(layerCount);
                        if (outputLayerNNCNode == null) {
                            return conf;
                        }
                        JsonNode layerWrapperNode = outputLayerNNCNode.get("layer");
                        if (layerWrapperNode == null || layerWrapperNode.size() != 1) continue;
                        JsonNode layerNode = (JsonNode)layerWrapperNode.elements().next();
                        JsonNode activationFunction = layerNode.get("activationFunction");
                        if (activationFunction != null) {
                            IActivation ia = Activation.fromString((String)activationFunction.asText()).getActivationFunction();
                            ((BaseLayer)l).setActivationFn(ia);
                        }
                    }
                }
                catch (IOException e) {
                    log.warn("Layer with null ActivationFn field or pre-0.7.2 activation function detected: could not parse JSON", (Throwable)e);
                }
            }
            if (!MultiLayerConfiguration.handleLegacyWeightInitFromJson(json, l, mapper, confs, layerCount)) {
                return conf;
            }
            ++layerCount;
        }
        return conf;
    }

    private static boolean handleLegacyWeightInitFromJson(String json, Layer l, ObjectMapper mapper, JsonNode confs, int layerCount) {
        if (l instanceof BaseLayer && ((BaseLayer)l).getWeightInitFn() == null) {
            try {
                JsonNode jsonNode = mapper.readTree(json);
                if (confs == null) {
                    confs = jsonNode.get("confs");
                }
                if (confs instanceof ArrayNode) {
                    ArrayNode layerConfs = (ArrayNode)confs;
                    JsonNode outputLayerNNCNode = layerConfs.get(layerCount);
                    if (outputLayerNNCNode == null) {
                        return false;
                    }
                    JsonNode layerWrapperNode = outputLayerNNCNode.get("layer");
                    if (layerWrapperNode == null || layerWrapperNode.size() != 1) {
                        return true;
                    }
                    JsonNode layerNode = (JsonNode)layerWrapperNode.elements().next();
                    JsonNode weightInit = layerNode.get("weightInit");
                    JsonNode distribution = layerNode.get("dist");
                    Distribution dist = null;
                    if (distribution != null) {
                        dist = (Distribution)mapper.treeToValue((TreeNode)distribution, Distribution.class);
                    }
                    if (weightInit != null) {
                        IWeightInit wi = WeightInit.valueOf(weightInit.asText()).getWeightInitFunction(dist);
                        ((BaseLayer)l).setWeightInitFn(wi);
                    }
                }
            }
            catch (IOException e) {
                log.warn("Layer with null WeightInit detected: " + l.getLayerName() + ", could not parse JSON", (Throwable)e);
            }
        }
        return true;
    }

    public String toString() {
        return this.toJson();
    }

    public NeuralNetConfiguration getConf(int i) {
        return this.confs.get(i);
    }

    public MultiLayerConfiguration clone() {
        try {
            MultiLayerConfiguration clone = (MultiLayerConfiguration)super.clone();
            if (clone.confs != null) {
                ArrayList<NeuralNetConfiguration> list = new ArrayList<NeuralNetConfiguration>();
                for (NeuralNetConfiguration neuralNetConfiguration : clone.confs) {
                    list.add(neuralNetConfiguration.clone());
                }
                clone.confs = list;
            }
            if (clone.inputPreProcessors != null) {
                HashMap<Integer, InputPreProcessor> map = new HashMap<Integer, InputPreProcessor>();
                for (Map.Entry entry : clone.inputPreProcessors.entrySet()) {
                    map.put((Integer)entry.getKey(), ((InputPreProcessor)entry.getValue()).clone());
                }
                clone.inputPreProcessors = map;
            }
            clone.inferenceWorkspaceMode = this.inferenceWorkspaceMode;
            clone.trainingWorkspaceMode = this.trainingWorkspaceMode;
            clone.cacheMode = this.cacheMode;
            clone.validateOutputLayerConfig = this.validateOutputLayerConfig;
            clone.dataType = this.dataType;
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public InputPreProcessor getInputPreProcess(int curr) {
        return this.inputPreProcessors.get(curr);
    }

    public NetworkMemoryReport getMemoryReport(InputType inputType) {
        LinkedHashMap<String, MemoryReport> memoryReportMap = new LinkedHashMap<String, MemoryReport>();
        int nLayers = this.confs.size();
        for (int i = 0; i < nLayers; ++i) {
            InputPreProcessor preproc;
            String layerName = this.confs.get(i).getLayer().getLayerName();
            if (layerName == null) {
                layerName = String.valueOf(i);
            }
            if ((preproc = this.getInputPreProcess(i)) != null) {
                inputType = preproc.getOutputType(inputType);
            }
            LayerMemoryReport report = this.confs.get(i).getLayer().getMemoryReport(inputType);
            memoryReportMap.put(layerName, report);
            inputType = this.confs.get(i).getLayer().getOutputType(i, inputType);
        }
        return new NetworkMemoryReport(memoryReportMap, MultiLayerConfiguration.class, "MultiLayerNetwork", inputType);
    }

    public List<InputType> getLayerActivationTypes(@NonNull InputType inputType) {
        if (inputType == null) {
            throw new NullPointerException("inputType is marked @NonNull but is null");
        }
        ArrayList<InputType> out = new ArrayList<InputType>();
        int nLayers = this.confs.size();
        for (int i = 0; i < nLayers; ++i) {
            InputPreProcessor preproc = this.getInputPreProcess(i);
            if (preproc != null) {
                inputType = preproc.getOutputType(inputType);
            }
            inputType = this.confs.get(i).getLayer().getOutputType(i, inputType);
            out.add(inputType);
        }
        return out;
    }

    public List<NeuralNetConfiguration> getConfs() {
        return this.confs;
    }

    public Map<Integer, InputPreProcessor> getInputPreProcessors() {
        return this.inputPreProcessors;
    }

    public BackpropType getBackpropType() {
        return this.backpropType;
    }

    public int getTbpttFwdLength() {
        return this.tbpttFwdLength;
    }

    public int getTbpttBackLength() {
        return this.tbpttBackLength;
    }

    public boolean isValidateOutputLayerConfig() {
        return this.validateOutputLayerConfig;
    }

    public int getIterationCount() {
        return this.iterationCount;
    }

    public void setConfs(List<NeuralNetConfiguration> confs) {
        this.confs = confs;
    }

    public void setInputPreProcessors(Map<Integer, InputPreProcessor> inputPreProcessors) {
        this.inputPreProcessors = inputPreProcessors;
    }

    public void setBackpropType(BackpropType backpropType) {
        this.backpropType = backpropType;
    }

    public void setTbpttFwdLength(int tbpttFwdLength) {
        this.tbpttFwdLength = tbpttFwdLength;
    }

    public void setTbpttBackLength(int tbpttBackLength) {
        this.tbpttBackLength = tbpttBackLength;
    }

    public void setValidateOutputLayerConfig(boolean validateOutputLayerConfig) {
        this.validateOutputLayerConfig = validateOutputLayerConfig;
    }

    public void setIterationCount(int iterationCount) {
        this.iterationCount = iterationCount;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MultiLayerConfiguration)) {
            return false;
        }
        MultiLayerConfiguration other = (MultiLayerConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<NeuralNetConfiguration> this$confs = this.getConfs();
        List<NeuralNetConfiguration> other$confs = other.getConfs();
        if (this$confs == null ? other$confs != null : !((Object)this$confs).equals(other$confs)) {
            return false;
        }
        Map<Integer, InputPreProcessor> this$inputPreProcessors = this.getInputPreProcessors();
        Map<Integer, InputPreProcessor> other$inputPreProcessors = other.getInputPreProcessors();
        if (this$inputPreProcessors == null ? other$inputPreProcessors != null : !((Object)this$inputPreProcessors).equals(other$inputPreProcessors)) {
            return false;
        }
        BackpropType this$backpropType = this.getBackpropType();
        BackpropType other$backpropType = other.getBackpropType();
        if (this$backpropType == null ? other$backpropType != null : !((Object)((Object)this$backpropType)).equals((Object)other$backpropType)) {
            return false;
        }
        if (this.getTbpttFwdLength() != other.getTbpttFwdLength()) {
            return false;
        }
        if (this.getTbpttBackLength() != other.getTbpttBackLength()) {
            return false;
        }
        if (this.isValidateOutputLayerConfig() != other.isValidateOutputLayerConfig()) {
            return false;
        }
        WorkspaceMode this$trainingWorkspaceMode = this.getTrainingWorkspaceMode();
        WorkspaceMode other$trainingWorkspaceMode = other.getTrainingWorkspaceMode();
        if (this$trainingWorkspaceMode == null ? other$trainingWorkspaceMode != null : !((Object)((Object)this$trainingWorkspaceMode)).equals((Object)other$trainingWorkspaceMode)) {
            return false;
        }
        WorkspaceMode this$inferenceWorkspaceMode = this.getInferenceWorkspaceMode();
        WorkspaceMode other$inferenceWorkspaceMode = other.getInferenceWorkspaceMode();
        if (this$inferenceWorkspaceMode == null ? other$inferenceWorkspaceMode != null : !((Object)((Object)this$inferenceWorkspaceMode)).equals((Object)other$inferenceWorkspaceMode)) {
            return false;
        }
        CacheMode this$cacheMode = this.getCacheMode();
        CacheMode other$cacheMode = other.getCacheMode();
        if (this$cacheMode == null ? other$cacheMode != null : !((Object)((Object)this$cacheMode)).equals((Object)other$cacheMode)) {
            return false;
        }
        DataType this$dataType = this.getDataType();
        DataType other$dataType = other.getDataType();
        if (this$dataType == null ? other$dataType != null : !this$dataType.equals(other$dataType)) {
            return false;
        }
        if (this.getIterationCount() != other.getIterationCount()) {
            return false;
        }
        return this.getEpochCount() == other.getEpochCount();
    }

    protected boolean canEqual(Object other) {
        return other instanceof MultiLayerConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<NeuralNetConfiguration> $confs = this.getConfs();
        result = result * 59 + ($confs == null ? 43 : ((Object)$confs).hashCode());
        Map<Integer, InputPreProcessor> $inputPreProcessors = this.getInputPreProcessors();
        result = result * 59 + ($inputPreProcessors == null ? 43 : ((Object)$inputPreProcessors).hashCode());
        BackpropType $backpropType = this.getBackpropType();
        result = result * 59 + ($backpropType == null ? 43 : ((Object)((Object)$backpropType)).hashCode());
        result = result * 59 + this.getTbpttFwdLength();
        result = result * 59 + this.getTbpttBackLength();
        result = result * 59 + (this.isValidateOutputLayerConfig() ? 79 : 97);
        WorkspaceMode $trainingWorkspaceMode = this.getTrainingWorkspaceMode();
        result = result * 59 + ($trainingWorkspaceMode == null ? 43 : ((Object)((Object)$trainingWorkspaceMode)).hashCode());
        WorkspaceMode $inferenceWorkspaceMode = this.getInferenceWorkspaceMode();
        result = result * 59 + ($inferenceWorkspaceMode == null ? 43 : ((Object)((Object)$inferenceWorkspaceMode)).hashCode());
        CacheMode $cacheMode = this.getCacheMode();
        result = result * 59 + ($cacheMode == null ? 43 : ((Object)((Object)$cacheMode)).hashCode());
        DataType $dataType = this.getDataType();
        result = result * 59 + ($dataType == null ? 43 : $dataType.hashCode());
        result = result * 59 + this.getIterationCount();
        result = result * 59 + this.getEpochCount();
        return result;
    }

    private MultiLayerConfiguration(List<NeuralNetConfiguration> confs, Map<Integer, InputPreProcessor> inputPreProcessors, BackpropType backpropType, int tbpttFwdLength, int tbpttBackLength, boolean validateOutputLayerConfig, WorkspaceMode trainingWorkspaceMode, WorkspaceMode inferenceWorkspaceMode, CacheMode cacheMode, DataType dataType, int iterationCount, int epochCount) {
        this.confs = confs;
        this.inputPreProcessors = inputPreProcessors;
        this.backpropType = backpropType;
        this.tbpttFwdLength = tbpttFwdLength;
        this.tbpttBackLength = tbpttBackLength;
        this.validateOutputLayerConfig = validateOutputLayerConfig;
        this.trainingWorkspaceMode = trainingWorkspaceMode;
        this.inferenceWorkspaceMode = inferenceWorkspaceMode;
        this.cacheMode = cacheMode;
        this.dataType = dataType;
        this.iterationCount = iterationCount;
        this.epochCount = epochCount;
    }

    public MultiLayerConfiguration() {
    }

    public WorkspaceMode getTrainingWorkspaceMode() {
        return this.trainingWorkspaceMode;
    }

    public void setTrainingWorkspaceMode(WorkspaceMode trainingWorkspaceMode) {
        this.trainingWorkspaceMode = trainingWorkspaceMode;
    }

    public WorkspaceMode getInferenceWorkspaceMode() {
        return this.inferenceWorkspaceMode;
    }

    public void setInferenceWorkspaceMode(WorkspaceMode inferenceWorkspaceMode) {
        this.inferenceWorkspaceMode = inferenceWorkspaceMode;
    }

    public CacheMode getCacheMode() {
        return this.cacheMode;
    }

    public void setCacheMode(CacheMode cacheMode) {
        this.cacheMode = cacheMode;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public void setDataType(DataType dataType) {
        this.dataType = dataType;
    }

    public static class Builder {
        private static final int DEFAULT_TBPTT_LENGTH = 20;
        protected List<NeuralNetConfiguration> confs = new ArrayList<NeuralNetConfiguration>();
        protected double dampingFactor = 100.0;
        protected Map<Integer, InputPreProcessor> inputPreProcessors = new HashMap<Integer, InputPreProcessor>();
        protected BackpropType backpropType = BackpropType.Standard;
        protected int tbpttFwdLength = 20;
        protected int tbpttBackLength = 20;
        protected InputType inputType;
        protected WorkspaceMode trainingWorkspaceMode = WorkspaceMode.ENABLED;
        protected WorkspaceMode inferenceWorkspaceMode = WorkspaceMode.ENABLED;
        protected CacheMode cacheMode = CacheMode.NONE;
        protected boolean validateOutputConfig = true;
        protected boolean validateTbpttConfig = true;
        protected DataType dataType;

        public Builder inputPreProcessor(Integer layer, InputPreProcessor processor) {
            this.inputPreProcessors.put(layer, processor);
            return this;
        }

        public Builder inputPreProcessors(Map<Integer, InputPreProcessor> processors) {
            this.inputPreProcessors = processors;
            return this;
        }

        @Deprecated
        public Builder trainingWorkspaceMode(@NonNull WorkspaceMode workspaceMode) {
            if (workspaceMode == null) {
                throw new NullPointerException("workspaceMode is marked @NonNull but is null");
            }
            this.trainingWorkspaceMode = workspaceMode;
            return this;
        }

        @Deprecated
        public Builder inferenceWorkspaceMode(@NonNull WorkspaceMode workspaceMode) {
            if (workspaceMode == null) {
                throw new NullPointerException("workspaceMode is marked @NonNull but is null");
            }
            this.inferenceWorkspaceMode = workspaceMode;
            return this;
        }

        public Builder cacheMode(@NonNull CacheMode cacheMode) {
            if (cacheMode == null) {
                throw new NullPointerException("cacheMode is marked @NonNull but is null");
            }
            this.cacheMode = cacheMode;
            return this;
        }

        public Builder backpropType(@NonNull BackpropType type) {
            if (type == null) {
                throw new NullPointerException("type is marked @NonNull but is null");
            }
            this.backpropType = type;
            return this;
        }

        public Builder tBPTTLength(int bpttLength) {
            this.tBPTTForwardLength(bpttLength);
            return this.tBPTTBackwardLength(bpttLength);
        }

        public Builder tBPTTForwardLength(int forwardLength) {
            this.tbpttFwdLength = forwardLength;
            return this;
        }

        public Builder tBPTTBackwardLength(int backwardLength) {
            this.tbpttBackLength = backwardLength;
            return this;
        }

        public Builder confs(List<NeuralNetConfiguration> confs) {
            this.confs = confs;
            return this;
        }

        public Builder setInputType(InputType inputType) {
            this.inputType = inputType;
            return this;
        }

        public Builder validateOutputLayerConfig(boolean validate) {
            this.validateOutputConfig = validate;
            return this;
        }

        public Builder validateTbpttConfig(boolean validate) {
            this.validateTbpttConfig = validate;
            return this;
        }

        public Builder dataType(@NonNull DataType dataType) {
            if (dataType == null) {
                throw new NullPointerException("dataType is marked @NonNull but is null");
            }
            this.dataType = dataType;
            return this;
        }

        public MultiLayerConfiguration build() {
            if ((this.tbpttBackLength != 20 || this.tbpttFwdLength != 20) && this.backpropType != BackpropType.TruncatedBPTT) {
                log.warn("Truncated backpropagation through time lengths have been configured with values " + this.tbpttFwdLength + " and " + this.tbpttBackLength + " but backprop type is set to " + (Object)((Object)this.backpropType) + ". TBPTT configuration settings will only take effect if backprop type is set to BackpropType.TruncatedBPTT");
            }
            if (this.backpropType == BackpropType.TruncatedBPTT && this.validateTbpttConfig) {
                for (int i = 0; i < this.confs.size(); ++i) {
                    Layer l = this.confs.get(i).getLayer();
                    if (!(l instanceof LastTimeStep) && !(l instanceof GlobalPoolingLayer)) continue;
                    throw new IllegalStateException("Invalid network configuration detected: Truncated backpropagation through time (TBPTT) cannot be used with layer " + i + " of type " + l.getClass().getName() + ": TBPTT is incompatible with this layer type (which is designed to process entire sequences at once, and does support the type of sequence segments that TPBTT uses).\nThis check can be disabled using validateTbpttConfig(false) but this is not recommended.");
                }
            }
            if (this.inputType == null && this.inputPreProcessors.get(0) == null) {
                FeedForwardLayer ffl;
                long nIn;
                Layer firstLayer = this.confs.get(0).getLayer();
                if (firstLayer instanceof BaseRecurrentLayer) {
                    BaseRecurrentLayer brl = (BaseRecurrentLayer)firstLayer;
                    nIn = brl.getNIn();
                    if (nIn > 0L) {
                        this.inputType = InputType.recurrent(nIn);
                    }
                } else if ((firstLayer instanceof DenseLayer || firstLayer instanceof EmbeddingLayer || firstLayer instanceof OutputLayer) && (nIn = (ffl = (FeedForwardLayer)firstLayer).getNIn()) > 0L) {
                    this.inputType = InputType.feedForward(nIn);
                }
            }
            if (this.inputType != null) {
                InputType currentInputType = this.inputType;
                for (int i = 0; i < this.confs.size(); ++i) {
                    InputPreProcessor inputPreProcessor;
                    Layer l = this.confs.get(i).getLayer();
                    if (this.inputPreProcessors.get(i) == null && (inputPreProcessor = l.getPreProcessorForInputType(currentInputType)) != null) {
                        this.inputPreProcessors.put(i, inputPreProcessor);
                    }
                    if ((inputPreProcessor = this.inputPreProcessors.get(i)) != null) {
                        currentInputType = inputPreProcessor.getOutputType(currentInputType);
                    }
                    l.setNIn(currentInputType, false);
                    currentInputType = l.getOutputType(i, currentInputType);
                }
            }
            MultiLayerConfiguration conf = new MultiLayerConfiguration();
            conf.confs = this.confs;
            conf.inputPreProcessors = this.inputPreProcessors;
            conf.backpropType = this.backpropType;
            conf.tbpttFwdLength = this.tbpttFwdLength;
            conf.tbpttBackLength = this.tbpttBackLength;
            conf.trainingWorkspaceMode = this.trainingWorkspaceMode;
            conf.inferenceWorkspaceMode = this.inferenceWorkspaceMode;
            conf.cacheMode = this.cacheMode;
            conf.dataType = this.dataType;
            Nd4j.getRandom().setSeed(conf.getConf(0).getSeed());
            if (this.validateOutputConfig) {
                for (NeuralNetConfiguration n : conf.getConfs()) {
                    Layer l = n.getLayer();
                    OutputLayerUtil.validateOutputLayer(l.getLayerName(), l);
                }
            }
            return conf;
        }

        public List<NeuralNetConfiguration> getConfs() {
            return this.confs;
        }

        public double getDampingFactor() {
            return this.dampingFactor;
        }

        public Map<Integer, InputPreProcessor> getInputPreProcessors() {
            return this.inputPreProcessors;
        }

        public BackpropType getBackpropType() {
            return this.backpropType;
        }

        public int getTbpttFwdLength() {
            return this.tbpttFwdLength;
        }

        public int getTbpttBackLength() {
            return this.tbpttBackLength;
        }

        public InputType getInputType() {
            return this.inputType;
        }

        public WorkspaceMode getTrainingWorkspaceMode() {
            return this.trainingWorkspaceMode;
        }

        public WorkspaceMode getInferenceWorkspaceMode() {
            return this.inferenceWorkspaceMode;
        }

        public CacheMode getCacheMode() {
            return this.cacheMode;
        }

        public boolean isValidateOutputConfig() {
            return this.validateOutputConfig;
        }

        public boolean isValidateTbpttConfig() {
            return this.validateTbpttConfig;
        }

        public DataType getDataType() {
            return this.dataType;
        }

        public void setConfs(List<NeuralNetConfiguration> confs) {
            this.confs = confs;
        }

        public void setDampingFactor(double dampingFactor) {
            this.dampingFactor = dampingFactor;
        }

        public void setInputPreProcessors(Map<Integer, InputPreProcessor> inputPreProcessors) {
            this.inputPreProcessors = inputPreProcessors;
        }

        public void setBackpropType(BackpropType backpropType) {
            this.backpropType = backpropType;
        }

        public void setTbpttFwdLength(int tbpttFwdLength) {
            this.tbpttFwdLength = tbpttFwdLength;
        }

        public void setTbpttBackLength(int tbpttBackLength) {
            this.tbpttBackLength = tbpttBackLength;
        }

        public void setTrainingWorkspaceMode(WorkspaceMode trainingWorkspaceMode) {
            this.trainingWorkspaceMode = trainingWorkspaceMode;
        }

        public void setInferenceWorkspaceMode(WorkspaceMode inferenceWorkspaceMode) {
            this.inferenceWorkspaceMode = inferenceWorkspaceMode;
        }

        public void setCacheMode(CacheMode cacheMode) {
            this.cacheMode = cacheMode;
        }

        public void setValidateOutputConfig(boolean validateOutputConfig) {
            this.validateOutputConfig = validateOutputConfig;
        }

        public void setValidateTbpttConfig(boolean validateTbpttConfig) {
            this.validateTbpttConfig = validateTbpttConfig;
        }

        public void setDataType(DataType dataType) {
            this.dataType = dataType;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Builder)) {
                return false;
            }
            Builder other = (Builder)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<NeuralNetConfiguration> this$confs = this.getConfs();
            List<NeuralNetConfiguration> other$confs = other.getConfs();
            if (this$confs == null ? other$confs != null : !((Object)this$confs).equals(other$confs)) {
                return false;
            }
            if (Double.compare(this.getDampingFactor(), other.getDampingFactor()) != 0) {
                return false;
            }
            Map<Integer, InputPreProcessor> this$inputPreProcessors = this.getInputPreProcessors();
            Map<Integer, InputPreProcessor> other$inputPreProcessors = other.getInputPreProcessors();
            if (this$inputPreProcessors == null ? other$inputPreProcessors != null : !((Object)this$inputPreProcessors).equals(other$inputPreProcessors)) {
                return false;
            }
            BackpropType this$backpropType = this.getBackpropType();
            BackpropType other$backpropType = other.getBackpropType();
            if (this$backpropType == null ? other$backpropType != null : !((Object)((Object)this$backpropType)).equals((Object)other$backpropType)) {
                return false;
            }
            if (this.getTbpttFwdLength() != other.getTbpttFwdLength()) {
                return false;
            }
            if (this.getTbpttBackLength() != other.getTbpttBackLength()) {
                return false;
            }
            InputType this$inputType = this.getInputType();
            InputType other$inputType = other.getInputType();
            if (this$inputType == null ? other$inputType != null : !this$inputType.equals(other$inputType)) {
                return false;
            }
            WorkspaceMode this$trainingWorkspaceMode = this.getTrainingWorkspaceMode();
            WorkspaceMode other$trainingWorkspaceMode = other.getTrainingWorkspaceMode();
            if (this$trainingWorkspaceMode == null ? other$trainingWorkspaceMode != null : !((Object)((Object)this$trainingWorkspaceMode)).equals((Object)other$trainingWorkspaceMode)) {
                return false;
            }
            WorkspaceMode this$inferenceWorkspaceMode = this.getInferenceWorkspaceMode();
            WorkspaceMode other$inferenceWorkspaceMode = other.getInferenceWorkspaceMode();
            if (this$inferenceWorkspaceMode == null ? other$inferenceWorkspaceMode != null : !((Object)((Object)this$inferenceWorkspaceMode)).equals((Object)other$inferenceWorkspaceMode)) {
                return false;
            }
            CacheMode this$cacheMode = this.getCacheMode();
            CacheMode other$cacheMode = other.getCacheMode();
            if (this$cacheMode == null ? other$cacheMode != null : !((Object)((Object)this$cacheMode)).equals((Object)other$cacheMode)) {
                return false;
            }
            if (this.isValidateOutputConfig() != other.isValidateOutputConfig()) {
                return false;
            }
            if (this.isValidateTbpttConfig() != other.isValidateTbpttConfig()) {
                return false;
            }
            DataType this$dataType = this.getDataType();
            DataType other$dataType = other.getDataType();
            return !(this$dataType == null ? other$dataType != null : !this$dataType.equals(other$dataType));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Builder;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<NeuralNetConfiguration> $confs = this.getConfs();
            result = result * 59 + ($confs == null ? 43 : ((Object)$confs).hashCode());
            long $dampingFactor = Double.doubleToLongBits(this.getDampingFactor());
            result = result * 59 + (int)($dampingFactor >>> 32 ^ $dampingFactor);
            Map<Integer, InputPreProcessor> $inputPreProcessors = this.getInputPreProcessors();
            result = result * 59 + ($inputPreProcessors == null ? 43 : ((Object)$inputPreProcessors).hashCode());
            BackpropType $backpropType = this.getBackpropType();
            result = result * 59 + ($backpropType == null ? 43 : ((Object)((Object)$backpropType)).hashCode());
            result = result * 59 + this.getTbpttFwdLength();
            result = result * 59 + this.getTbpttBackLength();
            InputType $inputType = this.getInputType();
            result = result * 59 + ($inputType == null ? 43 : $inputType.hashCode());
            WorkspaceMode $trainingWorkspaceMode = this.getTrainingWorkspaceMode();
            result = result * 59 + ($trainingWorkspaceMode == null ? 43 : ((Object)((Object)$trainingWorkspaceMode)).hashCode());
            WorkspaceMode $inferenceWorkspaceMode = this.getInferenceWorkspaceMode();
            result = result * 59 + ($inferenceWorkspaceMode == null ? 43 : ((Object)((Object)$inferenceWorkspaceMode)).hashCode());
            CacheMode $cacheMode = this.getCacheMode();
            result = result * 59 + ($cacheMode == null ? 43 : ((Object)((Object)$cacheMode)).hashCode());
            result = result * 59 + (this.isValidateOutputConfig() ? 79 : 97);
            result = result * 59 + (this.isValidateTbpttConfig() ? 79 : 97);
            DataType $dataType = this.getDataType();
            result = result * 59 + ($dataType == null ? 43 : $dataType.hashCode());
            return result;
        }

        public String toString() {
            return "MultiLayerConfiguration.Builder(confs=" + this.getConfs() + ", dampingFactor=" + this.getDampingFactor() + ", inputPreProcessors=" + this.getInputPreProcessors() + ", backpropType=" + (Object)((Object)this.getBackpropType()) + ", tbpttFwdLength=" + this.getTbpttFwdLength() + ", tbpttBackLength=" + this.getTbpttBackLength() + ", inputType=" + this.getInputType() + ", trainingWorkspaceMode=" + (Object)((Object)this.getTrainingWorkspaceMode()) + ", inferenceWorkspaceMode=" + (Object)((Object)this.getInferenceWorkspaceMode()) + ", cacheMode=" + (Object)((Object)this.getCacheMode()) + ", validateOutputConfig=" + this.isValidateOutputConfig() + ", validateTbpttConfig=" + this.isValidateTbpttConfig() + ", dataType=" + this.getDataType() + ")";
        }
    }
}

