/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.util;

import org.nd4j.base.Preconditions;

public class ValidationUtils {
    private ValidationUtils() {
    }

    public static void validateNonNegative(int data, String paramName) {
        Preconditions.checkArgument((data >= 0 ? 1 : 0) != 0, (String)"Values for %s must be >= 0, got: %s", (Object)paramName, (Object)data);
    }

    public static void validateNonNegative(double data, String paramName) {
        Preconditions.checkArgument((data >= 0.0 ? 1 : 0) != 0, (String)"Values for %s must be >= 0, got: %s", (Object)paramName, (Object)data);
    }

    public static void validateNonNegative(int[] data, String paramName) {
        if (data == null) {
            return;
        }
        boolean nonnegative = true;
        for (int value : data) {
            if (value >= 0) continue;
            nonnegative = false;
        }
        Preconditions.checkArgument((boolean)nonnegative, (String)"Values for %s must be >= 0, got: %s", (Object)paramName, (Object)data);
    }

    public static int[] validate1NonNegative(int[] data, String paramName) {
        ValidationUtils.validateNonNegative(data, paramName);
        return ValidationUtils.validate1(data, paramName);
    }

    public static int[] validate1(int[] data, String paramName) {
        if (data == null) {
            return null;
        }
        Preconditions.checkArgument((data.length == 1 ? 1 : 0) != 0, (String)"Need 1 %s value, got %s values: %s", (Object)paramName, (Object)data.length, (Object)data);
        return data;
    }

    public static int[] validate2NonNegative(int[] data, boolean allowSz1, String paramName) {
        ValidationUtils.validateNonNegative(data, paramName);
        return ValidationUtils.validate2(data, allowSz1, paramName);
    }

    public static int[] validate2(int[] data, boolean allowSz1, String paramName) {
        if (data == null) {
            return null;
        }
        if (allowSz1) {
            Preconditions.checkArgument((data.length == 1 || data.length == 2 ? 1 : 0) != 0, (String)"Need either 1 or 2 %s values, got %s values: %s", (Object)paramName, (Object)data.length, (Object)data);
        } else {
            Preconditions.checkArgument((data.length == 2 ? 1 : 0) != 0, (String)"Need 2 %s values, got %s values: %s", (Object)paramName, (Object)data.length, (Object)data);
        }
        if (data.length == 1) {
            return new int[]{data[0], data[0]};
        }
        return data;
    }

    public static int[][] validate2x2NonNegative(int[][] data, String paramName) {
        for (int[] part : data) {
            ValidationUtils.validateNonNegative(part, paramName);
        }
        return ValidationUtils.validate2x2(data, paramName);
    }

    public static int[][] validate2x2(int[][] data, String paramName) {
        if (data == null) {
            return null;
        }
        Preconditions.checkArgument((data.length == 1 && data[0].length == 2 || data.length == 2 && (data[0].length == 1 || data[0].length == 2) && (data[1].length == 1 || data[1].length == 2) && data[0].length == data[1].length ? 1 : 0) != 0, (String)"Value for %s must have shape 2x1, 1x2, or 2x2, got %sx%s shaped array: %s", (Object)paramName, (Object)data.length, (Object)data[0].length, (Object)data);
        if (data.length == 1) {
            return new int[][]{data[0], data[0]};
        }
        if (data[0].length == 1) {
            return new int[][]{{data[0][0], data[0][0]}, {data[1][0], data[1][0]}};
        }
        return data;
    }

    public static int[] validate3NonNegative(int[] data, String paramName) {
        ValidationUtils.validateNonNegative(data, paramName);
        return ValidationUtils.validate3(data, paramName);
    }

    public static int[] validate3(int[] data, String paramName) {
        if (data == null) {
            return null;
        }
        Preconditions.checkArgument((data.length == 1 || data.length == 3 ? 1 : 0) != 0, (String)"Need either 1 or 3 %s values, got %s values: %s", (Object)paramName, (Object)data.length, (Object)data);
        if (data.length == 1) {
            return new int[]{data[0], data[0], data[0]};
        }
        return data;
    }

    public static int[] validate4NonNegative(int[] data, String paramName) {
        ValidationUtils.validateNonNegative(data, paramName);
        return ValidationUtils.validate4(data, paramName);
    }

    public static int[] validate4(int[] data, String paramName) {
        if (data == null) {
            return null;
        }
        Preconditions.checkArgument((data.length == 1 || data.length == 2 || data.length == 4 ? 1 : 0) != 0, (String)"Need either 1, 2, or 4 %s values, got %s values: %s", (Object)paramName, (Object)data.length, (Object)data);
        if (data.length == 1) {
            return new int[]{data[0], data[0], data[0], data[0]};
        }
        if (data.length == 2) {
            return new int[]{data[0], data[0], data[1], data[1]};
        }
        return data;
    }

    public static int[] validate6NonNegative(int[] data, String paramName) {
        ValidationUtils.validateNonNegative(data, paramName);
        return ValidationUtils.validate6(data, paramName);
    }

    public static int[] validate6(int[] data, String paramName) {
        if (data == null) {
            return null;
        }
        Preconditions.checkArgument((data.length == 1 || data.length == 3 || data.length == 6 ? 1 : 0) != 0, (String)"Need either 1, 3, or 6 %s values, got %s values: %s", (Object)paramName, (Object)data.length, (Object)data);
        if (data.length == 1) {
            return new int[]{data[0], data[0], data[0], data[0], data[0], data[0]};
        }
        if (data.length == 3) {
            return new int[]{data[0], data[0], data[1], data[1], data[2], data[2]};
        }
        return data;
    }
}

