/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.util;

import com.google.common.io.Files;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import lombok.NonNull;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.CloseShieldOutputStream;
import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.api.Model;
import org.deeplearning4j.nn.conf.ComputationGraphConfiguration;
import org.deeplearning4j.nn.conf.MultiLayerConfiguration;
import org.deeplearning4j.nn.graph.ComputationGraph;
import org.deeplearning4j.nn.multilayer.MultiLayerNetwork;
import org.deeplearning4j.util.DL4JFileUtils;
import org.nd4j.base.Preconditions;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.dataset.api.DataSetPreProcessor;
import org.nd4j.linalg.dataset.api.preprocessor.DataNormalization;
import org.nd4j.linalg.dataset.api.preprocessor.Normalizer;
import org.nd4j.linalg.dataset.api.preprocessor.serializer.NormalizerSerializer;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.heartbeat.reports.Task;
import org.nd4j.linalg.primitives.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelSerializer {
    private static final Logger log = LoggerFactory.getLogger(ModelSerializer.class);
    public static final String UPDATER_BIN = "updaterState.bin";
    public static final String NORMALIZER_BIN = "normalizer.bin";
    public static final String CONFIGURATION_JSON = "configuration.json";
    public static final String COEFFICIENTS_BIN = "coefficients.bin";
    public static final String NO_PARAMS_MARKER = "noParams.marker";
    public static final String PREPROCESSOR_BIN = "preprocessor.bin";

    private ModelSerializer() {
    }

    public static void writeModel(@NonNull Model model, @NonNull File file, boolean saveUpdater) throws IOException {
        if (model == null) {
            throw new NullPointerException("model is marked @NonNull but is null");
        }
        if (file == null) {
            throw new NullPointerException("file is marked @NonNull but is null");
        }
        ModelSerializer.writeModel(model, file, saveUpdater, null);
    }

    public static void writeModel(@NonNull Model model, @NonNull File file, boolean saveUpdater, DataNormalization dataNormalization) throws IOException {
        if (model == null) {
            throw new NullPointerException("model is marked @NonNull but is null");
        }
        if (file == null) {
            throw new NullPointerException("file is marked @NonNull but is null");
        }
        try (BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(file));){
            ModelSerializer.writeModel(model, stream, saveUpdater, dataNormalization);
        }
    }

    public static void writeModel(@NonNull Model model, @NonNull String path, boolean saveUpdater) throws IOException {
        if (model == null) {
            throw new NullPointerException("model is marked @NonNull but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked @NonNull but is null");
        }
        try (BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(path));){
            ModelSerializer.writeModel(model, stream, saveUpdater);
        }
    }

    public static void writeModel(@NonNull Model model, @NonNull OutputStream stream, boolean saveUpdater) throws IOException {
        if (model == null) {
            throw new NullPointerException("model is marked @NonNull but is null");
        }
        if (stream == null) {
            throw new NullPointerException("stream is marked @NonNull but is null");
        }
        ModelSerializer.writeModel(model, stream, saveUpdater, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeModel(@NonNull Model model, @NonNull OutputStream stream, boolean saveUpdater, DataNormalization dataNormalization) throws IOException {
        if (model == null) {
            throw new NullPointerException("model is marked @NonNull but is null");
        }
        if (stream == null) {
            throw new NullPointerException("stream is marked @NonNull but is null");
        }
        ZipOutputStream zipfile = new ZipOutputStream((OutputStream)new CloseShieldOutputStream(stream));
        String json = "";
        if (model instanceof MultiLayerNetwork) {
            json = ((MultiLayerNetwork)model).getLayerWiseConfigurations().toJson();
        } else if (model instanceof ComputationGraph) {
            json = ((ComputationGraph)model).getConfiguration().toJson();
        }
        ZipEntry config = new ZipEntry(CONFIGURATION_JSON);
        zipfile.putNextEntry(config);
        zipfile.write(json.getBytes());
        ZipEntry coefficients = new ZipEntry(COEFFICIENTS_BIN);
        zipfile.putNextEntry(coefficients);
        DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(zipfile));
        INDArray params = model.params();
        if (params != null) {
            try {
                Nd4j.write((INDArray)model.params(), (DataOutputStream)dos);
            }
            finally {
                dos.flush();
            }
        } else {
            ZipEntry noParamsMarker = new ZipEntry(NO_PARAMS_MARKER);
            zipfile.putNextEntry(noParamsMarker);
        }
        if (saveUpdater) {
            INDArray updaterState = null;
            if (model instanceof MultiLayerNetwork) {
                updaterState = ((MultiLayerNetwork)model).getUpdater().getStateViewArray();
            } else if (model instanceof ComputationGraph) {
                updaterState = ((ComputationGraph)model).getUpdater().getStateViewArray();
            }
            if (updaterState != null && updaterState.length() > 0L) {
                ZipEntry updater = new ZipEntry(UPDATER_BIN);
                zipfile.putNextEntry(updater);
                try {
                    Nd4j.write((INDArray)updaterState, (DataOutputStream)dos);
                }
                finally {
                    dos.flush();
                }
            }
        }
        if (dataNormalization != null) {
            ZipEntry nEntry = new ZipEntry(NORMALIZER_BIN);
            zipfile.putNextEntry(nEntry);
            NormalizerSerializer.getDefault().write((Normalizer)dataNormalization, (OutputStream)zipfile);
        }
        dos.close();
        zipfile.close();
    }

    public static MultiLayerNetwork restoreMultiLayerNetwork(@NonNull File file) throws IOException {
        if (file == null) {
            throw new NullPointerException("file is marked @NonNull but is null");
        }
        return ModelSerializer.restoreMultiLayerNetwork(file, true);
    }

    public static MultiLayerNetwork restoreMultiLayerNetwork(@NonNull File file, boolean loadUpdater) throws IOException {
        ZipEntry prep;
        InputStream stream;
        ZipEntry updaterStateEntry;
        ZipEntry coefficients;
        if (file == null) {
            throw new NullPointerException("file is marked @NonNull but is null");
        }
        ZipFile zipFile = new ZipFile(file);
        boolean gotConfig = false;
        boolean gotCoefficients = false;
        boolean gotUpdaterState = false;
        boolean gotPreProcessor = false;
        String json = "";
        INDArray params = null;
        Object updater = null;
        INDArray updaterState = null;
        DataSetPreProcessor preProcessor = null;
        ZipEntry config = zipFile.getEntry(CONFIGURATION_JSON);
        if (config != null) {
            InputStream stream2 = zipFile.getInputStream(config);
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream2));
            String line = "";
            StringBuilder js = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                js.append(line).append("\n");
            }
            json = js.toString();
            reader.close();
            stream2.close();
            gotConfig = true;
        }
        if ((coefficients = zipFile.getEntry(COEFFICIENTS_BIN)) != null) {
            if (coefficients.getSize() > 0L) {
                InputStream stream3 = zipFile.getInputStream(coefficients);
                DataInputStream dis = new DataInputStream(new BufferedInputStream(stream3));
                params = Nd4j.read((DataInputStream)dis);
                dis.close();
                gotCoefficients = true;
            } else {
                ZipEntry noParamsMarker = zipFile.getEntry(NO_PARAMS_MARKER);
                boolean bl = gotCoefficients = noParamsMarker != null;
            }
        }
        if (loadUpdater && (updaterStateEntry = zipFile.getEntry(UPDATER_BIN)) != null) {
            stream = zipFile.getInputStream(updaterStateEntry);
            DataInputStream dis = new DataInputStream(new BufferedInputStream(stream));
            updaterState = Nd4j.read((DataInputStream)dis);
            dis.close();
            gotUpdaterState = true;
        }
        if ((prep = zipFile.getEntry(PREPROCESSOR_BIN)) != null) {
            stream = zipFile.getInputStream(prep);
            ObjectInputStream ois = new ObjectInputStream(stream);
            try {
                preProcessor = (DataSetPreProcessor)ois.readObject();
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            gotPreProcessor = true;
        }
        zipFile.close();
        if (gotConfig && gotCoefficients) {
            MultiLayerConfiguration confFromJson;
            try {
                confFromJson = MultiLayerConfiguration.fromJson(json);
            }
            catch (Exception e) {
                ComputationGraphConfiguration cg;
                try {
                    cg = ComputationGraphConfiguration.fromJson(json);
                }
                catch (Exception e2) {
                    throw new RuntimeException("Error deserializing JSON MultiLayerConfiguration. Saved model JSON is not a valid MultiLayerConfiguration", e);
                }
                if (cg.getNetworkInputs() != null && cg.getVertices() != null) {
                    throw new RuntimeException("Error deserializing JSON MultiLayerConfiguration. Saved model appears to be a ComputationGraph - use ModelSerializer.restoreComputationGraph instead");
                }
                throw e;
            }
            if (params != null) {
                confFromJson.setDataType(params.dataType());
            }
            MultiLayerNetwork network = new MultiLayerNetwork(confFromJson);
            network.init(params, false);
            if (gotUpdaterState && updaterState != null) {
                network.getUpdater().setStateViewArray(network, updaterState, false);
            }
            return network;
        }
        throw new IllegalStateException("Model wasnt found within file: gotConfig: [" + gotConfig + "], gotCoefficients: [" + gotCoefficients + "], gotUpdater: [" + gotUpdaterState + "]");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MultiLayerNetwork restoreMultiLayerNetwork(@NonNull InputStream is, boolean loadUpdater) throws IOException {
        if (is == null) {
            throw new NullPointerException("is is marked @NonNull but is null");
        }
        ModelSerializer.checkInputStream(is);
        File tmpFile = null;
        try {
            tmpFile = ModelSerializer.tempFileFromStream(is);
            MultiLayerNetwork multiLayerNetwork = ModelSerializer.restoreMultiLayerNetwork(tmpFile, loadUpdater);
            return multiLayerNetwork;
        }
        finally {
            if (tmpFile != null) {
                tmpFile.delete();
            }
        }
    }

    public static MultiLayerNetwork restoreMultiLayerNetwork(@NonNull InputStream is) throws IOException {
        if (is == null) {
            throw new NullPointerException("is is marked @NonNull but is null");
        }
        return ModelSerializer.restoreMultiLayerNetwork(is, true);
    }

    public static MultiLayerNetwork restoreMultiLayerNetwork(@NonNull String path) throws IOException {
        if (path == null) {
            throw new NullPointerException("path is marked @NonNull but is null");
        }
        return ModelSerializer.restoreMultiLayerNetwork(new File(path), true);
    }

    public static MultiLayerNetwork restoreMultiLayerNetwork(@NonNull String path, boolean loadUpdater) throws IOException {
        if (path == null) {
            throw new NullPointerException("path is marked @NonNull but is null");
        }
        return ModelSerializer.restoreMultiLayerNetwork(new File(path), loadUpdater);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Pair<MultiLayerNetwork, Normalizer> restoreMultiLayerNetworkAndNormalizer(@NonNull InputStream is, boolean loadUpdater) throws IOException {
        if (is == null) {
            throw new NullPointerException("is is marked @NonNull but is null");
        }
        ModelSerializer.checkInputStream(is);
        File tmpFile = null;
        try {
            tmpFile = ModelSerializer.tempFileFromStream(is);
            Pair<MultiLayerNetwork, Normalizer> pair = ModelSerializer.restoreMultiLayerNetworkAndNormalizer(tmpFile, loadUpdater);
            return pair;
        }
        finally {
            if (tmpFile != null) {
                tmpFile.delete();
            }
        }
    }

    public static Pair<MultiLayerNetwork, Normalizer> restoreMultiLayerNetworkAndNormalizer(@NonNull File file, boolean loadUpdater) throws IOException {
        if (file == null) {
            throw new NullPointerException("file is marked @NonNull but is null");
        }
        MultiLayerNetwork net = ModelSerializer.restoreMultiLayerNetwork(file, loadUpdater);
        Object norm = ModelSerializer.restoreNormalizerFromFile(file);
        return new Pair((Object)net, norm);
    }

    public static ComputationGraph restoreComputationGraph(@NonNull String path) throws IOException {
        if (path == null) {
            throw new NullPointerException("path is marked @NonNull but is null");
        }
        return ModelSerializer.restoreComputationGraph(new File(path), true);
    }

    public static ComputationGraph restoreComputationGraph(@NonNull String path, boolean loadUpdater) throws IOException {
        if (path == null) {
            throw new NullPointerException("path is marked @NonNull but is null");
        }
        return ModelSerializer.restoreComputationGraph(new File(path), loadUpdater);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ComputationGraph restoreComputationGraph(@NonNull InputStream is, boolean loadUpdater) throws IOException {
        if (is == null) {
            throw new NullPointerException("is is marked @NonNull but is null");
        }
        ModelSerializer.checkInputStream(is);
        File tmpFile = null;
        try {
            tmpFile = ModelSerializer.tempFileFromStream(is);
            ComputationGraph computationGraph = ModelSerializer.restoreComputationGraph(tmpFile, loadUpdater);
            return computationGraph;
        }
        finally {
            if (tmpFile != null) {
                tmpFile.delete();
            }
        }
    }

    public static ComputationGraph restoreComputationGraph(@NonNull InputStream is) throws IOException {
        if (is == null) {
            throw new NullPointerException("is is marked @NonNull but is null");
        }
        return ModelSerializer.restoreComputationGraph(is, true);
    }

    public static ComputationGraph restoreComputationGraph(@NonNull File file) throws IOException {
        if (file == null) {
            throw new NullPointerException("file is marked @NonNull but is null");
        }
        return ModelSerializer.restoreComputationGraph(file, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Pair<ComputationGraph, Normalizer> restoreComputationGraphAndNormalizer(@NonNull InputStream is, boolean loadUpdater) throws IOException {
        if (is == null) {
            throw new NullPointerException("is is marked @NonNull but is null");
        }
        ModelSerializer.checkInputStream(is);
        File tmpFile = null;
        try {
            tmpFile = ModelSerializer.tempFileFromStream(is);
            Pair<ComputationGraph, Normalizer> pair = ModelSerializer.restoreComputationGraphAndNormalizer(tmpFile, loadUpdater);
            return pair;
        }
        finally {
            if (tmpFile != null) {
                tmpFile.delete();
            }
        }
    }

    public static Pair<ComputationGraph, Normalizer> restoreComputationGraphAndNormalizer(@NonNull File file, boolean loadUpdater) throws IOException {
        if (file == null) {
            throw new NullPointerException("file is marked @NonNull but is null");
        }
        ComputationGraph net = ModelSerializer.restoreComputationGraph(file, loadUpdater);
        Object norm = ModelSerializer.restoreNormalizerFromFile(file);
        return new Pair((Object)net, norm);
    }

    public static ComputationGraph restoreComputationGraph(@NonNull File file, boolean loadUpdater) throws IOException {
        ZipEntry prep;
        InputStream stream;
        ZipEntry updaterStateEntry;
        ZipEntry coefficients;
        if (file == null) {
            throw new NullPointerException("file is marked @NonNull but is null");
        }
        ZipFile zipFile = new ZipFile(file);
        boolean gotConfig = false;
        boolean gotCoefficients = false;
        boolean gotUpdaterState = false;
        boolean gotPreProcessor = false;
        String json = "";
        INDArray params = null;
        INDArray updaterState = null;
        DataSetPreProcessor preProcessor = null;
        ZipEntry config = zipFile.getEntry(CONFIGURATION_JSON);
        if (config != null) {
            InputStream stream2 = zipFile.getInputStream(config);
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream2));
            String line = "";
            StringBuilder js = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                js.append(line).append("\n");
            }
            json = js.toString();
            reader.close();
            stream2.close();
            gotConfig = true;
        }
        if ((coefficients = zipFile.getEntry(COEFFICIENTS_BIN)) != null) {
            if (coefficients.getSize() > 0L) {
                InputStream stream3 = zipFile.getInputStream(coefficients);
                DataInputStream dis = new DataInputStream(new BufferedInputStream(stream3));
                params = Nd4j.read((DataInputStream)dis);
                dis.close();
                gotCoefficients = true;
            } else {
                ZipEntry noParamsMarker = zipFile.getEntry(NO_PARAMS_MARKER);
                boolean bl = gotCoefficients = noParamsMarker != null;
            }
        }
        if (loadUpdater && (updaterStateEntry = zipFile.getEntry(UPDATER_BIN)) != null) {
            stream = zipFile.getInputStream(updaterStateEntry);
            DataInputStream dis = new DataInputStream(new BufferedInputStream(stream));
            updaterState = Nd4j.read((DataInputStream)dis);
            dis.close();
            gotUpdaterState = true;
        }
        if ((prep = zipFile.getEntry(PREPROCESSOR_BIN)) != null) {
            stream = zipFile.getInputStream(prep);
            ObjectInputStream ois = new ObjectInputStream(stream);
            try {
                preProcessor = (DataSetPreProcessor)ois.readObject();
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            gotPreProcessor = true;
        }
        zipFile.close();
        if (gotConfig && gotCoefficients) {
            ComputationGraphConfiguration confFromJson;
            try {
                confFromJson = ComputationGraphConfiguration.fromJson(json);
                if (confFromJson.getNetworkInputs() == null && (confFromJson.getVertices() == null || confFromJson.getVertices().size() == 0)) {
                    throw new RuntimeException("Invalid JSON - not a ComputationGraphConfiguration");
                }
            }
            catch (Exception e) {
                if (e.getMessage() != null && e.getMessage().contains("registerLegacyCustomClassesForJSON")) {
                    throw e;
                }
                try {
                    MultiLayerConfiguration.fromJson(json);
                }
                catch (Exception e2) {
                    throw new RuntimeException("Error deserializing JSON ComputationGraphConfiguration. Saved model JSON is not a valid ComputationGraphConfiguration", e);
                }
                throw new RuntimeException("Error deserializing JSON ComputationGraphConfiguration. Saved model appears to be a MultiLayerNetwork - use ModelSerializer.restoreMultiLayerNetwork instead");
            }
            if (params != null) {
                confFromJson.setDataType(params.dataType());
            }
            ComputationGraph cg = new ComputationGraph(confFromJson);
            cg.init(params, false);
            if (gotUpdaterState && updaterState != null) {
                cg.getUpdater().setStateViewArray(updaterState);
            }
            return cg;
        }
        throw new IllegalStateException("Model wasnt found within file: gotConfig: [" + gotConfig + "], gotCoefficients: [" + gotCoefficients + "], gotUpdater: [" + gotUpdaterState + "]");
    }

    public static Task taskByModel(Model model) {
        Task task = new Task();
        try {
            block17: {
                task.setArchitectureType(Task.ArchitectureType.RECURRENT);
                if (model instanceof ComputationGraph) {
                    task.setNetworkType(Task.NetworkType.ComputationalGraph);
                    ComputationGraph network = (ComputationGraph)model;
                    try {
                        if (network.getLayers() != null && network.getLayers().length > 0) {
                            for (Layer layer : network.getLayers()) {
                                if (layer.type().equals((Object)Layer.Type.CONVOLUTIONAL)) {
                                    task.setArchitectureType(Task.ArchitectureType.CONVOLUTION);
                                } else {
                                    if (!layer.type().equals((Object)Layer.Type.RECURRENT) && !layer.type().equals((Object)Layer.Type.RECURSIVE)) continue;
                                    task.setArchitectureType(Task.ArchitectureType.RECURRENT);
                                }
                                break block17;
                            }
                            break block17;
                        }
                        task.setArchitectureType(Task.ArchitectureType.UNKNOWN);
                    }
                    catch (Exception exception) {}
                } else if (model instanceof MultiLayerNetwork) {
                    task.setNetworkType(Task.NetworkType.MultilayerNetwork);
                    MultiLayerNetwork network = (MultiLayerNetwork)model;
                    try {
                        if (network.getLayers() != null && network.getLayers().length > 0) {
                            for (Layer layer : network.getLayers()) {
                                if (layer.type().equals((Object)Layer.Type.CONVOLUTIONAL)) {
                                    task.setArchitectureType(Task.ArchitectureType.CONVOLUTION);
                                } else {
                                    if (!layer.type().equals((Object)Layer.Type.RECURRENT) && !layer.type().equals((Object)Layer.Type.RECURSIVE)) continue;
                                    task.setArchitectureType(Task.ArchitectureType.RECURRENT);
                                }
                                break block17;
                            }
                            break block17;
                        }
                        task.setArchitectureType(Task.ArchitectureType.UNKNOWN);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            return task;
        }
        catch (Exception e) {
            task.setArchitectureType(Task.ArchitectureType.UNKNOWN);
            task.setNetworkType(Task.NetworkType.DenseNetwork);
            return task;
        }
    }

    public static void addNormalizerToModel(File f, Normalizer<?> normalizer) {
        File tempFile = null;
        try {
            tempFile = DL4JFileUtils.createTempFile((String)"dl4jModelSerializerTemp", (String)"bin");
            tempFile.deleteOnExit();
            Files.copy((File)f, (File)tempFile);
            try (ZipFile zipFile = new ZipFile(tempFile);
                 ZipOutputStream writeFile = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(f)));){
                Enumeration<? extends ZipEntry> entries = zipFile.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    if (entry.getName().equalsIgnoreCase(NORMALIZER_BIN)) continue;
                    log.debug("Copying: {}", (Object)entry.getName());
                    InputStream is = zipFile.getInputStream(entry);
                    ZipEntry wEntry = new ZipEntry(entry.getName());
                    writeFile.putNextEntry(wEntry);
                    IOUtils.copy((InputStream)is, (OutputStream)writeFile);
                }
                ZipEntry nEntry = new ZipEntry(NORMALIZER_BIN);
                writeFile.putNextEntry(nEntry);
                NormalizerSerializer.getDefault().write(normalizer, (OutputStream)writeFile);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        finally {
            if (tempFile != null) {
                tempFile.delete();
            }
        }
    }

    public static void addObjectToFile(@NonNull File f, @NonNull String key, @NonNull Object o) {
        if (f == null) {
            throw new NullPointerException("f is marked @NonNull but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked @NonNull but is null");
        }
        if (o == null) {
            throw new NullPointerException("o is marked @NonNull but is null");
        }
        Preconditions.checkState((boolean)f.exists(), (String)"File must exist: %s", (Object)f);
        Preconditions.checkArgument((!UPDATER_BIN.equalsIgnoreCase(key) && !NORMALIZER_BIN.equalsIgnoreCase(key) && !CONFIGURATION_JSON.equalsIgnoreCase(key) && !COEFFICIENTS_BIN.equalsIgnoreCase(key) && !NO_PARAMS_MARKER.equalsIgnoreCase(key) && !PREPROCESSOR_BIN.equalsIgnoreCase(key) ? 1 : 0) != 0, (String)"Invalid key: Key is reserved for internal use: \"%s\"", (Object)key);
        File tempFile = null;
        try {
            tempFile = DL4JFileUtils.createTempFile((String)"dl4jModelSerializerTemp", (String)"bin");
            Files.copy((File)f, (File)tempFile);
            f.delete();
            try (ZipFile zipFile = new ZipFile(tempFile);
                 ZipOutputStream writeFile = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(f)));){
                ZipEntry entry;
                Enumeration<? extends ZipEntry> entries = zipFile.entries();
                while (entries.hasMoreElements()) {
                    entry = entries.nextElement();
                    log.debug("Copying: {}", (Object)entry.getName());
                    InputStream is = zipFile.getInputStream(entry);
                    ZipEntry wEntry = new ZipEntry(entry.getName());
                    writeFile.putNextEntry(wEntry);
                    IOUtils.copy((InputStream)is, (OutputStream)writeFile);
                    writeFile.closeEntry();
                    is.close();
                }
                entry = new ZipEntry("objects/" + key);
                writeFile.putNextEntry(entry);
                try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
                     ObjectOutputStream oos = new ObjectOutputStream(baos);){
                    oos.writeObject(o);
                    byte[] bytes = baos.toByteArray();
                    writeFile.write(bytes);
                }
                writeFile.closeEntry();
                writeFile.close();
                zipFile.close();
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        finally {
            if (tempFile != null) {
                tempFile.delete();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T getObjectFromFile(@NonNull File f, @NonNull String key) {
        if (f == null) {
            throw new NullPointerException("f is marked @NonNull but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked @NonNull but is null");
        }
        Preconditions.checkState((boolean)f.exists(), (String)"File must exist: %s", (Object)f);
        Preconditions.checkArgument((!UPDATER_BIN.equalsIgnoreCase(key) && !NORMALIZER_BIN.equalsIgnoreCase(key) && !CONFIGURATION_JSON.equalsIgnoreCase(key) && !COEFFICIENTS_BIN.equalsIgnoreCase(key) && !NO_PARAMS_MARKER.equalsIgnoreCase(key) && !PREPROCESSOR_BIN.equalsIgnoreCase(key) ? 1 : 0) != 0, (String)"Invalid key: Key is reserved for internal use: \"%s\"", (Object)key);
        try (ZipFile zipFile = new ZipFile(f);){
            Object o;
            ZipEntry entry = zipFile.getEntry("objects/" + key);
            if (entry == null) {
                throw new IllegalStateException("No object with key \"" + key + "\" found");
            }
            try (ObjectInputStream ois = new ObjectInputStream(new BufferedInputStream(zipFile.getInputStream(entry)));){
                o = ois.readObject();
            }
            zipFile.close();
            Object object = o;
            return (T)object;
        }
        catch (IOException | ClassNotFoundException e) {
            throw new RuntimeException("Error reading object (key = " + key + ") from file " + f, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<String> listObjectsInFile(@NonNull File f) {
        if (f == null) {
            throw new NullPointerException("f is marked @NonNull but is null");
        }
        Preconditions.checkState((boolean)f.exists(), (String)"File must exist: %s", (Object)f);
        ArrayList<String> out = new ArrayList<String>();
        try (ZipFile zipFile = new ZipFile(f);){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry e = entries.nextElement();
                String name = e.getName();
                if (e.isDirectory() || !name.startsWith("objects/")) continue;
                String s = name.substring(8);
                out.add(s);
            }
            ArrayList<String> arrayList = out;
            return arrayList;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T extends Normalizer> T restoreNormalizerFromFile(File file) {
        try (ZipFile zipFile = new ZipFile(file);){
            ZipEntry norm = zipFile.getEntry(NORMALIZER_BIN);
            if (norm == null) {
                T t = null;
                return t;
            }
            Normalizer normalizer = NormalizerSerializer.getDefault().restore(zipFile.getInputStream(norm));
            return (T)normalizer;
        }
        catch (Exception e) {
            log.warn("Error while restoring normalizer, trying to restore assuming deprecated format...");
            DataNormalization restoredDeprecated = ModelSerializer.restoreNormalizerFromFileDeprecated(file);
            log.warn("Recovered using deprecated method. Will now re-save the normalizer to fix this issue.");
            ModelSerializer.addNormalizerToModel(file, restoredDeprecated);
            return (T)restoredDeprecated;
        }
    }

    public static <T extends Normalizer> T restoreNormalizerFromInputStream(InputStream is) throws IOException {
        ModelSerializer.checkInputStream(is);
        File tmpFile = null;
        try {
            tmpFile = ModelSerializer.tempFileFromStream(is);
            T t = ModelSerializer.restoreNormalizerFromFile(tmpFile);
            return t;
        }
        finally {
            if (tmpFile != null) {
                tmpFile.delete();
            }
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static DataNormalization restoreNormalizerFromFileDeprecated(File file) {
        try {
            Throwable throwable = null;
            try (ZipFile zipFile = new ZipFile(file);){
                ZipEntry norm = zipFile.getEntry(NORMALIZER_BIN);
                if (norm == null) {
                    DataNormalization dataNormalization = null;
                    return dataNormalization;
                }
                InputStream stream = zipFile.getInputStream(norm);
                ObjectInputStream ois = new ObjectInputStream(stream);
                try {
                    DataNormalization normalizer;
                    DataNormalization dataNormalization = normalizer = (DataNormalization)ois.readObject();
                    return dataNormalization;
                }
                catch (ClassNotFoundException e) {
                    try {
                        throw new RuntimeException(e);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void checkInputStream(InputStream inputStream) throws IOException {
    }

    private static void checkTempFileFromInputStream(File f) throws IOException {
        if (f.length() <= 0L) {
            throw new IOException("Error reading from input stream: temporary file is empty after copying entire stream. Stream may have been closed before reading, is attempting to be used multiple times, or does not point to a model file?");
        }
    }

    private static File tempFileFromStream(InputStream is) throws IOException {
        ModelSerializer.checkInputStream(is);
        String p = System.getProperty("org.deeplearning4j.tempdir");
        File tmpFile = DL4JFileUtils.createTempFile((String)"dl4jModelSerializer", (String)"bin");
        try {
            tmpFile.deleteOnExit();
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(tmpFile));
            IOUtils.copy((InputStream)is, (OutputStream)bufferedOutputStream);
            bufferedOutputStream.flush();
            IOUtils.closeQuietly((OutputStream)bufferedOutputStream);
            ModelSerializer.checkTempFileFromInputStream(tmpFile);
            return tmpFile;
        }
        catch (IOException e) {
            if (tmpFile != null) {
                tmpFile.delete();
            }
            throw e;
        }
    }
}

