/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.layers.recurrent;

import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.api.MaskState;
import org.deeplearning4j.nn.conf.CacheMode;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.gradient.Gradient;
import org.deeplearning4j.nn.layers.LayerHelper;
import org.deeplearning4j.nn.layers.recurrent.BaseRecurrentLayer;
import org.deeplearning4j.nn.layers.recurrent.FwdPassReturn;
import org.deeplearning4j.nn.layers.recurrent.LSTMHelper;
import org.deeplearning4j.nn.layers.recurrent.LSTMHelpers;
import org.deeplearning4j.nn.workspace.LayerWorkspaceMgr;
import org.nd4j.base.Preconditions;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.primitives.Pair;
import org.nd4j.util.OneTimeLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LSTM
extends BaseRecurrentLayer<org.deeplearning4j.nn.conf.layers.LSTM> {
    private static final Logger log = LoggerFactory.getLogger(LSTM.class);
    public static final String STATE_KEY_PREV_ACTIVATION = "prevAct";
    public static final String STATE_KEY_PREV_MEMCELL = "prevMem";
    protected LSTMHelper helper = null;
    protected FwdPassReturn cachedFwdPass;

    public LSTM(NeuralNetConfiguration conf, DataType dataType) {
        super(conf, dataType);
        this.initializeHelper();
    }

    void initializeHelper() {
        String backend = Nd4j.getExecutioner().getEnvironmentInformation().getProperty("backend");
        if ("CUDA".equalsIgnoreCase(backend)) {
            try {
                this.helper = Class.forName("org.deeplearning4j.nn.layers.recurrent.CudnnLSTMHelper").asSubclass(LSTMHelper.class).getConstructor(DataType.class).newInstance(this.dataType);
                log.debug("CudnnLSTMHelper successfully initialized");
                if (!this.helper.checkSupported(((org.deeplearning4j.nn.conf.layers.LSTM)this.layerConf()).getGateActivationFn(), ((org.deeplearning4j.nn.conf.layers.LSTM)this.layerConf()).getActivationFn(), false)) {
                    this.helper = null;
                }
            }
            catch (Throwable t) {
                if (!(t instanceof ClassNotFoundException)) {
                    log.warn("Could not initialize CudnnLSTMHelper", t);
                }
                OneTimeLogger.info((Logger)log, (String)"cuDNN not found: use cuDNN for better GPU performance by including the deeplearning4j-cuda module. For more information, please refer to: https://deeplearning4j.org/docs/latest/deeplearning4j-config-cudnn", (Object[])new Object[]{t});
            }
        }
    }

    @Override
    public Gradient gradient() {
        throw new UnsupportedOperationException("gradient() method for layerwise pretraining: not supported for LSTMs (pretraining not possible) " + this.layerId());
    }

    @Override
    public Pair<Gradient, INDArray> backpropGradient(INDArray epsilon, LayerWorkspaceMgr workspaceMgr) {
        return this.backpropGradientHelper(epsilon, false, -1, workspaceMgr);
    }

    @Override
    public Pair<Gradient, INDArray> tbpttBackpropGradient(INDArray epsilon, int tbpttBackwardLength, LayerWorkspaceMgr workspaceMgr) {
        return this.backpropGradientHelper(epsilon, true, tbpttBackwardLength, workspaceMgr);
    }

    private Pair<Gradient, INDArray> backpropGradientHelper(INDArray epsilon, boolean truncatedBPTT, int tbpttBackwardLength, LayerWorkspaceMgr workspaceMgr) {
        FwdPassReturn fwdPass;
        this.assertInputSet(true);
        INDArray inputWeights = this.getParamWithNoise("W", true, workspaceMgr);
        INDArray recurrentWeights = this.getParamWithNoise("RW", true, workspaceMgr);
        if (truncatedBPTT) {
            fwdPass = this.activateHelper(true, (INDArray)this.stateMap.get(STATE_KEY_PREV_ACTIVATION), (INDArray)this.stateMap.get(STATE_KEY_PREV_MEMCELL), true, workspaceMgr);
            this.tBpttStateMap.put(STATE_KEY_PREV_ACTIVATION, fwdPass.lastAct.detach());
            this.tBpttStateMap.put(STATE_KEY_PREV_MEMCELL, fwdPass.lastMemCell.detach());
        } else {
            fwdPass = this.activateHelper(true, null, null, true, workspaceMgr);
        }
        Pair<Gradient, INDArray> p = LSTMHelpers.backpropGradientHelper(this.conf, ((org.deeplearning4j.nn.conf.layers.LSTM)this.layerConf()).getGateActivationFn(), this.input, recurrentWeights, inputWeights, epsilon, truncatedBPTT, tbpttBackwardLength, fwdPass, true, "W", "RW", "b", this.gradientViews, null, false, this.helper, workspaceMgr);
        this.weightNoiseParams.clear();
        p.setSecond((Object)this.backpropDropOutIfPresent((INDArray)p.getSecond()));
        return p;
    }

    @Override
    public INDArray activate(INDArray input, boolean training, LayerWorkspaceMgr workspaceMgr) {
        this.setInput(input, workspaceMgr);
        return this.activateHelper((boolean)training, null, null, (boolean)false, (LayerWorkspaceMgr)workspaceMgr).fwdPassOutput;
    }

    @Override
    public INDArray activate(boolean training, LayerWorkspaceMgr workspaceMgr) {
        return this.activateHelper((boolean)training, null, null, (boolean)false, (LayerWorkspaceMgr)workspaceMgr).fwdPassOutput;
    }

    private FwdPassReturn activateHelper(boolean training, INDArray prevOutputActivations, INDArray prevMemCellState, boolean forBackprop, LayerWorkspaceMgr workspaceMgr) {
        this.assertInputSet(false);
        Preconditions.checkState((this.input.rank() == 3 ? 1 : 0) != 0, (String)("3D input expected to RNN layer expected, got " + this.input.rank()));
        this.applyDropOutIfNecessary(training, workspaceMgr);
        this.cacheMode = CacheMode.NONE;
        if (forBackprop && this.cachedFwdPass != null) {
            FwdPassReturn ret = this.cachedFwdPass;
            this.cachedFwdPass = null;
            return ret;
        }
        INDArray recurrentWeights = this.getParamWithNoise("RW", training, workspaceMgr);
        INDArray inputWeights = this.getParamWithNoise("W", training, workspaceMgr);
        INDArray biases = this.getParamWithNoise("b", training, workspaceMgr);
        FwdPassReturn fwd = LSTMHelpers.activateHelper(this, this.conf, ((org.deeplearning4j.nn.conf.layers.LSTM)this.layerConf()).getGateActivationFn(), this.input, recurrentWeights, inputWeights, biases, training, prevOutputActivations, prevMemCellState, training && this.cacheMode != CacheMode.NONE || forBackprop, true, "W", this.maskArray, false, this.helper, forBackprop ? this.cacheMode : CacheMode.NONE, workspaceMgr);
        if (training && this.cacheMode != CacheMode.NONE) {
            this.cachedFwdPass = fwd;
        }
        return fwd;
    }

    @Override
    public Layer.Type type() {
        return Layer.Type.RECURRENT;
    }

    @Override
    public boolean isPretrainLayer() {
        return false;
    }

    @Override
    public Pair<INDArray, MaskState> feedForwardMaskArray(INDArray maskArray, MaskState currentMaskState, int minibatchSize) {
        return new Pair((Object)maskArray, (Object)MaskState.Passthrough);
    }

    @Override
    public INDArray rnnTimeStep(INDArray input, LayerWorkspaceMgr workspaceMgr) {
        this.setInput(input, workspaceMgr);
        FwdPassReturn fwdPass = this.activateHelper(false, (INDArray)this.stateMap.get(STATE_KEY_PREV_ACTIVATION), (INDArray)this.stateMap.get(STATE_KEY_PREV_MEMCELL), false, workspaceMgr);
        INDArray outAct = fwdPass.fwdPassOutput;
        this.stateMap.put(STATE_KEY_PREV_ACTIVATION, fwdPass.lastAct.detach());
        this.stateMap.put(STATE_KEY_PREV_MEMCELL, fwdPass.lastMemCell.detach());
        return outAct;
    }

    @Override
    public INDArray rnnActivateUsingStoredState(INDArray input, boolean training, boolean storeLastForTBPTT, LayerWorkspaceMgr workspaceMgr) {
        this.setInput(input, workspaceMgr);
        FwdPassReturn fwdPass = this.activateHelper(training, (INDArray)this.tBpttStateMap.get(STATE_KEY_PREV_ACTIVATION), (INDArray)this.tBpttStateMap.get(STATE_KEY_PREV_MEMCELL), false, workspaceMgr);
        INDArray outAct = fwdPass.fwdPassOutput;
        if (storeLastForTBPTT) {
            this.tBpttStateMap.put(STATE_KEY_PREV_ACTIVATION, fwdPass.lastAct.detach());
            this.tBpttStateMap.put(STATE_KEY_PREV_MEMCELL, fwdPass.lastMemCell.detach());
        }
        return outAct;
    }

    @Override
    public LayerHelper getHelper() {
        return this.helper;
    }
}

