/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.graph.vertex.impl;

import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.api.MaskState;
import org.deeplearning4j.nn.gradient.Gradient;
import org.deeplearning4j.nn.graph.ComputationGraph;
import org.deeplearning4j.nn.graph.vertex.BaseGraphVertex;
import org.deeplearning4j.nn.graph.vertex.VertexIndices;
import org.deeplearning4j.nn.workspace.ArrayType;
import org.deeplearning4j.nn.workspace.LayerWorkspaceMgr;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.memory.MemoryWorkspace;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BroadcastOp;
import org.nd4j.linalg.api.ops.ReduceOp;
import org.nd4j.linalg.api.ops.impl.broadcast.BroadcastMulOp;
import org.nd4j.linalg.api.ops.impl.reduce3.EuclideanDistance;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.ops.transforms.Transforms;
import org.nd4j.linalg.primitives.Pair;

public class L2Vertex
extends BaseGraphVertex {
    private double eps;

    public L2Vertex(ComputationGraph graph, String name, int vertexIndex, double eps, DataType dataType) {
        this(graph, name, vertexIndex, null, null, eps, dataType);
    }

    public L2Vertex(ComputationGraph graph, String name, int vertexIndex, VertexIndices[] inputVertices, VertexIndices[] outputVertices, double eps, DataType dataType) {
        super(graph, name, vertexIndex, inputVertices, outputVertices, dataType);
        this.eps = eps;
    }

    @Override
    public boolean hasLayer() {
        return false;
    }

    @Override
    public Layer getLayer() {
        return null;
    }

    @Override
    public INDArray doForward(boolean training, LayerWorkspaceMgr workspaceMgr) {
        if (!this.canDoForward()) {
            throw new IllegalStateException("Cannot do forward pass: input not set");
        }
        INDArray a = this.inputs[0];
        INDArray b = this.inputs[1];
        int[] dimensions = new int[a.rank() - 1];
        for (int i = 1; i < a.rank(); ++i) {
            dimensions[i - 1] = i;
        }
        try (MemoryWorkspace ws = workspaceMgr.notifyScopeBorrowed(ArrayType.ACTIVATIONS);){
            INDArray arr = Nd4j.getExecutioner().exec((ReduceOp)new EuclideanDistance(a, b, dimensions));
            INDArray iNDArray = arr.reshape(arr.size(0), 1L);
            return iNDArray;
        }
    }

    @Override
    public Pair<Gradient, INDArray[]> doBackward(boolean tbptt, LayerWorkspaceMgr workspaceMgr) {
        INDArray dLdb;
        INDArray dLda;
        INDArray diff;
        if (!this.canDoBackward()) {
            throw new IllegalStateException("Cannot do backward pass: error not set");
        }
        INDArray a = this.inputs[0];
        INDArray b = this.inputs[1];
        INDArray out = this.doForward(tbptt, workspaceMgr);
        Transforms.max((INDArray)out, (double)this.eps, (boolean)false);
        INDArray dLdlambda = this.epsilon;
        INDArray sNegHalf = out.rdiv((Number)1.0);
        try (MemoryWorkspace ws = workspaceMgr.notifyScopeBorrowed(ArrayType.ACTIVATION_GRAD);){
            diff = a.sub(b);
        }
        INDArray first = dLdlambda.mul(sNegHalf);
        if (a.rank() == 2) {
            dLda = diff.muliColumnVector(first);
            try (MemoryWorkspace ws = workspaceMgr.notifyScopeBorrowed(ArrayType.ACTIVATION_GRAD);){
                dLdb = dLda.neg();
            }
        }
        dLda = Nd4j.getExecutioner().exec((BroadcastOp)new BroadcastMulOp(diff, first, diff, new int[]{0}));
        try (MemoryWorkspace ws = workspaceMgr.notifyScopeBorrowed(ArrayType.ACTIVATION_GRAD);){
            dLdb = dLda.neg();
        }
        return new Pair(null, (Object)new INDArray[]{dLda, dLdb});
    }

    @Override
    public void setBackpropGradientsViewArray(INDArray backpropGradientsViewArray) {
        if (backpropGradientsViewArray != null) {
            throw new RuntimeException("Vertex does not have gradients; gradients view array cannot be set here");
        }
    }

    @Override
    public String toString() {
        return "L2Vertex(id=" + this.getVertexIndex() + ",name=\"" + this.getVertexName() + ")";
    }

    @Override
    public Pair<INDArray, MaskState> feedForwardMaskArrays(INDArray[] maskArrays, MaskState currentMaskState, int minibatchSize) {
        if (maskArrays == null || maskArrays.length == 0) {
            return null;
        }
        return new Pair((Object)maskArrays[0], (Object)currentMaskState);
    }
}

