/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.serde;

import java.io.IOException;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.layers.Layer;
import org.deeplearning4j.nn.conf.layers.misc.FrozenLayer;
import org.deeplearning4j.nn.conf.serde.legacyformat.LegacyLayerDeserializer;
import org.nd4j.shade.jackson.core.JsonFactory;
import org.nd4j.shade.jackson.core.JsonParser;
import org.nd4j.shade.jackson.databind.DeserializationContext;
import org.nd4j.shade.jackson.databind.JsonDeserializer;
import org.nd4j.shade.jackson.databind.JsonNode;

public class FrozenLayerDeserializer
extends JsonDeserializer<Layer> {
    public Layer deserialize(JsonParser jp, DeserializationContext deserializationContext) throws IOException {
        Layer internal;
        JsonNode n = (JsonNode)jp.getCodec().readTree(jp);
        JsonNode layer = n.get("layer");
        boolean newFormat = layer.has("@class");
        String internalText = layer.toString();
        if (newFormat) {
            internal = (Layer)NeuralNetConfiguration.mapper().readValue(internalText, Layer.class);
        } else {
            JsonFactory factory = new JsonFactory();
            JsonParser parser = factory.createParser(internalText);
            parser.setCodec(jp.getCodec());
            internal = (Layer)new LegacyLayerDeserializer().deserialize(parser, deserializationContext);
        }
        return new FrozenLayer(internal);
    }
}

