/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.layers;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.deeplearning4j.exception.DL4JInvalidConfigException;
import org.deeplearning4j.nn.api.layers.LayerConstraint;
import org.deeplearning4j.nn.conf.dropout.IDropout;
import org.deeplearning4j.nn.conf.layers.BaseLayer;
import org.deeplearning4j.nn.conf.layers.Layer;
import org.deeplearning4j.nn.conf.layers.misc.FrozenLayer;
import org.deeplearning4j.nn.conf.layers.recurrent.Bidirectional;
import org.nd4j.linalg.learning.regularization.Regularization;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LayerValidation {
    private static final Logger log = LoggerFactory.getLogger(LayerValidation.class);

    private LayerValidation() {
    }

    public static void assertNInNOutSet(String layerType, String layerName, long layerIndex, long nIn, long nOut) {
        if (nIn <= 0L || nOut <= 0L) {
            if (layerName == null) {
                layerName = "(name not set)";
            }
            throw new DL4JInvalidConfigException(layerType + " (index=" + layerIndex + ", name=" + layerName + ") nIn=" + nIn + ", nOut=" + nOut + "; nIn and nOut must be > 0");
        }
    }

    public static void assertNOutSet(String layerType, String layerName, long layerIndex, long nOut) {
        if (nOut <= 0L) {
            if (layerName == null) {
                layerName = "(name not set)";
            }
            throw new DL4JInvalidConfigException(layerType + " (index=" + layerIndex + ", name=" + layerName + ") nOut=" + nOut + "; nOut must be > 0");
        }
    }

    public static void generalValidation(String layerName, Layer layer, IDropout iDropout, List<Regularization> regularization, List<Regularization> regularizationBias, List<LayerConstraint> allParamConstraints, List<LayerConstraint> weightConstraints, List<LayerConstraint> biasConstraints) {
        if (layer != null) {
            BaseLayer bLayer;
            if (layer instanceof BaseLayer) {
                bLayer = (BaseLayer)layer;
                LayerValidation.configureBaseLayer(layerName, bLayer, iDropout, regularization, regularizationBias);
            } else if (layer instanceof FrozenLayer && ((FrozenLayer)layer).getLayer() instanceof BaseLayer) {
                bLayer = (BaseLayer)((FrozenLayer)layer).getLayer();
                LayerValidation.configureBaseLayer(layerName, bLayer, iDropout, regularization, regularizationBias);
            } else if (layer instanceof Bidirectional) {
                Bidirectional l = (Bidirectional)layer;
                LayerValidation.generalValidation(layerName, l.getFwd(), iDropout, regularization, regularizationBias, allParamConstraints, weightConstraints, biasConstraints);
                LayerValidation.generalValidation(layerName, l.getBwd(), iDropout, regularization, regularizationBias, allParamConstraints, weightConstraints, biasConstraints);
            }
            if (layer.getConstraints() == null || layer.constraints.isEmpty()) {
                LayerConstraint c2;
                ArrayList<LayerConstraint> allConstraints = new ArrayList<LayerConstraint>();
                if (allParamConstraints != null && !layer.initializer().paramKeys(layer).isEmpty()) {
                    for (LayerConstraint c : allConstraints) {
                        c2 = c.clone();
                        c2.setParams(new HashSet<String>(layer.initializer().paramKeys(layer)));
                        allConstraints.add(c2);
                    }
                }
                if (weightConstraints != null && !layer.initializer().weightKeys(layer).isEmpty()) {
                    for (LayerConstraint c : weightConstraints) {
                        c2 = c.clone();
                        c2.setParams(new HashSet<String>(layer.initializer().weightKeys(layer)));
                        allConstraints.add(c2);
                    }
                }
                if (biasConstraints != null && !layer.initializer().biasKeys(layer).isEmpty()) {
                    for (LayerConstraint c : biasConstraints) {
                        c2 = c.clone();
                        c2.setParams(new HashSet<String>(layer.initializer().biasKeys(layer)));
                        allConstraints.add(c2);
                    }
                }
                if (!allConstraints.isEmpty()) {
                    layer.setConstraints(allConstraints);
                } else {
                    layer.setConstraints(null);
                }
            }
        }
    }

    private static void configureBaseLayer(String layerName, BaseLayer bLayer, IDropout iDropout, List<Regularization> regularization, List<Regularization> regularizationBias) {
        if (regularization != null && !regularization.isEmpty()) {
            bLayer.setRegularization(regularization);
        }
        if (regularizationBias != null && !regularizationBias.isEmpty()) {
            bLayer.setRegularizationBias(regularizationBias);
        }
        if (bLayer.getIDropout() == null) {
            bLayer.setIDropout(iDropout);
        }
    }
}

