/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.graph;

import java.util.Arrays;
import org.deeplearning4j.nn.conf.graph.GraphVertex;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.inputs.InvalidInputTypeException;
import org.deeplearning4j.nn.conf.memory.LayerMemoryReport;
import org.deeplearning4j.nn.conf.memory.MemoryReport;
import org.deeplearning4j.nn.graph.ComputationGraph;
import org.nd4j.base.Preconditions;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.shade.jackson.annotation.JsonProperty;

public class ReshapeVertex
extends GraphVertex {
    public static final char DEFAULT_RESHAPE_ORDER = 'c';
    protected char reshapeOrder = (char)99;
    protected int[] newShape;
    protected int[] maskShape;

    public ReshapeVertex(int ... newShape) {
        this('c', newShape, (int[])null);
    }

    public ReshapeVertex(@JsonProperty(value="reshapeOrder") char reshapeOrder, @JsonProperty(value="newShape") int[] newShape, @JsonProperty(value="maskShape") int[] maskShape) {
        Preconditions.checkState((reshapeOrder == 'c' || reshapeOrder == 'f' ? 1 : 0) != 0, (String)"Reshape order must be 'c' or 'f'. Got: '%s'", (Object)String.valueOf(reshapeOrder));
        this.reshapeOrder = reshapeOrder;
        this.newShape = newShape;
        this.maskShape = maskShape;
    }

    @Override
    public ReshapeVertex clone() {
        return new ReshapeVertex(this.newShape);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof ReshapeVertex)) {
            return false;
        }
        return Arrays.equals(((ReshapeVertex)o).newShape, this.newShape);
    }

    @Override
    public int hashCode() {
        return this.reshapeOrder ^ Arrays.hashCode(this.newShape);
    }

    @Override
    public long numParams(boolean backprop) {
        return 0L;
    }

    @Override
    public int minVertexInputs() {
        return 1;
    }

    @Override
    public int maxVertexInputs() {
        return 1;
    }

    @Override
    public org.deeplearning4j.nn.graph.vertex.GraphVertex instantiate(ComputationGraph graph, String name, int idx, INDArray paramsView, boolean initializeParams, DataType networkDatatype) {
        return new org.deeplearning4j.nn.graph.vertex.impl.ReshapeVertex(graph, name, idx, this.reshapeOrder, this.newShape, this.maskShape, networkDatatype);
    }

    @Override
    public InputType getOutputType(int layerIndex, InputType ... vertexInputs) throws InvalidInputTypeException {
        switch (this.newShape.length) {
            case 2: {
                return InputType.feedForward(this.newShape[1]);
            }
            case 3: {
                return InputType.recurrent(this.newShape[1]);
            }
            case 4: {
                return InputType.convolutional(this.newShape[2], this.newShape[3], this.newShape[1]);
            }
        }
        throw new UnsupportedOperationException("Cannot infer input type for reshape array " + Arrays.toString(this.newShape));
    }

    @Override
    public MemoryReport getMemoryReport(InputType ... inputTypes) {
        InputType outputType = this.getOutputType(-1, inputTypes);
        return new LayerMemoryReport.Builder(null, ReshapeVertex.class, inputTypes[0], outputType).standardMemory(0L, 0L).workingMemory(0L, 0L, 0L, 0L).cacheMemory(0L, 0L).build();
    }

    public char getReshapeOrder() {
        return this.reshapeOrder;
    }

    public int[] getNewShape() {
        return this.newShape;
    }

    public int[] getMaskShape() {
        return this.maskShape;
    }

    public void setReshapeOrder(char reshapeOrder) {
        this.reshapeOrder = reshapeOrder;
    }

    public void setNewShape(int[] newShape) {
        this.newShape = newShape;
    }

    public void setMaskShape(int[] maskShape) {
        this.maskShape = maskShape;
    }

    public String toString() {
        return "ReshapeVertex(reshapeOrder=" + this.getReshapeOrder() + ", newShape=" + Arrays.toString(this.getNewShape()) + ", maskShape=" + Arrays.toString(this.getMaskShape()) + ")";
    }
}

