/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.optimize.solvers.accumulation;

import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import lombok.NonNull;
import org.deeplearning4j.optimize.solvers.accumulation.Registerable;
import org.deeplearning4j.util.ThreadUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FancyBlockingQueue<E>
implements BlockingQueue<E>,
Registerable {
    private static final Logger log = LoggerFactory.getLogger(FancyBlockingQueue.class);
    protected BlockingQueue<E> backingQueue;
    protected volatile int consumers;
    protected ThreadLocal<AtomicLong> currentStep = new ThreadLocal();
    protected final AtomicLong step = new AtomicLong(0L);
    protected final AtomicInteger state = new AtomicInteger(0);
    protected final AtomicInteger currentConsumers = new AtomicInteger(0);
    protected AtomicBoolean isFirst = new AtomicBoolean(false);
    protected AtomicBoolean isDone = new AtomicBoolean(true);
    protected AtomicInteger barrier = new AtomicInteger(0);
    protected AtomicInteger secondary = new AtomicInteger(0);
    protected AtomicInteger numElementsReady = new AtomicInteger(0);
    protected AtomicInteger numElementsDrained = new AtomicInteger(0);
    protected AtomicBoolean bypassMode = new AtomicBoolean(false);
    protected boolean isDebug = false;
    protected ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    public FancyBlockingQueue(@NonNull BlockingQueue<E> queue) {
        this(queue, -1);
        if (queue == null) {
            throw new NullPointerException("queue is marked @NonNull but is null");
        }
    }

    public FancyBlockingQueue(@NonNull BlockingQueue<E> queue, int consumers) {
        if (queue == null) {
            throw new NullPointerException("queue is marked @NonNull but is null");
        }
        this.backingQueue = queue;
        this.consumers = consumers;
        this.currentConsumers.set(consumers);
    }

    @Override
    public boolean add(E e) {
        return this.backingQueue.add(e);
    }

    @Override
    public boolean offer(E e) {
        return this.backingQueue.offer(e);
    }

    @Override
    public E remove() {
        return this.backingQueue.remove();
    }

    @Override
    public void fallbackToSingleConsumerMode(boolean reallyFallback) {
        this.bypassMode.set(reallyFallback);
    }

    @Override
    public void registerConsumers(int consumers) {
        this.lock.writeLock().lock();
        this.numElementsReady.set(this.backingQueue.size());
        this.numElementsDrained.set(0);
        this.consumers = consumers;
        this.currentConsumers.set(consumers);
        this.lock.writeLock().unlock();
    }

    @Override
    public void put(E e) throws InterruptedException {
        this.lock.readLock().lock();
        log.info("Adding value to the buffer. Current size: [{}]", (Object)this.backingQueue.size());
        this.backingQueue.put(e);
        this.lock.readLock().unlock();
    }

    @Override
    public boolean isEmpty() {
        boolean res;
        if (this.bypassMode.get()) {
            return this.backingQueue.isEmpty();
        }
        boolean bl = res = this.numElementsDrained.get() >= this.numElementsReady.get();
        if (this.isDebug) {
            log.info("thread {} queries isEmpty: {}", (Object)Thread.currentThread().getId(), (Object)res);
        }
        return res;
    }

    protected void synchronize(int consumers) {
        if (consumers == 1 || this.bypassMode.get()) {
            return;
        }
        if (this.isDebug) {
            log.info("thread {} locking at FBQ", (Object)Thread.currentThread().getId());
        }
        this.isDone.compareAndSet(true, false);
        if (this.barrier.incrementAndGet() == consumers) {
            this.secondary.set(0);
            this.barrier.set(0);
            this.isFirst.set(false);
            this.isDone.set(true);
        } else {
            while (!this.isDone.get()) {
                ThreadUtils.uncheckedSleep((long)1L);
            }
        }
        if (this.secondary.incrementAndGet() == consumers) {
            this.isFirst.set(true);
        } else {
            while (!this.isFirst.get()) {
                ThreadUtils.uncheckedSleep((long)1L);
            }
        }
        if (this.isDebug) {
            log.info("thread {} unlocking at FBQ", (Object)Thread.currentThread().getId());
        }
    }

    @Override
    public E poll() {
        if (this.bypassMode.get()) {
            return this.backingQueue.poll();
        }
        if (this.currentStep.get() == null) {
            this.currentStep.set(new AtomicLong(-1L));
        }
        while (this.step.get() == this.currentStep.get().get()) {
            ThreadUtils.uncheckedSleep((long)1L);
        }
        E object = this.peek();
        this.synchronize(this.currentConsumers.get());
        this.currentStep.get().incrementAndGet();
        if (this.state.incrementAndGet() == this.currentConsumers.get()) {
            this.remove();
            this.numElementsDrained.incrementAndGet();
            this.state.set(0);
            this.step.incrementAndGet();
        }
        this.synchronize(this.currentConsumers.get());
        return object;
    }

    @Override
    public E element() {
        return this.backingQueue.element();
    }

    @Override
    public void clear() {
        this.backingQueue.clear();
        this.step.set(0L);
    }

    @Override
    public int size() {
        return this.backingQueue.size();
    }

    @Override
    public E peek() {
        return this.backingQueue.peek();
    }

    @Override
    public boolean offer(E e, long timeout, TimeUnit unit) throws InterruptedException {
        return this.backingQueue.offer(e, timeout, unit);
    }

    @Override
    public E take() throws InterruptedException {
        return null;
    }

    @Override
    public E poll(long timeout, TimeUnit unit) throws InterruptedException {
        return this.backingQueue.poll(timeout, unit);
    }

    @Override
    public int remainingCapacity() {
        return this.backingQueue.remainingCapacity();
    }

    @Override
    public boolean remove(Object o) {
        return this.backingQueue.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.backingQueue.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        return this.backingQueue.addAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.backingQueue.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.backingQueue.retainAll(c);
    }

    @Override
    public boolean contains(Object o) {
        return this.backingQueue.contains(o);
    }

    @Override
    public Iterator<E> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object[] toArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int drainTo(Collection<? super E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int drainTo(Collection<? super E> c, int maxElements) {
        throw new UnsupportedOperationException();
    }
}

