/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.layers.convolution.upsampling;

import java.util.Arrays;
import org.deeplearning4j.exception.DL4JInvalidInputException;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.layers.BaseUpsamplingLayer;
import org.deeplearning4j.nn.gradient.DefaultGradient;
import org.deeplearning4j.nn.gradient.Gradient;
import org.deeplearning4j.nn.layers.convolution.upsampling.Upsampling2D;
import org.deeplearning4j.nn.workspace.LayerWorkspaceMgr;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.CustomOp;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.primitives.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Upsampling1D
extends Upsampling2D {
    private static final Logger log = LoggerFactory.getLogger(Upsampling1D.class);

    public Upsampling1D(NeuralNetConfiguration conf) {
        super(conf);
    }

    public Upsampling1D(NeuralNetConfiguration conf, INDArray input) {
        super(conf, input);
    }

    @Override
    public Pair<Gradient, INDArray> backpropGradient(INDArray epsilon, LayerWorkspaceMgr workspaceMgr) {
        this.assertInputSet(true);
        int[] size = ((BaseUpsamplingLayer)this.layerConf()).getSize();
        epsilon = epsilon.reshape(new long[]{epsilon.size(0), epsilon.size(1), epsilon.size(2), 1L});
        epsilon = epsilon.repeat(3, new int[]{size[0]});
        INDArray originalInput = this.input;
        this.input = this.input.reshape(new long[]{this.input.size(0), this.input.size(1), this.input.size(2), 1L});
        int miniBatch = (int)this.input.size(0);
        int inDepth = (int)this.input.size(1);
        int inH = (int)this.input.size(2);
        int inW = (int)this.input.size(3);
        INDArray outEpsilon = Nd4j.create((int)(miniBatch * inDepth * inH * inW));
        INDArray reshapedEpsilon = outEpsilon.reshape('c', new int[]{miniBatch, inDepth, inH, inW});
        int[] intArgs = new int[]{1};
        DynamicCustomOp op = DynamicCustomOp.builder((String)"upsampling_bp").addIntegerArguments(intArgs).addInputs(new INDArray[]{this.input, epsilon}).addOutputs(new INDArray[]{reshapedEpsilon}).callInplace(false).build();
        Nd4j.getExecutioner().exec((CustomOp)op);
        DefaultGradient gradient = new DefaultGradient();
        reshapedEpsilon = reshapedEpsilon.slice(0L, 3);
        this.input = originalInput;
        return new Pair((Object)gradient, (Object)reshapedEpsilon.divi((Number)size[0]));
    }

    @Override
    protected int[] getSize() {
        return ((org.deeplearning4j.nn.conf.layers.Upsampling1D)this.conf.getLayer()).getSize();
    }

    @Override
    public INDArray activate(boolean training, LayerWorkspaceMgr workspaceMgr) {
        this.assertInputSet(false);
        if (this.input.rank() != 3) {
            throw new DL4JInvalidInputException("Got rank " + this.input.rank() + " array as input to Subsampling1DLayer with shape " + Arrays.toString(this.input.shape()) + ". Expected rank 3 array with shape [minibatchSize, features, length]. " + this.layerId());
        }
        INDArray origInput = this.input;
        this.input = this.input.reshape(new long[]{this.input.size(0), this.input.size(1), this.input.size(2), 1L});
        INDArray acts = super.activate(training, workspaceMgr);
        this.input = origInput;
        acts = acts.reshape(new long[]{acts.size(0), acts.size(1), acts.size(2)});
        return acts;
    }

    @Override
    protected INDArray preOutput(boolean training, boolean forBackprop, LayerWorkspaceMgr workspaceMgr) {
        INDArray originalInput = this.input;
        this.input = this.input.reshape(new long[]{this.input.size(0), this.input.size(1), this.input.size(2), 1L});
        INDArray preOutput = super.preOutput(training, forBackprop, workspaceMgr);
        this.input = originalInput;
        preOutput = preOutput.slice(0L, 3);
        return preOutput;
    }
}

