/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.serde;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.deeplearning4j.nn.conf.ComputationGraphConfiguration;
import org.deeplearning4j.nn.conf.InputPreProcessor;
import org.deeplearning4j.nn.conf.MultiLayerConfiguration;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.graph.GraphVertex;
import org.deeplearning4j.nn.conf.layers.Layer;
import org.deeplearning4j.nn.conf.layers.variational.ReconstructionDistribution;
import org.deeplearning4j.nn.conf.serde.ComputationGraphConfigurationDeserializer;
import org.deeplearning4j.nn.conf.serde.MultiLayerConfigurationDeserializer;
import org.nd4j.linalg.activations.IActivation;
import org.nd4j.linalg.lossfunctions.ILossFunction;
import org.nd4j.serde.json.LegacyIActivationDeserializer;
import org.nd4j.serde.json.LegacyILossFunctionDeserializer;
import org.nd4j.shade.jackson.annotation.JsonTypeInfo;
import org.nd4j.shade.jackson.core.JsonFactory;
import org.nd4j.shade.jackson.databind.AnnotationIntrospector;
import org.nd4j.shade.jackson.databind.BeanDescription;
import org.nd4j.shade.jackson.databind.DeserializationConfig;
import org.nd4j.shade.jackson.databind.DeserializationFeature;
import org.nd4j.shade.jackson.databind.JavaType;
import org.nd4j.shade.jackson.databind.JsonDeserializer;
import org.nd4j.shade.jackson.databind.MapperFeature;
import org.nd4j.shade.jackson.databind.Module;
import org.nd4j.shade.jackson.databind.ObjectMapper;
import org.nd4j.shade.jackson.databind.SerializationFeature;
import org.nd4j.shade.jackson.databind.cfg.MapperConfig;
import org.nd4j.shade.jackson.databind.deser.BeanDeserializerModifier;
import org.nd4j.shade.jackson.databind.introspect.Annotated;
import org.nd4j.shade.jackson.databind.introspect.AnnotatedClass;
import org.nd4j.shade.jackson.databind.introspect.AnnotationMap;
import org.nd4j.shade.jackson.databind.introspect.JacksonAnnotationIntrospector;
import org.nd4j.shade.jackson.databind.jsontype.TypeResolverBuilder;
import org.nd4j.shade.jackson.databind.module.SimpleModule;
import org.nd4j.shade.jackson.dataformat.yaml.YAMLFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonMappers {
    private static final Logger log = LoggerFactory.getLogger(JsonMappers.class);
    @Deprecated
    public static String CUSTOM_REGISTRATION_PROPERTY = "org.deeplearning4j.config.custom.legacyclasses";
    private static ObjectMapper jsonMapper;
    private static ObjectMapper yamlMapper;
    private static ObjectMapper jsonMapperLegacyFormatLayer;
    private static ObjectMapper jsonMapperLegacyFormatVertex;
    private static ObjectMapper jsonMapperLegacyFormatPreproc;
    private static ObjectMapper jsonMapperLegacyFormatIActivation;
    private static ObjectMapper jsonMapperLegacyFormatILoss;
    private static ObjectMapper jsonMapperLegacyFormatReconstruction;

    public static ObjectMapper getMapper() {
        return jsonMapper;
    }

    public static ObjectMapper getMapperYaml() {
        return yamlMapper;
    }

    private static void configureMapper(ObjectMapper ret) {
        ret.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        ret.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        ret.configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, true);
        ret.enable(SerializationFeature.INDENT_OUTPUT);
        SimpleModule customDeserializerModule = new SimpleModule();
        customDeserializerModule.setDeserializerModifier(new BeanDeserializerModifier(){

            public JsonDeserializer<?> modifyDeserializer(DeserializationConfig config, BeanDescription beanDesc, JsonDeserializer<?> deserializer) {
                if (beanDesc.getBeanClass() == MultiLayerConfiguration.class) {
                    return new MultiLayerConfigurationDeserializer(deserializer);
                }
                if (beanDesc.getBeanClass() == ComputationGraphConfiguration.class) {
                    return new ComputationGraphConfigurationDeserializer(deserializer);
                }
                return deserializer;
            }
        });
        ret.registerModule((Module)customDeserializerModule);
    }

    public static ObjectMapper getJsonMapperLegacyFormatLayer() {
        return jsonMapperLegacyFormatLayer;
    }

    public static ObjectMapper getJsonMapperLegacyFormatVertex() {
        return jsonMapperLegacyFormatVertex;
    }

    public static ObjectMapper getJsonMapperLegacyFormatPreproc() {
        return jsonMapperLegacyFormatPreproc;
    }

    public static ObjectMapper getJsonMapperLegacyFormatIActivation() {
        return jsonMapperLegacyFormatIActivation;
    }

    public static ObjectMapper getJsonMapperLegacyFormatILoss() {
        return jsonMapperLegacyFormatILoss;
    }

    public static ObjectMapper getJsonMapperLegacyFormatReconstruction() {
        return jsonMapperLegacyFormatReconstruction;
    }

    static {
        String p = System.getProperty("org.deeplearning4j.config.custom.legacyclasses");
        if (p != null && !p.isEmpty()) {
            String[] split = p.split(",");
            ArrayList list = new ArrayList();
            for (String s : split) {
                try {
                    Class<?> c = Class.forName(s);
                    list.add(c);
                }
                catch (Throwable t) {
                    log.warn("Error parsing {} system property: class \"{}\" could not be loaded", new Object[]{"org.deeplearning4j.config.custom.legacyclasses", s, t});
                }
            }
            if (list.size() > 0) {
                try {
                    NeuralNetConfiguration.registerLegacyCustomClassesForJSONList(list);
                }
                catch (Throwable t) {
                    log.warn("Error registering custom classes for legacy JSON deserialization ({} system property)", (Object)"org.deeplearning4j.config.custom.legacyclasses", (Object)t);
                }
            }
        }
        jsonMapper = new ObjectMapper();
        yamlMapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        jsonMapperLegacyFormatLayer = new ObjectMapper();
        jsonMapperLegacyFormatVertex = new ObjectMapper();
        jsonMapperLegacyFormatPreproc = new ObjectMapper();
        jsonMapperLegacyFormatIActivation = new ObjectMapper();
        jsonMapperLegacyFormatILoss = new ObjectMapper();
        jsonMapperLegacyFormatReconstruction = new ObjectMapper();
        JsonMappers.configureMapper(jsonMapper);
        JsonMappers.configureMapper(yamlMapper);
        JsonMappers.configureMapper(jsonMapperLegacyFormatLayer);
        JsonMappers.configureMapper(jsonMapperLegacyFormatVertex);
        JsonMappers.configureMapper(jsonMapperLegacyFormatPreproc);
        JsonMappers.configureMapper(jsonMapperLegacyFormatIActivation);
        JsonMappers.configureMapper(jsonMapperLegacyFormatILoss);
        JsonMappers.configureMapper(jsonMapperLegacyFormatReconstruction);
        jsonMapperLegacyFormatLayer.setAnnotationIntrospector((AnnotationIntrospector)new IgnoreJsonTypeInfoIntrospector(Collections.singletonList(Layer.class)));
        jsonMapperLegacyFormatVertex.setAnnotationIntrospector((AnnotationIntrospector)new IgnoreJsonTypeInfoIntrospector(Collections.singletonList(GraphVertex.class)));
        jsonMapperLegacyFormatPreproc.setAnnotationIntrospector((AnnotationIntrospector)new IgnoreJsonTypeInfoIntrospector(Collections.singletonList(InputPreProcessor.class)));
        jsonMapperLegacyFormatIActivation.setAnnotationIntrospector((AnnotationIntrospector)new IgnoreJsonTypeInfoIntrospector(Collections.singletonList(IActivation.class)));
        jsonMapperLegacyFormatILoss.setAnnotationIntrospector((AnnotationIntrospector)new IgnoreJsonTypeInfoIntrospector(Collections.singletonList(ILossFunction.class)));
        jsonMapperLegacyFormatReconstruction.setAnnotationIntrospector((AnnotationIntrospector)new IgnoreJsonTypeInfoIntrospector(Collections.singletonList(ReconstructionDistribution.class)));
        LegacyIActivationDeserializer.setLegacyJsonMapper((ObjectMapper)jsonMapperLegacyFormatIActivation);
        LegacyILossFunctionDeserializer.setLegacyJsonMapper((ObjectMapper)jsonMapperLegacyFormatILoss);
    }

    private static class IgnoreJsonTypeInfoIntrospector
    extends JacksonAnnotationIntrospector {
        private List<Class> classList;

        protected TypeResolverBuilder<?> _findTypeResolver(MapperConfig<?> config, Annotated ann, JavaType baseType) {
            if (ann instanceof AnnotatedClass) {
                AnnotatedClass c = (AnnotatedClass)ann;
                Class annClass = c.getAnnotated();
                boolean isAssignable = false;
                for (Class c2 : this.classList) {
                    if (!c2.isAssignableFrom(annClass)) continue;
                    isAssignable = true;
                    break;
                }
                if (isAssignable) {
                    AnnotationMap annotations = (AnnotationMap)((AnnotatedClass)ann).getAnnotations();
                    if (annotations == null || annotations.annotations() == null) {
                        return super._findTypeResolver(config, ann, baseType);
                    }
                    AnnotationMap newMap = null;
                    for (Annotation a : annotations.annotations()) {
                        Class<? extends Annotation> annType = a.annotationType();
                        if (annType == JsonTypeInfo.class) continue;
                        if (newMap == null) {
                            newMap = new AnnotationMap();
                        }
                        newMap.add(a);
                    }
                    if (newMap == null) {
                        return null;
                    }
                    AnnotatedClass ann2 = c.withAnnotations(newMap);
                    return super._findTypeResolver(config, (Annotated)ann2, baseType);
                }
            }
            return super._findTypeResolver(config, ann, baseType);
        }

        public IgnoreJsonTypeInfoIntrospector(List<Class> classList) {
            this.classList = classList;
        }
    }
}

