/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.preprocessor;

import java.util.Arrays;
import org.deeplearning4j.nn.api.MaskState;
import org.deeplearning4j.nn.conf.InputPreProcessor;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.workspace.ArrayType;
import org.deeplearning4j.nn.workspace.LayerWorkspaceMgr;
import org.deeplearning4j.util.TimeSeriesUtils;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.shape.Shape;
import org.nd4j.linalg.primitives.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RnnToFeedForwardPreProcessor
implements InputPreProcessor {
    private static final Logger log = LoggerFactory.getLogger(RnnToFeedForwardPreProcessor.class);

    @Override
    public INDArray preProcess(INDArray input, int miniBatchSize, LayerWorkspaceMgr workspaceMgr) {
        INDArray ret;
        long[] shape;
        if (input.rank() != 3) {
            throw new IllegalArgumentException("Invalid input: expect NDArray with rank 3 (i.e., activations for RNN layer)");
        }
        if (input.ordering() != 'f' || !Shape.hasDefaultStridesForShape((INDArray)input)) {
            input = workspaceMgr.dup(ArrayType.ACTIVATIONS, input, 'f');
        }
        if ((shape = input.shape())[0] == 1L) {
            ret = input.tensorAlongDimension(0, new int[]{1, 2}).permutei(new int[]{1, 0});
        } else if (shape[2] == 1L) {
            ret = input.tensorAlongDimension(0, new int[]{1, 0});
        } else {
            INDArray permuted = input.permute(new int[]{0, 2, 1});
            ret = permuted.reshape('f', new long[]{shape[0] * shape[2], shape[1]});
        }
        return workspaceMgr.leverageTo(ArrayType.ACTIVATIONS, ret);
    }

    @Override
    public INDArray backprop(INDArray output, int miniBatchSize, LayerWorkspaceMgr workspaceMgr) {
        if (output == null) {
            return null;
        }
        if (output.rank() != 2) {
            throw new IllegalArgumentException("Invalid input: expect NDArray with rank 2 (i.e., epsilons from feed forward layer)");
        }
        if (output.ordering() != 'f' || !Shape.hasDefaultStridesForShape((INDArray)output)) {
            output = workspaceMgr.dup(ArrayType.ACTIVATION_GRAD, output, 'f');
        }
        long[] shape = output.shape();
        INDArray reshaped = output.reshape('f', new long[]{miniBatchSize, shape[0] / (long)miniBatchSize, shape[1]});
        return workspaceMgr.leverageTo(ArrayType.ACTIVATION_GRAD, reshaped.permute(new int[]{0, 2, 1}));
    }

    @Override
    public RnnToFeedForwardPreProcessor clone() {
        try {
            RnnToFeedForwardPreProcessor clone = (RnnToFeedForwardPreProcessor)super.clone();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public InputType getOutputType(InputType inputType) {
        if (inputType == null || inputType.getType() != InputType.Type.RNN) {
            throw new IllegalStateException("Invalid input: expected input of type RNN, got " + inputType);
        }
        InputType.InputTypeRecurrent rnn = (InputType.InputTypeRecurrent)inputType;
        return InputType.feedForward(rnn.getSize());
    }

    @Override
    public Pair<INDArray, MaskState> feedForwardMaskArray(INDArray maskArray, MaskState currentMaskState, int minibatchSize) {
        if (maskArray == null) {
            return new Pair((Object)maskArray, (Object)currentMaskState);
        }
        if (maskArray.rank() == 2) {
            return new Pair((Object)TimeSeriesUtils.reshapeTimeSeriesMaskToVector(maskArray, LayerWorkspaceMgr.noWorkspaces(), ArrayType.INPUT), (Object)currentMaskState);
        }
        throw new IllegalArgumentException("Received mask array of rank " + maskArray.rank() + "; expected rank 2 mask array. Mask array shape: " + Arrays.toString(maskArray.shape()));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RnnToFeedForwardPreProcessor)) {
            return false;
        }
        RnnToFeedForwardPreProcessor other = (RnnToFeedForwardPreProcessor)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof RnnToFeedForwardPreProcessor;
    }

    public int hashCode() {
        int result = 1;
        return result;
    }

    public String toString() {
        return "RnnToFeedForwardPreProcessor()";
    }
}

