/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.layers;

import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.gradient.DefaultGradient;
import org.deeplearning4j.nn.gradient.Gradient;
import org.deeplearning4j.nn.layers.AbstractLayer;
import org.deeplearning4j.nn.workspace.ArrayType;
import org.deeplearning4j.nn.workspace.LayerWorkspaceMgr;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.primitives.Pair;

public class ActivationLayer
extends AbstractLayer<org.deeplearning4j.nn.conf.layers.ActivationLayer> {
    public ActivationLayer(NeuralNetConfiguration conf) {
        super(conf);
    }

    public ActivationLayer(NeuralNetConfiguration conf, INDArray input) {
        super(conf, input);
    }

    @Override
    public double calcL2(boolean backpropParamsOnly) {
        return 0.0;
    }

    @Override
    public double calcL1(boolean backpropParamsOnly) {
        return 0.0;
    }

    @Override
    public Layer.Type type() {
        return Layer.Type.FEED_FORWARD;
    }

    @Override
    public Pair<Gradient, INDArray> backpropGradient(INDArray epsilon, LayerWorkspaceMgr workspaceMgr) {
        this.assertInputSet(true);
        INDArray temp = workspaceMgr.dup(ArrayType.ACTIVATION_GRAD, this.input, this.input.ordering());
        INDArray delta = (INDArray)((org.deeplearning4j.nn.conf.layers.ActivationLayer)this.layerConf()).getActivationFn().backprop(temp, epsilon).getFirst();
        if (delta == epsilon) {
            delta = workspaceMgr.dup(ArrayType.ACTIVATION_GRAD, delta);
        }
        delta = workspaceMgr.leverageTo(ArrayType.ACTIVATION_GRAD, delta);
        delta = this.backpropDropOutIfPresent(delta);
        DefaultGradient ret = new DefaultGradient();
        return new Pair((Object)ret, (Object)delta);
    }

    @Override
    public INDArray activate(boolean training, LayerWorkspaceMgr mgr) {
        this.assertInputSet(false);
        this.applyDropOutIfNecessary(training, mgr);
        INDArray in = training ? mgr.dup(ArrayType.ACTIVATIONS, this.input, this.input.ordering()) : mgr.leverageTo(ArrayType.ACTIVATIONS, this.input);
        return ((org.deeplearning4j.nn.conf.layers.ActivationLayer)this.layerConf()).getActivationFn().getActivation(in, training);
    }

    @Override
    public boolean isPretrainLayer() {
        return false;
    }

    @Override
    public void clearNoiseWeightParams() {
    }

    @Override
    public INDArray params() {
        return null;
    }
}

