/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.layers.convolutional;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import lombok.NonNull;
import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.conf.InputPreProcessor;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.layers.InputTypeUtil;
import org.deeplearning4j.nn.conf.layers.Layer;
import org.deeplearning4j.nn.conf.layers.NoParamLayer;
import org.deeplearning4j.nn.conf.memory.LayerMemoryReport;
import org.deeplearning4j.nn.layers.convolution.Cropping1DLayer;
import org.deeplearning4j.optimize.api.TrainingListener;
import org.nd4j.linalg.api.ndarray.INDArray;

public class Cropping1D
extends NoParamLayer {
    private int[] cropping;

    public Cropping1D(int cropTopBottom) {
        this(cropTopBottom, cropTopBottom);
    }

    public Cropping1D(int cropTop, int cropBottom) {
        this(new Builder(cropTop, cropBottom));
    }

    public Cropping1D(int[] cropping) {
        this(new Builder(cropping));
    }

    protected Cropping1D(Builder builder) {
        super(builder);
        this.cropping = builder.cropping;
    }

    @Override
    public Layer instantiate(NeuralNetConfiguration conf, Collection<TrainingListener> trainingListeners, int layerIndex, INDArray layerParamsView, boolean initializeParams) {
        Cropping1DLayer ret = new Cropping1DLayer(conf);
        ret.setListeners(trainingListeners);
        ret.setIndex(layerIndex);
        Map<String, INDArray> paramTable = this.initializer().init(conf, layerParamsView, initializeParams);
        ret.setParamTable(paramTable);
        ret.setConf(conf);
        return ret;
    }

    @Override
    public InputType getOutputType(int layerIndex, InputType inputType) {
        if (inputType == null || inputType.getType() != InputType.Type.RNN) {
            throw new IllegalStateException("Invalid input for 1D Cropping layer (layer index = " + layerIndex + ", layer name = \"" + this.getLayerName() + "\"): expect RNN input type with size > 0. Got: " + inputType);
        }
        InputType.InputTypeRecurrent cnn1d = (InputType.InputTypeRecurrent)inputType;
        long length = cnn1d.getTimeSeriesLength();
        long outLength = length - (long)this.cropping[0] - (long)this.cropping[1];
        return InputType.recurrent(cnn1d.getSize(), outLength);
    }

    @Override
    public InputPreProcessor getPreProcessorForInputType(InputType inputType) {
        Preconditions.checkArgument((inputType != null ? 1 : 0) != 0, (Object)("Invalid input for Cropping1D layer (layer name=\"" + this.getLayerName() + "\"): InputType is null"));
        return InputTypeUtil.getPreProcessorForInputTypeCnnLayers(inputType, this.getLayerName());
    }

    @Override
    public LayerMemoryReport getMemoryReport(InputType inputType) {
        return null;
    }

    public int[] getCropping() {
        return this.cropping;
    }

    public void setCropping(int[] cropping) {
        this.cropping = cropping;
    }

    @Override
    public String toString() {
        return "Cropping1D(cropping=" + Arrays.toString(this.getCropping()) + ")";
    }

    public Cropping1D() {
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Cropping1D)) {
            return false;
        }
        Cropping1D other = (Cropping1D)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return Arrays.equals(this.getCropping(), other.getCropping());
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Cropping1D;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + Arrays.hashCode(this.getCropping());
        return result;
    }

    public static class Builder
    extends Layer.Builder<Builder> {
        private int[] cropping = new int[]{0, 0};

        public Builder() {
        }

        public Builder(@NonNull int[] cropping) {
            if (cropping == null) {
                throw new NullPointerException("cropping is marked @NonNull but is null");
            }
            Preconditions.checkArgument((cropping.length == 2 || cropping.length == 1 ? 1 : 0) != 0, (Object)("Two cropping values, i.e. top and bottom, or one value for bot top and bottommust be provided. Got " + cropping.length + " values: " + Arrays.toString(cropping)));
            this.cropping = cropping.length == 2 ? cropping : new int[]{cropping[0], cropping[0]};
        }

        public Builder(int cropTopBottom) {
            this(cropTopBottom, cropTopBottom);
        }

        public Builder(int cropTop, int cropBottom) {
            this.cropping = new int[]{cropTop, cropBottom};
            Preconditions.checkArgument((cropTop >= 0 && cropBottom >= 0 ? 1 : 0) != 0, (Object)("Invalid arguments: crop dimensions must be > 0. Got [t,b] = " + Arrays.toString(this.cropping)));
        }

        @Override
        public Cropping1D build() {
            return new Cropping1D(this);
        }
    }
}

