/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.earlystopping.termination;

import org.deeplearning4j.earlystopping.termination.EpochTerminationCondition;
import org.nd4j.shade.jackson.annotation.JsonCreator;
import org.nd4j.shade.jackson.annotation.JsonProperty;

public class MaxEpochsTerminationCondition
implements EpochTerminationCondition {
    @JsonProperty
    private int maxEpochs;

    @JsonCreator
    public MaxEpochsTerminationCondition(int maxEpochs) {
        if (maxEpochs <= 0) {
            throw new IllegalArgumentException("Max number of epochs must be >= 1");
        }
        this.maxEpochs = maxEpochs;
    }

    @Override
    public void initialize() {
    }

    @Override
    public boolean terminate(int epochNum, double score) {
        return epochNum + 1 >= this.maxEpochs;
    }

    public String toString() {
        return "MaxEpochsTerminationCondition(" + this.maxEpochs + ")";
    }

    public MaxEpochsTerminationCondition() {
    }
}

