/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.earlystopping.termination;

import org.deeplearning4j.earlystopping.termination.EpochTerminationCondition;
import org.nd4j.shade.jackson.annotation.JsonProperty;

public class BestScoreEpochTerminationCondition
implements EpochTerminationCondition {
    @JsonProperty
    private final double bestExpectedScore;
    @JsonProperty
    private boolean lesserBetter = true;

    public BestScoreEpochTerminationCondition(double bestExpectedScore) {
        this.bestExpectedScore = bestExpectedScore;
    }

    public BestScoreEpochTerminationCondition(double bestExpectedScore, boolean lesserBetter) {
        this(bestExpectedScore);
        this.lesserBetter = lesserBetter;
    }

    @Override
    public void initialize() {
    }

    @Override
    public boolean terminate(int epochNum, double score) {
        if (this.lesserBetter) {
            return score < this.bestExpectedScore;
        }
        return this.bestExpectedScore < score;
    }

    public String toString() {
        return "BestScoreEpochTerminationCondition(" + this.bestExpectedScore + ")";
    }

    public double getBestExpectedScore() {
        return this.bestExpectedScore;
    }

    public boolean isLesserBetter() {
        return this.lesserBetter;
    }

    public void setLesserBetter(boolean lesserBetter) {
        this.lesserBetter = lesserBetter;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BestScoreEpochTerminationCondition)) {
            return false;
        }
        BestScoreEpochTerminationCondition other = (BestScoreEpochTerminationCondition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getBestExpectedScore(), other.getBestExpectedScore()) != 0) {
            return false;
        }
        return this.isLesserBetter() == other.isLesserBetter();
    }

    protected boolean canEqual(Object other) {
        return other instanceof BestScoreEpochTerminationCondition;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $bestExpectedScore = Double.doubleToLongBits(this.getBestExpectedScore());
        result = result * 59 + (int)($bestExpectedScore >>> 32 ^ $bestExpectedScore);
        result = result * 59 + (this.isLesserBetter() ? 79 : 97);
        return result;
    }
}

