/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.layers.recurrent;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.deeplearning4j.nn.api.layers.RecurrentLayer;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.layers.BaseLayer;
import org.nd4j.linalg.api.ndarray.INDArray;

public abstract class BaseRecurrentLayer<LayerConfT extends org.deeplearning4j.nn.conf.layers.BaseLayer>
extends BaseLayer<LayerConfT>
implements RecurrentLayer {
    protected Map<String, INDArray> stateMap = new ConcurrentHashMap<String, INDArray>();
    protected Map<String, INDArray> tBpttStateMap = new ConcurrentHashMap<String, INDArray>();

    public BaseRecurrentLayer(NeuralNetConfiguration conf) {
        super(conf);
    }

    public BaseRecurrentLayer(NeuralNetConfiguration conf, INDArray input) {
        super(conf, input);
    }

    @Override
    public Map<String, INDArray> rnnGetPreviousState() {
        return new HashMap<String, INDArray>(this.stateMap);
    }

    @Override
    public void rnnSetPreviousState(Map<String, INDArray> stateMap) {
        this.stateMap.clear();
        this.stateMap.putAll(stateMap);
    }

    @Override
    public void rnnClearPreviousState() {
        this.stateMap.clear();
        this.tBpttStateMap.clear();
    }

    @Override
    public Map<String, INDArray> rnnGetTBPTTState() {
        return new HashMap<String, INDArray>(this.tBpttStateMap);
    }

    @Override
    public void rnnSetTBPTTState(Map<String, INDArray> state) {
        this.tBpttStateMap.clear();
        this.tBpttStateMap.putAll(state);
    }
}

