/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.preprocessor;

import java.util.Arrays;
import org.deeplearning4j.nn.api.MaskState;
import org.deeplearning4j.nn.conf.InputPreProcessor;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.workspace.ArrayType;
import org.deeplearning4j.nn.workspace.LayerWorkspaceMgr;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.shape.Shape;
import org.nd4j.linalg.primitives.Pair;
import org.nd4j.linalg.util.ArrayUtil;
import org.nd4j.shade.jackson.annotation.JsonCreator;
import org.nd4j.shade.jackson.annotation.JsonProperty;

public class FeedForwardToCnn3DPreProcessor
implements InputPreProcessor {
    private int inputDepth;
    private int inputHeight;
    private int inputWidth;
    private int numChannels;
    private boolean isNCDHW = true;
    private int[] shape;

    @JsonCreator
    public FeedForwardToCnn3DPreProcessor(@JsonProperty(value="inputDepth") int inputDepth, @JsonProperty(value="inputHeight") int inputHeight, @JsonProperty(value="inputWidth") int inputWidth, @JsonProperty(value="numChannels") int numChannels, @JsonProperty(value="isNCDHW") boolean isNCDHW) {
        this.inputDepth = inputDepth;
        this.inputHeight = inputHeight;
        this.inputWidth = inputWidth;
        this.numChannels = numChannels;
        this.isNCDHW = isNCDHW;
    }

    public FeedForwardToCnn3DPreProcessor(int inputDepth, int inputWidth, int inputHeight) {
        this.inputDepth = inputDepth;
        this.inputHeight = inputHeight;
        this.inputWidth = inputWidth;
        this.numChannels = 1;
    }

    @Override
    public INDArray preProcess(INDArray input, int miniBatchSize, LayerWorkspaceMgr workspaceMgr) {
        this.shape = input.shape();
        if (this.shape.length == 5) {
            return workspaceMgr.leverageTo(ArrayType.ACTIVATIONS, input);
        }
        if (!Shape.hasDefaultStridesForShape((INDArray)input)) {
            input = workspaceMgr.dup(ArrayType.ACTIVATIONS, input, 'c');
        }
        if (input.columns() != this.inputDepth * this.inputWidth * this.inputHeight * this.numChannels) {
            throw new IllegalArgumentException("Invalid input: expect output columns must be equal to channels " + this.inputDepth + " times height " + this.inputWidth + "times width " + this.inputWidth + " times channels " + this.numChannels + " but was instead " + Arrays.toString(input.shape()));
        }
        INDArray ret = this.isNCDHW ? input.reshape('c', new int[]{input.size(0), this.numChannels, this.inputDepth, this.inputHeight, this.inputWidth}) : input.reshape('c', new int[]{input.size(0), this.inputDepth, this.inputHeight, this.inputWidth, this.numChannels});
        return workspaceMgr.leverageTo(ArrayType.ACTIVATIONS, ret);
    }

    @Override
    public INDArray backprop(INDArray epsilons, int miniBatchSize, LayerWorkspaceMgr workspaceMgr) {
        if (!Shape.hasDefaultStridesForShape((INDArray)epsilons)) {
            epsilons = workspaceMgr.dup(ArrayType.ACTIVATION_GRAD, epsilons, 'c');
        }
        if (this.shape == null || ArrayUtil.prod((int[])this.shape) != epsilons.length()) {
            INDArray ret = epsilons.reshape('c', epsilons.size(0), this.inputDepth * this.inputHeight * this.inputWidth * this.numChannels);
            return workspaceMgr.leverageTo(ArrayType.ACTIVATION_GRAD, ret);
        }
        return workspaceMgr.leverageTo(ArrayType.ACTIVATION_GRAD, epsilons.reshape('c', this.shape));
    }

    @Override
    public FeedForwardToCnn3DPreProcessor clone() {
        try {
            FeedForwardToCnn3DPreProcessor clone = (FeedForwardToCnn3DPreProcessor)super.clone();
            if (clone.shape != null) {
                clone.shape = (int[])clone.shape.clone();
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public InputType getOutputType(InputType inputType) {
        switch (inputType.getType()) {
            case FF: {
                InputType.InputTypeFeedForward c = (InputType.InputTypeFeedForward)inputType;
                int expSize = this.inputDepth * this.inputHeight * this.inputWidth * this.numChannels;
                if (c.getSize() != expSize) {
                    throw new IllegalStateException("Invalid input: expected FeedForward input of size " + expSize + " = (d=" + this.numChannels + " * w=" + this.inputWidth + " * h=" + this.inputHeight + "), got " + inputType);
                }
                return InputType.convolutional3D(this.inputDepth, this.inputHeight, this.inputWidth, this.numChannels);
            }
            case CNN: {
                InputType.InputTypeConvolutional c2 = (InputType.InputTypeConvolutional)inputType;
                if (c2.getChannels() != this.numChannels || c2.getHeight() != this.inputHeight || c2.getWidth() != this.inputWidth) {
                    throw new IllegalStateException("Invalid input: Got CNN input type with (c,w,h)=(" + c2.getChannels() + "," + c2.getWidth() + "," + c2.getHeight() + ") but expected (" + this.numChannels + "," + this.inputHeight + "," + this.inputWidth + ")");
                }
                return InputType.convolutional3D(1, c2.getHeight(), c2.getWidth(), c2.getChannels());
            }
            case CNN3D: {
                InputType.InputTypeConvolutional3D c3 = (InputType.InputTypeConvolutional3D)inputType;
                if (c3.getChannels() != this.numChannels || c3.getDepth() != this.inputDepth || c3.getHeight() != this.inputHeight || c3.getWidth() != this.inputWidth) {
                    throw new IllegalStateException("Invalid input: Got CNN input type with (c, d,w,h)=(" + c3.getChannels() + "," + c3.getDepth() + "," + c3.getWidth() + "," + c3.getHeight() + ") but expected (" + this.numChannels + "," + this.inputDepth + "," + this.inputHeight + "," + this.inputWidth + ")");
                }
                return c3;
            }
        }
        throw new IllegalStateException("Invalid input type: got " + inputType);
    }

    @Override
    public Pair<INDArray, MaskState> feedForwardMaskArray(INDArray maskArray, MaskState currentMaskState, int minibatchSize) {
        return new Pair((Object)maskArray, (Object)currentMaskState);
    }

    public int getInputDepth() {
        return this.inputDepth;
    }

    public int getInputHeight() {
        return this.inputHeight;
    }

    public int getInputWidth() {
        return this.inputWidth;
    }

    public int getNumChannels() {
        return this.numChannels;
    }

    public boolean isNCDHW() {
        return this.isNCDHW;
    }

    public void setInputDepth(int inputDepth) {
        this.inputDepth = inputDepth;
    }

    public void setInputHeight(int inputHeight) {
        this.inputHeight = inputHeight;
    }

    public void setInputWidth(int inputWidth) {
        this.inputWidth = inputWidth;
    }

    public void setNumChannels(int numChannels) {
        this.numChannels = numChannels;
    }

    public void setNCDHW(boolean isNCDHW) {
        this.isNCDHW = isNCDHW;
    }

    public String toString() {
        return "FeedForwardToCnn3DPreProcessor(inputDepth=" + this.getInputDepth() + ", inputHeight=" + this.getInputHeight() + ", inputWidth=" + this.getInputWidth() + ", numChannels=" + this.getNumChannels() + ", isNCDHW=" + this.isNCDHW() + ", shape=" + Arrays.toString(this.shape) + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FeedForwardToCnn3DPreProcessor)) {
            return false;
        }
        FeedForwardToCnn3DPreProcessor other = (FeedForwardToCnn3DPreProcessor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getInputDepth() != other.getInputDepth()) {
            return false;
        }
        if (this.getInputHeight() != other.getInputHeight()) {
            return false;
        }
        if (this.getInputWidth() != other.getInputWidth()) {
            return false;
        }
        if (this.getNumChannels() != other.getNumChannels()) {
            return false;
        }
        return this.isNCDHW() == other.isNCDHW();
    }

    protected boolean canEqual(Object other) {
        return other instanceof FeedForwardToCnn3DPreProcessor;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getInputDepth();
        result = result * 59 + this.getInputHeight();
        result = result * 59 + this.getInputWidth();
        result = result * 59 + this.getNumChannels();
        result = result * 59 + (this.isNCDHW() ? 79 : 97);
        return result;
    }
}

