/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.preprocessor;

import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.preprocessor.BaseInputPreProcessor;
import org.deeplearning4j.nn.workspace.ArrayType;
import org.deeplearning4j.nn.workspace.LayerWorkspaceMgr;
import org.nd4j.linalg.api.memory.MemoryWorkspace;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;

public class BinomialSamplingPreProcessor
extends BaseInputPreProcessor {
    @Override
    public INDArray preProcess(INDArray input, int miniBatchSize, LayerWorkspaceMgr workspaceMgr) {
        try (MemoryWorkspace ws = workspaceMgr.notifyScopeEntered(ArrayType.ACTIVATIONS);){
            INDArray iNDArray = Nd4j.getDistributions().createBinomial(1, input).sample(input.shape());
            return iNDArray;
        }
    }

    @Override
    public INDArray backprop(INDArray output, int miniBatchSize, LayerWorkspaceMgr workspaceMgr) {
        return output;
    }

    @Override
    public InputType getOutputType(InputType inputType) {
        if (inputType == null) {
            throw new IllegalStateException("Invalid input type: cannot be null");
        }
        return inputType;
    }

    public String toString() {
        return "BinomialSamplingPreProcessor()";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BinomialSamplingPreProcessor)) {
            return false;
        }
        BinomialSamplingPreProcessor other = (BinomialSamplingPreProcessor)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof BinomialSamplingPreProcessor;
    }

    public int hashCode() {
        int result = 1;
        return result;
    }
}

