/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.layers;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.deeplearning4j.exception.DL4JInvalidConfigException;
import org.deeplearning4j.nn.api.layers.LayerConstraint;
import org.deeplearning4j.nn.conf.distribution.Distribution;
import org.deeplearning4j.nn.conf.distribution.NormalDistribution;
import org.deeplearning4j.nn.conf.dropout.IDropout;
import org.deeplearning4j.nn.conf.layers.BaseLayer;
import org.deeplearning4j.nn.conf.layers.Layer;
import org.deeplearning4j.nn.conf.layers.misc.FrozenLayer;
import org.deeplearning4j.nn.conf.layers.recurrent.Bidirectional;
import org.deeplearning4j.nn.weights.WeightInit;
import org.nd4j.util.OneTimeLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LayerValidation {
    private static final Logger log = LoggerFactory.getLogger(LayerValidation.class);

    public static void assertNInNOutSet(String layerType, String layerName, int layerIndex, int nIn, int nOut) {
        if (nIn <= 0 || nOut <= 0) {
            if (layerName == null) {
                layerName = "(name not set)";
            }
            throw new DL4JInvalidConfigException(layerType + " (index=" + layerIndex + ", name=" + layerName + ") nIn=" + nIn + ", nOut=" + nOut + "; nIn and nOut must be > 0");
        }
    }

    public static void generalValidation(String layerName, Layer layer, IDropout iDropOut, Double l2, Double l2Bias, Double l1, Double l1Bias, Distribution dist, List<LayerConstraint> allParamConstraints, List<LayerConstraint> weightConstraints, List<LayerConstraint> biasConstraints) {
        LayerValidation.generalValidation(layerName, layer, iDropOut, l2 == null ? Double.NaN : l2, l2Bias == null ? Double.NaN : l2Bias, l1 == null ? Double.NaN : l1, l1Bias == null ? Double.NaN : l1Bias, dist, allParamConstraints, weightConstraints, biasConstraints);
    }

    public static void generalValidation(String layerName, Layer layer, IDropout iDropout, double l2, double l2Bias, double l1, double l1Bias, Distribution dist, List<LayerConstraint> allParamConstraints, List<LayerConstraint> weightConstraints, List<LayerConstraint> biasConstraints) {
        if (layer != null) {
            BaseLayer bLayer;
            if (layer instanceof BaseLayer) {
                bLayer = (BaseLayer)layer;
                LayerValidation.configureBaseLayer(layerName, bLayer, iDropout, l2, l2Bias, l1, l1Bias, dist);
            } else if (layer instanceof FrozenLayer && ((FrozenLayer)layer).getLayer() instanceof BaseLayer) {
                bLayer = (BaseLayer)((FrozenLayer)layer).getLayer();
                LayerValidation.configureBaseLayer(layerName, bLayer, iDropout, l2, l2Bias, l1, l1Bias, dist);
            } else if (layer instanceof Bidirectional) {
                Bidirectional l = (Bidirectional)layer;
                LayerValidation.generalValidation(layerName, l.getFwd(), iDropout, l2, l2Bias, l1, l1Bias, dist, allParamConstraints, weightConstraints, biasConstraints);
                LayerValidation.generalValidation(layerName, l.getBwd(), iDropout, l2, l2Bias, l1, l1Bias, dist, allParamConstraints, weightConstraints, biasConstraints);
            }
            if (layer.getConstraints() == null || layer.constraints.isEmpty()) {
                LayerConstraint c2;
                ArrayList<LayerConstraint> allConstraints = new ArrayList<LayerConstraint>();
                if (allParamConstraints != null && !layer.initializer().paramKeys(layer).isEmpty()) {
                    for (LayerConstraint c : allConstraints) {
                        c2 = c.clone();
                        c2.setParams(new HashSet<String>(layer.initializer().paramKeys(layer)));
                        allConstraints.add(c2);
                    }
                }
                if (weightConstraints != null && !layer.initializer().weightKeys(layer).isEmpty()) {
                    for (LayerConstraint c : weightConstraints) {
                        c2 = c.clone();
                        c2.setParams(new HashSet<String>(layer.initializer().weightKeys(layer)));
                        allConstraints.add(c2);
                    }
                }
                if (biasConstraints != null && !layer.initializer().biasKeys(layer).isEmpty()) {
                    for (LayerConstraint c : biasConstraints) {
                        c2 = c.clone();
                        c2.setParams(new HashSet<String>(layer.initializer().biasKeys(layer)));
                        allConstraints.add(c2);
                    }
                }
                if (!allConstraints.isEmpty()) {
                    layer.setConstraints(allConstraints);
                } else {
                    layer.setConstraints(null);
                }
            }
        }
    }

    private static void configureBaseLayer(String layerName, BaseLayer bLayer, IDropout iDropout, Double l2, Double l2Bias, Double l1, Double l1Bias, Distribution dist) {
        if (!Double.isNaN(l1) && Double.isNaN(bLayer.getL1())) {
            bLayer.setL1(l1);
        }
        if (!Double.isNaN(l2) && Double.isNaN(bLayer.getL2())) {
            bLayer.setL2(l2);
        }
        if (!Double.isNaN(l1Bias) && Double.isNaN(bLayer.getL1Bias())) {
            bLayer.setL1Bias(l1Bias);
        }
        if (!Double.isNaN(l2Bias) && Double.isNaN(bLayer.getL2Bias())) {
            bLayer.setL2Bias(l2Bias);
        }
        if (Double.isNaN(l2) && Double.isNaN(bLayer.getL2())) {
            bLayer.setL2(0.0);
        }
        if (Double.isNaN(l1) && Double.isNaN(bLayer.getL1())) {
            bLayer.setL1(0.0);
        }
        if (Double.isNaN(l2Bias) && Double.isNaN(bLayer.getL2Bias())) {
            bLayer.setL2Bias(0.0);
        }
        if (Double.isNaN(l1Bias) && Double.isNaN(bLayer.getL1Bias())) {
            bLayer.setL1Bias(0.0);
        }
        if (bLayer.getIDropout() == null) {
            bLayer.setIDropout(iDropout);
        }
        if (bLayer.getWeightInit() == WeightInit.DISTRIBUTION) {
            if (dist != null && bLayer.getDist() == null) {
                bLayer.setDist(dist);
            } else if (dist == null && bLayer.getDist() == null) {
                bLayer.setDist(new NormalDistribution(0.0, 1.0));
                OneTimeLogger.warn((Logger)log, (String)("Layer \"" + layerName + "\" distribution is automatically set to normalize distribution with mean 0 and variance 1."), (Object[])new Object[0]);
            }
        } else if (dist != null || bLayer.getDist() != null) {
            OneTimeLogger.warn((Logger)log, (String)("Layer \"" + layerName + "\" distribution is set but will not be applied unless weight init is set to WeighInit.DISTRIBUTION."), (Object[])new Object[0]);
        }
    }
}

