/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.api;

import java.io.Serializable;
import java.util.Collection;
import org.deeplearning4j.nn.api.MaskState;
import org.deeplearning4j.nn.api.Model;
import org.deeplearning4j.nn.conf.CacheMode;
import org.deeplearning4j.nn.gradient.Gradient;
import org.deeplearning4j.nn.workspace.LayerWorkspaceMgr;
import org.deeplearning4j.optimize.api.TrainingListener;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.primitives.Pair;

public interface Layer
extends Serializable,
Cloneable,
Model {
    public void setCacheMode(CacheMode var1);

    public double calcL2(boolean var1);

    public double calcL1(boolean var1);

    public Type type();

    public Pair<Gradient, INDArray> backpropGradient(INDArray var1, LayerWorkspaceMgr var2);

    public INDArray activate(boolean var1, LayerWorkspaceMgr var2);

    public INDArray activate(INDArray var1, boolean var2, LayerWorkspaceMgr var3);

    @Deprecated
    public Layer transpose();

    @Deprecated
    public Layer clone();

    public Collection<TrainingListener> getListeners();

    @Override
    public void setListeners(TrainingListener ... var1);

    @Override
    public void setListeners(Collection<TrainingListener> var1);

    public void setIndex(int var1);

    public int getIndex();

    public int getIterationCount();

    public int getEpochCount();

    public void setIterationCount(int var1);

    public void setEpochCount(int var1);

    public void setInput(INDArray var1, LayerWorkspaceMgr var2);

    public void setInputMiniBatchSize(int var1);

    public int getInputMiniBatchSize();

    public void setMaskArray(INDArray var1);

    public INDArray getMaskArray();

    public boolean isPretrainLayer();

    public void clearNoiseWeightParams();

    public Pair<INDArray, MaskState> feedForwardMaskArray(INDArray var1, MaskState var2, int var3);

    public static enum TrainingMode {
        TRAIN,
        TEST;

    }

    public static enum Type {
        FEED_FORWARD,
        RECURRENT,
        CONVOLUTIONAL,
        CONVOLUTIONAL3D,
        SUBSAMPLING,
        UPSAMPLING,
        RECURSIVE,
        MULTILAYER,
        NORMALIZATION;

    }
}

