/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.params;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.layers.FeedForwardLayer;
import org.deeplearning4j.nn.conf.layers.Layer;
import org.deeplearning4j.nn.params.DefaultParamInitializer;
import org.deeplearning4j.nn.weights.WeightInit;
import org.deeplearning4j.nn.weights.WeightInitUtil;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.rng.distribution.Distribution;
import org.nd4j.linalg.indexing.INDArrayIndex;
import org.nd4j.linalg.indexing.NDArrayIndex;

public class ElementWiseParamInitializer
extends DefaultParamInitializer {
    private static final ElementWiseParamInitializer INSTANCE = new ElementWiseParamInitializer();

    public static ElementWiseParamInitializer getInstance() {
        return INSTANCE;
    }

    @Override
    public int numParams(Layer layer) {
        FeedForwardLayer layerConf = (FeedForwardLayer)layer;
        int nIn = layerConf.getNIn();
        return nIn * 2;
    }

    @Override
    public Map<String, INDArray> init(NeuralNetConfiguration conf, INDArray paramsView, boolean initializeParams) {
        int nIn;
        if (!(conf.getLayer() instanceof FeedForwardLayer)) {
            throw new IllegalArgumentException("unsupported layer type: " + conf.getLayer().getClass().getName());
        }
        Map<String, INDArray> params = Collections.synchronizedMap(new LinkedHashMap());
        int length = this.numParams(conf);
        if (paramsView.length() != length) {
            throw new IllegalStateException("Expected params view of length " + length + ", got length " + paramsView.length());
        }
        FeedForwardLayer layerConf = (FeedForwardLayer)conf.getLayer();
        int nWeightParams = nIn = layerConf.getNIn();
        INDArray weightView = paramsView.get(new INDArrayIndex[]{NDArrayIndex.point((int)0), NDArrayIndex.interval((int)0, (int)nWeightParams)});
        INDArray biasView = paramsView.get(new INDArrayIndex[]{NDArrayIndex.point((int)0), NDArrayIndex.interval((int)nWeightParams, (int)(nWeightParams + nIn))});
        params.put("W", this.createWeightMatrix(conf, weightView, initializeParams));
        params.put("b", this.createBias(conf, biasView, initializeParams));
        conf.addVariable("W");
        conf.addVariable("b");
        return params;
    }

    @Override
    public Map<String, INDArray> getGradientsFromFlattened(NeuralNetConfiguration conf, INDArray gradientView) {
        FeedForwardLayer layerConf = (FeedForwardLayer)conf.getLayer();
        int nIn = layerConf.getNIn();
        int nOut = layerConf.getNOut();
        int nWeightParams = nIn;
        INDArray weightGradientView = gradientView.get(new INDArrayIndex[]{NDArrayIndex.point((int)0), NDArrayIndex.interval((int)0, (int)nWeightParams)});
        INDArray biasView = gradientView.get(new INDArrayIndex[]{NDArrayIndex.point((int)0), NDArrayIndex.interval((int)nWeightParams, (int)(nWeightParams + nOut))});
        LinkedHashMap<String, INDArray> out = new LinkedHashMap<String, INDArray>();
        out.put("W", weightGradientView);
        out.put("b", biasView);
        return out;
    }

    @Override
    protected INDArray createWeightMatrix(int nIn, int nOut, WeightInit weightInit, Distribution dist, INDArray weightParamView, boolean initializeParameters) {
        int[] shape = new int[]{1, nIn};
        if (initializeParameters) {
            INDArray ret = WeightInitUtil.initWeights(nIn, nOut, shape, weightInit, dist, 'f', weightParamView);
            return ret;
        }
        return weightParamView;
    }
}

