/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.layers.recurrent;

import java.util.Map;
import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.api.MaskState;
import org.deeplearning4j.nn.conf.CacheMode;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.gradient.Gradient;
import org.deeplearning4j.nn.layers.recurrent.BaseRecurrentLayer;
import org.deeplearning4j.nn.layers.recurrent.FwdPassReturn;
import org.deeplearning4j.nn.layers.recurrent.LSTMHelpers;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.primitives.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GravesLSTM
extends BaseRecurrentLayer<org.deeplearning4j.nn.conf.layers.GravesLSTM> {
    private static final Logger log = LoggerFactory.getLogger(GravesLSTM.class);
    public static final String STATE_KEY_PREV_ACTIVATION = "prevAct";
    public static final String STATE_KEY_PREV_MEMCELL = "prevMem";
    protected FwdPassReturn cachedFwdPass;

    public GravesLSTM(NeuralNetConfiguration conf) {
        super(conf);
    }

    public GravesLSTM(NeuralNetConfiguration conf, INDArray input) {
        super(conf, input);
    }

    @Override
    public Gradient gradient() {
        throw new UnsupportedOperationException("gradient() method for layerwise pretraining: not supported for LSTMs (pretraining not possible)" + this.layerId());
    }

    @Override
    public Pair<Gradient, INDArray> backpropGradient(INDArray epsilon) {
        return this.backpropGradientHelper(epsilon, false, -1);
    }

    @Override
    public Pair<Gradient, INDArray> tbpttBackpropGradient(INDArray epsilon, int tbpttBackwardLength) {
        return this.backpropGradientHelper(epsilon, true, tbpttBackwardLength);
    }

    private Pair<Gradient, INDArray> backpropGradientHelper(INDArray epsilon, boolean truncatedBPTT, int tbpttBackwardLength) {
        FwdPassReturn fwdPass;
        INDArray inputWeights = this.getParamWithNoise("W", true);
        INDArray recurrentWeights = this.getParamWithNoise("RW", true);
        if (truncatedBPTT) {
            fwdPass = this.activateHelper(true, (INDArray)this.stateMap.get(STATE_KEY_PREV_ACTIVATION), (INDArray)this.stateMap.get(STATE_KEY_PREV_MEMCELL), true);
            this.tBpttStateMap.put(STATE_KEY_PREV_ACTIVATION, fwdPass.lastAct.leverageTo("LOOP_TBPTT"));
            this.tBpttStateMap.put(STATE_KEY_PREV_MEMCELL, fwdPass.lastMemCell.leverageTo("LOOP_TBPTT"));
        } else {
            fwdPass = this.activateHelper(true, null, null, true);
        }
        Pair<Gradient, INDArray> p = LSTMHelpers.backpropGradientHelper(this.conf, ((org.deeplearning4j.nn.conf.layers.GravesLSTM)this.layerConf()).getGateActivationFn(), this.input, recurrentWeights, inputWeights, epsilon, truncatedBPTT, tbpttBackwardLength, fwdPass, true, "W", "RW", "b", this.gradientViews, this.maskArray, true, null);
        this.weightNoiseParams.clear();
        return p;
    }

    @Override
    public INDArray preOutput(INDArray x) {
        return this.activate(x, true);
    }

    @Override
    public INDArray preOutput(INDArray x, boolean training) {
        return this.activate(x, training);
    }

    @Override
    public INDArray activate(INDArray input, boolean training) {
        this.setInput(input);
        return this.activateHelper((boolean)training, null, null, (boolean)false).fwdPassOutput;
    }

    @Override
    public INDArray activate(INDArray input) {
        this.setInput(input);
        return this.activateHelper((boolean)true, null, null, (boolean)false).fwdPassOutput;
    }

    @Override
    public INDArray activate(boolean training) {
        return this.activateHelper((boolean)training, null, null, (boolean)false).fwdPassOutput;
    }

    @Override
    public INDArray activate() {
        return this.activateHelper((boolean)false, null, null, (boolean)false).fwdPassOutput;
    }

    private FwdPassReturn activateHelper(boolean training, INDArray prevOutputActivations, INDArray prevMemCellState, boolean forBackprop) {
        this.applyDropOutIfNecessary(training);
        if (this.cacheMode == null) {
            this.cacheMode = CacheMode.NONE;
        }
        if (forBackprop && this.cachedFwdPass != null) {
            FwdPassReturn ret = this.cachedFwdPass;
            this.cachedFwdPass = null;
            return ret;
        }
        INDArray recurrentWeights = this.getParamWithNoise("RW", training);
        INDArray inputWeights = this.getParamWithNoise("W", training);
        INDArray biases = this.getParamWithNoise("b", training);
        FwdPassReturn fwd = LSTMHelpers.activateHelper(this, this.conf, ((org.deeplearning4j.nn.conf.layers.GravesLSTM)this.layerConf()).getGateActivationFn(), this.input, recurrentWeights, inputWeights, biases, training, prevOutputActivations, prevMemCellState, forBackprop || this.cacheMode != CacheMode.NONE && training, true, "W", this.maskArray, true, null, forBackprop ? this.cacheMode : CacheMode.NONE);
        if (training && this.cacheMode != CacheMode.NONE) {
            this.cachedFwdPass = fwd;
        }
        return fwd;
    }

    @Override
    public Layer.Type type() {
        return Layer.Type.RECURRENT;
    }

    @Override
    public Layer transpose() {
        throw new UnsupportedOperationException("Not supported " + this.layerId());
    }

    @Override
    public boolean isPretrainLayer() {
        return false;
    }

    @Override
    public Pair<INDArray, MaskState> feedForwardMaskArray(INDArray maskArray, MaskState currentMaskState, int minibatchSize) {
        return new Pair((Object)maskArray, (Object)MaskState.Passthrough);
    }

    @Override
    public double calcL2(boolean backpropParamsOnly) {
        double l2Sum = 0.0;
        for (Map.Entry<String, INDArray> entry : this.paramTable().entrySet()) {
            double l2 = this.conf.getL2ByParam(entry.getKey());
            if (!(l2 > 0.0)) continue;
            double norm2 = this.getParam(entry.getKey()).norm2Number().doubleValue();
            l2Sum += 0.5 * l2 * norm2 * norm2;
        }
        return l2Sum;
    }

    @Override
    public double calcL1(boolean backpropParamsOnly) {
        double l1Sum = 0.0;
        for (Map.Entry<String, INDArray> entry : this.paramTable().entrySet()) {
            double l1 = this.conf.getL1ByParam(entry.getKey());
            if (!(l1 > 0.0)) continue;
            double norm1 = this.getParam(entry.getKey()).norm1Number().doubleValue();
            l1Sum += l1 * norm1;
        }
        return l1Sum;
    }

    @Override
    public INDArray rnnTimeStep(INDArray input) {
        this.setInput(input);
        FwdPassReturn fwdPass = this.activateHelper(false, (INDArray)this.stateMap.get(STATE_KEY_PREV_ACTIVATION), (INDArray)this.stateMap.get(STATE_KEY_PREV_MEMCELL), false);
        INDArray outAct = fwdPass.fwdPassOutput;
        this.stateMap.put(STATE_KEY_PREV_ACTIVATION, fwdPass.lastAct.detach());
        this.stateMap.put(STATE_KEY_PREV_MEMCELL, fwdPass.lastMemCell.detach());
        return outAct;
    }

    @Override
    public INDArray rnnActivateUsingStoredState(INDArray input, boolean training, boolean storeLastForTBPTT) {
        this.setInput(input);
        FwdPassReturn fwdPass = this.activateHelper(training, (INDArray)this.stateMap.get(STATE_KEY_PREV_ACTIVATION), (INDArray)this.stateMap.get(STATE_KEY_PREV_MEMCELL), false);
        INDArray outAct = fwdPass.fwdPassOutput;
        if (storeLastForTBPTT) {
            this.tBpttStateMap.put(STATE_KEY_PREV_ACTIVATION, fwdPass.lastAct.leverageTo("LOOP_TBPTT"));
            this.tBpttStateMap.put(STATE_KEY_PREV_MEMCELL, fwdPass.lastMemCell.leverageTo("LOOP_TBPTT"));
        }
        return outAct;
    }
}

