/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.layers.convolution.upsampling;

import java.util.Arrays;
import org.deeplearning4j.exception.DL4JInvalidInputException;
import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.conf.CacheMode;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.gradient.DefaultGradient;
import org.deeplearning4j.nn.gradient.Gradient;
import org.deeplearning4j.nn.layers.AbstractLayer;
import org.nd4j.linalg.api.memory.MemoryWorkspace;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.CustomOp;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.nd4j.linalg.api.ops.impl.layers.convolution.Upsampling;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.primitives.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Upsampling2D
extends AbstractLayer<org.deeplearning4j.nn.conf.layers.Upsampling2D> {
    private static final Logger log = LoggerFactory.getLogger(Upsampling2D.class);

    public Upsampling2D(NeuralNetConfiguration conf) {
        super(conf);
    }

    public Upsampling2D(NeuralNetConfiguration conf, INDArray input) {
        super(conf, input);
    }

    @Override
    public double calcL2(boolean backpropParamsOnly) {
        return 0.0;
    }

    @Override
    public double calcL1(boolean backpropParamsOnly) {
        return 0.0;
    }

    @Override
    public Layer.Type type() {
        return Layer.Type.SUBSAMPLING;
    }

    @Override
    public Pair<Gradient, INDArray> backpropGradient(INDArray epsilon) {
        int miniBatch = this.input.size(0);
        int inDepth = this.input.size(1);
        int inH = this.input.size(2);
        int inW = this.input.size(3);
        int size = this.getSize();
        INDArray outEpsilon = Nd4j.createUninitialized((int)(miniBatch * inDepth * inH * inW));
        INDArray reshapedEpsilon = outEpsilon.reshape('c', new int[]{miniBatch, inDepth, inH, inW});
        INDArray forwardOutput = this.preOutput(true, true);
        DefaultGradient gradient = new DefaultGradient();
        DynamicCustomOp op = DynamicCustomOp.builder((String)"upsampling_bp").addIntegerArguments(size).addInputs(new INDArray[]{forwardOutput, epsilon}).addOutputs(new INDArray[]{reshapedEpsilon}).callInplace(false).build();
        Nd4j.getExecutioner().exec((CustomOp)op);
        return new Pair((Object)gradient, (Object)reshapedEpsilon);
    }

    protected int getSize() {
        return ((org.deeplearning4j.nn.conf.layers.Upsampling2D)this.layerConf()).getSize();
    }

    @Override
    public INDArray preOutput(boolean training) {
        return this.preOutput(training, false);
    }

    public INDArray preOutput(boolean training, boolean forBackprop) {
        this.applyDropOutIfNecessary(training);
        if (this.input.rank() != 4) {
            throw new DL4JInvalidInputException("Got rank " + this.input.rank() + " array as input to SubsamplingLayer with shape " + Arrays.toString(this.input.shape()) + ". Expected rank 4 array with shape [minibatchSize, depth, inputHeight, inputWidth]. " + this.layerId());
        }
        if (this.preOutput != null && forBackprop) {
            return this.preOutput;
        }
        int miniBatch = this.input.size(0);
        int inDepth = this.input.size(1);
        int inH = this.input.size(2);
        int inW = this.input.size(3);
        int size = this.getSize();
        int outH = inH * size;
        int outW = inW * size;
        INDArray output = Nd4j.createUninitialized((int)(miniBatch * inDepth * outH * outW));
        INDArray reshapedOutput = output.reshape('c', new int[]{miniBatch, inDepth, outH, outW});
        Upsampling upsampling = Upsampling.sameDiffBuilder().inPlace(false).inputArrays(new INDArray[]{this.input}).outputs(new INDArray[]{reshapedOutput}).scaleFactor(size).build();
        Nd4j.getExecutioner().exec((CustomOp)upsampling);
        return reshapedOutput;
    }

    @Override
    public INDArray activate(boolean training) {
        this.applyDropOutIfNecessary(training);
        if (this.cacheMode == null) {
            this.cacheMode = CacheMode.NONE;
        }
        INDArray z = this.preOutput(training);
        if (training && this.cacheMode != CacheMode.NONE && Nd4j.getWorkspaceManager().checkIfWorkspaceExistsAndActive("LOOP_CACHE")) {
            try (MemoryWorkspace wsB = Nd4j.getWorkspaceManager().getWorkspaceForCurrentThread("LOOP_CACHE").notifyScopeBorrowed();){
                this.preOutput = z.unsafeDuplication();
            }
        }
        return z;
    }

    @Override
    public Layer transpose() {
        throw new UnsupportedOperationException(this.layerId());
    }

    @Override
    public Layer clone() {
        return new Upsampling2D(this.conf.clone());
    }

    @Override
    public boolean isPretrainLayer() {
        return false;
    }

    @Override
    public void clearNoiseWeightParams() {
    }

    @Override
    public void iterate(INDArray input) {
        throw new UnsupportedOperationException(this.layerId());
    }

    @Override
    public Gradient gradient() {
        throw new UnsupportedOperationException("Not supported - no parameters");
    }

    @Override
    public void fit() {
    }

    @Override
    public int numParams() {
        return 0;
    }

    @Override
    public void fit(INDArray input) {
    }

    @Override
    public void computeGradientAndScore() {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public double score() {
        return 0.0;
    }

    @Override
    public void accumulateScore(double accum) {
        throw new UnsupportedOperationException(this.layerId());
    }

    @Override
    public void update(INDArray gradient, String paramType) {
    }

    @Override
    public INDArray params() {
        return null;
    }

    @Override
    public INDArray getParam(String param) {
        return this.params();
    }

    @Override
    public void setParams(INDArray params) {
    }
}

