/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.preprocessor;

import java.util.Arrays;
import org.deeplearning4j.nn.api.MaskState;
import org.deeplearning4j.nn.conf.InputPreProcessor;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.shape.Shape;
import org.nd4j.linalg.primitives.Pair;
import org.nd4j.linalg.util.ArrayUtil;
import org.nd4j.shade.jackson.annotation.JsonCreator;
import org.nd4j.shade.jackson.annotation.JsonProperty;

public class FeedForwardToCnnPreProcessor
implements InputPreProcessor {
    private int inputHeight;
    private int inputWidth;
    private int numChannels;
    private int[] shape;

    @JsonCreator
    public FeedForwardToCnnPreProcessor(@JsonProperty(value="inputHeight") int inputHeight, @JsonProperty(value="inputWidth") int inputWidth, @JsonProperty(value="numChannels") int numChannels) {
        this.inputHeight = inputHeight;
        this.inputWidth = inputWidth;
        this.numChannels = numChannels;
    }

    public FeedForwardToCnnPreProcessor(int inputWidth, int inputHeight) {
        this.inputHeight = inputHeight;
        this.inputWidth = inputWidth;
        this.numChannels = 1;
    }

    @Override
    public INDArray preProcess(INDArray input, int miniBatchSize) {
        if (input.ordering() != 'c' || !Shape.strideDescendingCAscendingF((INDArray)input)) {
            input = input.dup('c');
        }
        this.shape = input.shape();
        if (input.shape().length == 4) {
            return input;
        }
        if (input.columns() != this.inputWidth * this.inputHeight * this.numChannels) {
            throw new IllegalArgumentException("Invalid input: expect output columns must be equal to rows " + this.inputHeight + " x columns " + this.inputWidth + " x channels " + this.numChannels + " but was instead " + Arrays.toString(input.shape()));
        }
        return input.reshape('c', new int[]{input.size(0), this.numChannels, this.inputHeight, this.inputWidth});
    }

    @Override
    public INDArray backprop(INDArray epsilons, int miniBatchSize) {
        if (epsilons.ordering() != 'c' || !Shape.strideDescendingCAscendingF((INDArray)epsilons)) {
            epsilons = epsilons.dup('c');
        }
        if (this.shape == null || ArrayUtil.prod((int[])this.shape) != epsilons.length()) {
            if (epsilons.rank() == 2) {
                return epsilons;
            }
            return epsilons.reshape('c', new int[]{epsilons.size(0), this.numChannels, this.inputHeight, this.inputWidth});
        }
        return epsilons.reshape('c', this.shape);
    }

    @Override
    public FeedForwardToCnnPreProcessor clone() {
        try {
            FeedForwardToCnnPreProcessor clone = (FeedForwardToCnnPreProcessor)super.clone();
            if (clone.shape != null) {
                clone.shape = (int[])clone.shape.clone();
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public InputType getOutputType(InputType inputType) {
        switch (inputType.getType()) {
            case FF: {
                InputType.InputTypeFeedForward c = (InputType.InputTypeFeedForward)inputType;
                int expSize = this.inputHeight * this.inputWidth * this.numChannels;
                if (c.getSize() != expSize) {
                    throw new IllegalStateException("Invalid input: expected FeedForward input of size " + expSize + " = (d=" + this.numChannels + " * w=" + this.inputWidth + " * h=" + this.inputHeight + "), got " + inputType);
                }
                return InputType.convolutional(this.inputHeight, this.inputWidth, this.numChannels);
            }
            case CNN: {
                InputType.InputTypeConvolutional c2 = (InputType.InputTypeConvolutional)inputType;
                if (c2.getDepth() != this.numChannels || c2.getHeight() != this.inputHeight || c2.getWidth() != this.inputWidth) {
                    throw new IllegalStateException("Invalid input: Got CNN input type with (d,w,h)=(" + c2.getDepth() + "," + c2.getWidth() + "," + c2.getHeight() + ") but expected (" + this.numChannels + "," + this.inputHeight + "," + this.inputWidth + ")");
                }
                return c2;
            }
            case CNNFlat: {
                InputType.InputTypeConvolutionalFlat c3 = (InputType.InputTypeConvolutionalFlat)inputType;
                if (c3.getDepth() != this.numChannels || c3.getHeight() != this.inputHeight || c3.getWidth() != this.inputWidth) {
                    throw new IllegalStateException("Invalid input: Got CNN input type with (d,w,h)=(" + c3.getDepth() + "," + c3.getWidth() + "," + c3.getHeight() + ") but expected (" + this.numChannels + "," + this.inputHeight + "," + this.inputWidth + ")");
                }
                return c3.getUnflattenedType();
            }
        }
        throw new IllegalStateException("Invalid input type: got " + inputType);
    }

    @Override
    public Pair<INDArray, MaskState> feedForwardMaskArray(INDArray maskArray, MaskState currentMaskState, int minibatchSize) {
        return new Pair((Object)maskArray, (Object)currentMaskState);
    }

    public int getInputHeight() {
        return this.inputHeight;
    }

    public int getInputWidth() {
        return this.inputWidth;
    }

    public int getNumChannels() {
        return this.numChannels;
    }

    public void setInputHeight(int inputHeight) {
        this.inputHeight = inputHeight;
    }

    public void setInputWidth(int inputWidth) {
        this.inputWidth = inputWidth;
    }

    public void setNumChannels(int numChannels) {
        this.numChannels = numChannels;
    }

    public String toString() {
        return "FeedForwardToCnnPreProcessor(inputHeight=" + this.getInputHeight() + ", inputWidth=" + this.getInputWidth() + ", numChannels=" + this.getNumChannels() + ", shape=" + Arrays.toString(this.shape) + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FeedForwardToCnnPreProcessor)) {
            return false;
        }
        FeedForwardToCnnPreProcessor other = (FeedForwardToCnnPreProcessor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getInputHeight() != other.getInputHeight()) {
            return false;
        }
        if (this.getInputWidth() != other.getInputWidth()) {
            return false;
        }
        return this.getNumChannels() == other.getNumChannels();
    }

    protected boolean canEqual(Object other) {
        return other instanceof FeedForwardToCnnPreProcessor;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getInputHeight();
        result = result * 59 + this.getInputWidth();
        result = result * 59 + this.getNumChannels();
        return result;
    }
}

