/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.memory;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import lombok.NonNull;
import org.deeplearning4j.nn.conf.CacheMode;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.memory.MemoryType;
import org.deeplearning4j.nn.conf.memory.MemoryUseMode;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.buffer.util.DataTypeUtil;
import org.nd4j.shade.jackson.annotation.JsonTypeInfo;
import org.nd4j.shade.jackson.core.JsonProcessingException;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.PROPERTY)
public abstract class MemoryReport {
    public static final Map<CacheMode, Long> CACHE_MODE_ALL_ZEROS = MemoryReport.getAllZerosMap();

    private static Map<CacheMode, Long> getAllZerosMap() {
        HashMap<CacheMode, Long> map = new HashMap<CacheMode, Long>();
        for (CacheMode c : CacheMode.values()) {
            map.put(c, 0L);
        }
        return Collections.unmodifiableMap(map);
    }

    public abstract Class<?> getReportClass();

    public abstract String getName();

    public long getTotalMemoryBytes(int minibatchSize, @NonNull MemoryUseMode memoryUseMode, @NonNull CacheMode cacheMode) {
        if (memoryUseMode == null) {
            throw new NullPointerException("memoryUseMode");
        }
        if (cacheMode == null) {
            throw new NullPointerException("cacheMode");
        }
        return this.getTotalMemoryBytes(minibatchSize, memoryUseMode, cacheMode, DataTypeUtil.getDtypeFromContext());
    }

    public abstract long getTotalMemoryBytes(int var1, @NonNull MemoryUseMode var2, @NonNull CacheMode var3, @NonNull DataBuffer.Type var4);

    public long getMemoryBytes(MemoryType memoryType, int minibatchSize, MemoryUseMode memoryUseMode, CacheMode cacheMode) {
        return this.getMemoryBytes(memoryType, minibatchSize, memoryUseMode, cacheMode, DataTypeUtil.getDtypeFromContext());
    }

    public abstract long getMemoryBytes(MemoryType var1, int var2, MemoryUseMode var3, CacheMode var4, DataBuffer.Type var5);

    public abstract String toString();

    protected int getBytesPerElement(DataBuffer.Type dataType) {
        switch (dataType) {
            case DOUBLE: {
                return 8;
            }
            case FLOAT: {
                return 4;
            }
            case HALF: {
                return 2;
            }
        }
        throw new UnsupportedOperationException("Data type not supported: " + dataType);
    }

    public static Map<CacheMode, Long> cacheModeMapFor(long value) {
        if (value == 0L) {
            return CACHE_MODE_ALL_ZEROS;
        }
        HashMap<CacheMode, Long> m = new HashMap<CacheMode, Long>();
        for (CacheMode cm : CacheMode.values()) {
            m.put(cm, value);
        }
        return m;
    }

    public String toJson() {
        try {
            return NeuralNetConfiguration.mapper().writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public String toYaml() {
        try {
            return NeuralNetConfiguration.mapperYaml().writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static MemoryReport fromJson(String json) {
        try {
            return (MemoryReport)NeuralNetConfiguration.mapper().readValue(json, MemoryReport.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static MemoryReport fromYaml(String yaml) {
        try {
            return (MemoryReport)NeuralNetConfiguration.mapperYaml().readValue(yaml, MemoryReport.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MemoryReport)) {
            return false;
        }
        MemoryReport other = (MemoryReport)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof MemoryReport;
    }

    public int hashCode() {
        int result = 1;
        return result;
    }
}

