/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.layers;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.deeplearning4j.nn.api.ParamInitializer;
import org.deeplearning4j.nn.conf.ConvolutionMode;
import org.deeplearning4j.nn.conf.InputPreProcessor;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.layers.InputTypeUtil;
import org.deeplearning4j.nn.conf.layers.Layer;
import org.deeplearning4j.nn.conf.memory.LayerMemoryReport;
import org.deeplearning4j.nn.conf.memory.MemoryReport;
import org.deeplearning4j.nn.params.EmptyParamInitializer;
import org.deeplearning4j.optimize.api.IterationListener;
import org.deeplearning4j.util.ConvolutionUtils;
import org.nd4j.linalg.api.ndarray.INDArray;

public class SubsamplingLayer
extends Layer {
    protected ConvolutionMode convolutionMode = ConvolutionMode.Truncate;
    protected org.deeplearning4j.nn.conf.layers.PoolingType poolingType;
    protected int[] kernelSize;
    protected int[] stride;
    protected int[] padding;
    protected int[] dilation = new int[]{1, 1};
    protected int pnorm;
    protected double eps;
    protected boolean cudnnAllowFallback = true;

    protected SubsamplingLayer(BaseSubsamplingBuilder builder) {
        super(builder);
        this.poolingType = builder.poolingType;
        if (builder.kernelSize.length != 2) {
            throw new IllegalArgumentException("Kernel size of should be rows x columns (a 2d array)");
        }
        this.kernelSize = builder.kernelSize;
        if (builder.stride.length != 2) {
            throw new IllegalArgumentException("Invalid stride, must be length 2");
        }
        this.stride = builder.stride;
        this.padding = builder.padding;
        this.convolutionMode = builder.convolutionMode;
        if (builder instanceof Builder) {
            this.dilation = ((Builder)builder).dilation;
        }
        this.pnorm = builder.pnorm;
        this.eps = builder.eps;
        this.cudnnAllowFallback = builder.cudnnAllowFallback;
    }

    @Override
    public SubsamplingLayer clone() {
        SubsamplingLayer clone = (SubsamplingLayer)super.clone();
        if (clone.kernelSize != null) {
            clone.kernelSize = (int[])clone.kernelSize.clone();
        }
        if (clone.stride != null) {
            clone.stride = (int[])clone.stride.clone();
        }
        if (clone.padding != null) {
            clone.padding = (int[])clone.padding.clone();
        }
        return clone;
    }

    @Override
    public org.deeplearning4j.nn.api.Layer instantiate(NeuralNetConfiguration conf, Collection<IterationListener> iterationListeners, int layerIndex, INDArray layerParamsView, boolean initializeParams) {
        org.deeplearning4j.nn.layers.convolution.subsampling.SubsamplingLayer ret = new org.deeplearning4j.nn.layers.convolution.subsampling.SubsamplingLayer(conf);
        ret.setListeners(iterationListeners);
        ret.setIndex(layerIndex);
        ret.setParamsViewArray(layerParamsView);
        Map<String, INDArray> paramTable = this.initializer().init(conf, layerParamsView, initializeParams);
        ret.setParamTable(paramTable);
        ret.setConf(conf);
        return ret;
    }

    @Override
    public ParamInitializer initializer() {
        return EmptyParamInitializer.getInstance();
    }

    @Override
    public InputType getOutputType(int layerIndex, InputType inputType) {
        if (inputType == null || inputType.getType() != InputType.Type.CNN) {
            throw new IllegalStateException("Invalid input for Subsampling layer (layer name=\"" + this.getLayerName() + "\"): Expected CNN input, got " + inputType);
        }
        return InputTypeUtil.getOutputTypeCnnLayers(inputType, this.kernelSize, this.stride, this.padding, this.dilation, this.convolutionMode, ((InputType.InputTypeConvolutional)inputType).getDepth(), layerIndex, this.getLayerName(), SubsamplingLayer.class);
    }

    @Override
    public void setNIn(InputType inputType, boolean override) {
    }

    @Override
    public InputPreProcessor getPreProcessorForInputType(InputType inputType) {
        if (inputType == null) {
            throw new IllegalStateException("Invalid input for Subsampling layer (layer name=\"" + this.getLayerName() + "\"): input is null");
        }
        return InputTypeUtil.getPreProcessorForInputTypeCnnLayers(inputType, this.getLayerName());
    }

    @Override
    public double getL1ByParam(String paramName) {
        return 0.0;
    }

    @Override
    public double getL2ByParam(String paramName) {
        return 0.0;
    }

    @Override
    public boolean isPretrainParam(String paramName) {
        throw new UnsupportedOperationException("SubsamplingLayer does not contain parameters");
    }

    @Override
    public LayerMemoryReport getMemoryReport(InputType inputType) {
        int im2colSizePerEx;
        InputType.InputTypeConvolutional c = (InputType.InputTypeConvolutional)inputType;
        InputType.InputTypeConvolutional outputType = (InputType.InputTypeConvolutional)this.getOutputType(-1, inputType);
        int actElementsPerEx = outputType.arrayElementsPerExample();
        int trainingWorkingSizePerEx = im2colSizePerEx = c.getDepth() * outputType.getHeight() * outputType.getWidth() * this.kernelSize[0] * this.kernelSize[1];
        if (this.getIDropout() != null) {
            trainingWorkingSizePerEx += inputType.arrayElementsPerExample();
        }
        return new LayerMemoryReport.Builder(this.layerName, SubsamplingLayer.class, inputType, outputType).standardMemory(0L, 0L).workingMemory(0L, (long)im2colSizePerEx, 0L, trainingWorkingSizePerEx).cacheMemory(MemoryReport.CACHE_MODE_ALL_ZEROS, MemoryReport.CACHE_MODE_ALL_ZEROS).build();
    }

    public int getPnorm() {
        return this.pnorm;
    }

    public double getEps() {
        return this.eps;
    }

    public ConvolutionMode getConvolutionMode() {
        return this.convolutionMode;
    }

    public org.deeplearning4j.nn.conf.layers.PoolingType getPoolingType() {
        return this.poolingType;
    }

    public int[] getKernelSize() {
        return this.kernelSize;
    }

    public int[] getStride() {
        return this.stride;
    }

    public int[] getPadding() {
        return this.padding;
    }

    public int[] getDilation() {
        return this.dilation;
    }

    public boolean isCudnnAllowFallback() {
        return this.cudnnAllowFallback;
    }

    public void setConvolutionMode(ConvolutionMode convolutionMode) {
        this.convolutionMode = convolutionMode;
    }

    public void setPoolingType(org.deeplearning4j.nn.conf.layers.PoolingType poolingType) {
        this.poolingType = poolingType;
    }

    public void setKernelSize(int[] kernelSize) {
        this.kernelSize = kernelSize;
    }

    public void setStride(int[] stride) {
        this.stride = stride;
    }

    public void setPadding(int[] padding) {
        this.padding = padding;
    }

    public void setDilation(int[] dilation) {
        this.dilation = dilation;
    }

    public void setPnorm(int pnorm) {
        this.pnorm = pnorm;
    }

    public void setEps(double eps) {
        this.eps = eps;
    }

    public void setCudnnAllowFallback(boolean cudnnAllowFallback) {
        this.cudnnAllowFallback = cudnnAllowFallback;
    }

    public SubsamplingLayer() {
    }

    @Override
    public String toString() {
        return "SubsamplingLayer(super=" + super.toString() + ", convolutionMode=" + (Object)((Object)this.getConvolutionMode()) + ", poolingType=" + (Object)((Object)this.getPoolingType()) + ", kernelSize=" + Arrays.toString(this.getKernelSize()) + ", stride=" + Arrays.toString(this.getStride()) + ", padding=" + Arrays.toString(this.getPadding()) + ", dilation=" + Arrays.toString(this.getDilation()) + ", pnorm=" + this.getPnorm() + ", eps=" + this.getEps() + ", cudnnAllowFallback=" + this.isCudnnAllowFallback() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SubsamplingLayer)) {
            return false;
        }
        SubsamplingLayer other = (SubsamplingLayer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ConvolutionMode this$convolutionMode = this.getConvolutionMode();
        ConvolutionMode other$convolutionMode = other.getConvolutionMode();
        if (this$convolutionMode == null ? other$convolutionMode != null : !((Object)((Object)this$convolutionMode)).equals((Object)other$convolutionMode)) {
            return false;
        }
        org.deeplearning4j.nn.conf.layers.PoolingType this$poolingType = this.getPoolingType();
        org.deeplearning4j.nn.conf.layers.PoolingType other$poolingType = other.getPoolingType();
        if (this$poolingType == null ? other$poolingType != null : !((Object)((Object)this$poolingType)).equals((Object)other$poolingType)) {
            return false;
        }
        if (!Arrays.equals(this.getKernelSize(), other.getKernelSize())) {
            return false;
        }
        if (!Arrays.equals(this.getStride(), other.getStride())) {
            return false;
        }
        if (!Arrays.equals(this.getPadding(), other.getPadding())) {
            return false;
        }
        if (!Arrays.equals(this.getDilation(), other.getDilation())) {
            return false;
        }
        if (this.getPnorm() != other.getPnorm()) {
            return false;
        }
        if (Double.compare(this.getEps(), other.getEps()) != 0) {
            return false;
        }
        return this.isCudnnAllowFallback() == other.isCudnnAllowFallback();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof SubsamplingLayer;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        ConvolutionMode $convolutionMode = this.getConvolutionMode();
        result = result * 59 + ($convolutionMode == null ? 43 : ((Object)((Object)$convolutionMode)).hashCode());
        org.deeplearning4j.nn.conf.layers.PoolingType $poolingType = this.getPoolingType();
        result = result * 59 + ($poolingType == null ? 43 : ((Object)((Object)$poolingType)).hashCode());
        result = result * 59 + Arrays.hashCode(this.getKernelSize());
        result = result * 59 + Arrays.hashCode(this.getStride());
        result = result * 59 + Arrays.hashCode(this.getPadding());
        result = result * 59 + Arrays.hashCode(this.getDilation());
        result = result * 59 + this.getPnorm();
        long $eps = Double.doubleToLongBits(this.getEps());
        result = result * 59 + (int)($eps >>> 32 ^ $eps);
        result = result * 59 + (this.isCudnnAllowFallback() ? 79 : 97);
        return result;
    }

    protected static abstract class BaseSubsamplingBuilder<T extends BaseSubsamplingBuilder<T>>
    extends Layer.Builder<T> {
        protected org.deeplearning4j.nn.conf.layers.PoolingType poolingType = org.deeplearning4j.nn.conf.layers.PoolingType.MAX;
        protected int[] kernelSize = new int[]{1, 1};
        protected int[] stride = new int[]{2, 2};
        protected int[] padding = new int[]{0, 0};
        protected ConvolutionMode convolutionMode = null;
        protected int pnorm;
        protected double eps = 1.0E-8;
        protected boolean cudnnAllowFallback = true;

        protected BaseSubsamplingBuilder(PoolingType poolingType, int[] kernelSize, int[] stride) {
            this.poolingType = poolingType.toPoolingType();
            this.kernelSize = kernelSize;
            this.stride = stride;
        }

        protected BaseSubsamplingBuilder(PoolingType poolingType, int[] kernelSize) {
            this.poolingType = poolingType.toPoolingType();
            this.kernelSize = kernelSize;
        }

        protected BaseSubsamplingBuilder(PoolingType poolingType, int[] kernelSize, int[] stride, int[] padding) {
            this.poolingType = poolingType.toPoolingType();
            this.kernelSize = kernelSize;
            this.stride = stride;
            this.padding = padding;
        }

        protected BaseSubsamplingBuilder(org.deeplearning4j.nn.conf.layers.PoolingType poolingType, int[] kernelSize) {
            this.poolingType = poolingType;
            this.kernelSize = kernelSize;
        }

        protected BaseSubsamplingBuilder(org.deeplearning4j.nn.conf.layers.PoolingType poolingType, int[] kernelSize, int[] stride, int[] padding) {
            this.poolingType = poolingType;
            this.kernelSize = kernelSize;
            this.stride = stride;
            this.padding = padding;
        }

        protected BaseSubsamplingBuilder(int[] kernelSize, int[] stride, int[] padding) {
            this.kernelSize = kernelSize;
            this.stride = stride;
            this.padding = padding;
        }

        protected BaseSubsamplingBuilder(int[] kernelSize, int[] stride) {
            this.kernelSize = kernelSize;
            this.stride = stride;
        }

        protected BaseSubsamplingBuilder(int ... kernelSize) {
            this.kernelSize = kernelSize;
        }

        protected BaseSubsamplingBuilder(PoolingType poolingType) {
            this.poolingType = poolingType.toPoolingType();
        }

        protected BaseSubsamplingBuilder(org.deeplearning4j.nn.conf.layers.PoolingType poolingType) {
            this.poolingType = poolingType;
        }

        public T convolutionMode(ConvolutionMode convolutionMode) {
            this.convolutionMode = convolutionMode;
            return (T)this;
        }

        public T poolingType(PoolingType poolingType) {
            this.poolingType = poolingType.toPoolingType();
            return (T)this;
        }

        public T pnorm(int pnorm) {
            if (pnorm <= 0) {
                throw new IllegalArgumentException("Invalid input: p-norm value must be greater than 0");
            }
            this.pnorm = pnorm;
            return (T)this;
        }

        public T eps(double eps) {
            if (eps <= 0.0) {
                throw new IllegalArgumentException("Invalid input: epsilon for p-norm must be greater than 0");
            }
            this.eps = eps;
            return (T)this;
        }

        public T cudnnAllowFallback(boolean allowFallback) {
            this.cudnnAllowFallback = allowFallback;
            return (T)this;
        }

        public BaseSubsamplingBuilder() {
        }
    }

    public static class Builder
    extends BaseSubsamplingBuilder<Builder> {
        private int[] dilation = new int[]{1, 1};

        public Builder(PoolingType poolingType, int[] kernelSize, int[] stride) {
            super(poolingType, kernelSize, stride);
        }

        public Builder(PoolingType poolingType, int[] kernelSize) {
            super(poolingType, kernelSize);
        }

        public Builder(PoolingType poolingType, int[] kernelSize, int[] stride, int[] padding) {
            super(poolingType, kernelSize, stride, padding);
        }

        public Builder(org.deeplearning4j.nn.conf.layers.PoolingType poolingType, int[] kernelSize) {
            super(poolingType, kernelSize);
        }

        public Builder(org.deeplearning4j.nn.conf.layers.PoolingType poolingType, int[] kernelSize, int[] stride, int[] padding) {
            super(poolingType, kernelSize, stride, padding);
        }

        public Builder(int[] kernelSize, int[] stride, int[] padding) {
            super(kernelSize, stride, padding);
        }

        public Builder(int[] kernelSize, int[] stride) {
            super(kernelSize, stride);
        }

        public Builder(int ... kernelSize) {
            super(kernelSize);
        }

        public Builder(PoolingType poolingType) {
            super(poolingType);
        }

        public Builder(org.deeplearning4j.nn.conf.layers.PoolingType poolingType) {
            super(poolingType);
        }

        public Builder kernelSize(int ... kernelSize) {
            if (kernelSize.length != 2) {
                throw new IllegalArgumentException("Invalid input: must be length 2");
            }
            this.kernelSize = kernelSize;
            return this;
        }

        public Builder stride(int ... stride) {
            if (stride.length != 2) {
                throw new IllegalArgumentException("Invalid input: must be length 2");
            }
            this.stride = stride;
            return this;
        }

        public Builder padding(int ... padding) {
            if (padding.length != 2) {
                throw new IllegalArgumentException("Invalid input: must be length 2");
            }
            this.padding = padding;
            return this;
        }

        public Builder dilation(int ... dilation) {
            this.dilation = dilation;
            return this;
        }

        @Override
        public SubsamplingLayer build() {
            if (this.poolingType == org.deeplearning4j.nn.conf.layers.PoolingType.PNORM && this.pnorm <= 0) {
                throw new IllegalStateException("Incorrect Subsampling config: p-norm must be set when using PoolingType.PNORM");
            }
            ConvolutionUtils.validateConvolutionModePadding(this.convolutionMode, this.padding);
            ConvolutionUtils.validateCnnKernelStridePadding(this.kernelSize, this.stride, this.padding);
            return new SubsamplingLayer(this);
        }

        public Builder() {
        }
    }

    public static enum PoolingType {
        MAX,
        AVG,
        SUM,
        PNORM;


        public org.deeplearning4j.nn.conf.layers.PoolingType toPoolingType() {
            switch (this) {
                case MAX: {
                    return org.deeplearning4j.nn.conf.layers.PoolingType.MAX;
                }
                case AVG: {
                    return org.deeplearning4j.nn.conf.layers.PoolingType.AVG;
                }
                case SUM: {
                    return org.deeplearning4j.nn.conf.layers.PoolingType.SUM;
                }
                case PNORM: {
                    return org.deeplearning4j.nn.conf.layers.PoolingType.PNORM;
                }
            }
            throw new UnsupportedOperationException("Unknown/not supported pooling type: " + (Object)((Object)this));
        }
    }
}

