/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.layers.convolution.subsampling;

import java.util.Arrays;
import org.deeplearning4j.exception.DL4JInvalidInputException;
import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.conf.ConvolutionMode;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.layers.Convolution3D;
import org.deeplearning4j.nn.conf.layers.PoolingType;
import org.deeplearning4j.nn.gradient.DefaultGradient;
import org.deeplearning4j.nn.gradient.Gradient;
import org.deeplearning4j.nn.layers.AbstractLayer;
import org.deeplearning4j.nn.workspace.ArrayType;
import org.deeplearning4j.nn.workspace.LayerWorkspaceMgr;
import org.deeplearning4j.util.Convolution3DUtils;
import org.nd4j.common.primitives.Pair;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.CustomOp;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.nd4j.linalg.factory.Nd4j;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Subsampling3DLayer
extends AbstractLayer<org.deeplearning4j.nn.conf.layers.Subsampling3DLayer> {
    private static final Logger log = LoggerFactory.getLogger(Subsampling3DLayer.class);
    protected ConvolutionMode convolutionMode;

    public Subsampling3DLayer(NeuralNetConfiguration conf, DataType dataType) {
        super(conf, dataType);
        this.convolutionMode = ((org.deeplearning4j.nn.conf.layers.Subsampling3DLayer)conf.getLayer()).getConvolutionMode();
    }

    @Override
    public double calcRegularizationScore(boolean backpropParamsOnly) {
        return 0.0;
    }

    @Override
    public Layer.Type type() {
        return Layer.Type.SUBSAMPLING;
    }

    @Override
    public Pair<Gradient, INDArray> backpropGradient(INDArray epsilon, LayerWorkspaceMgr workspaceMgr) {
        long[] lArray;
        int[] pad;
        this.assertInputSet(true);
        boolean isNCDHW = ((org.deeplearning4j.nn.conf.layers.Subsampling3DLayer)this.layerConf()).getDataFormat() == Convolution3D.DataFormat.NCDHW;
        long miniBatch = this.input.size(0);
        long inChannels = isNCDHW ? this.input.size(1) : this.input.size(4);
        int inD = (int)(isNCDHW ? this.input.size(2) : this.input.size(1));
        int inH = (int)(isNCDHW ? this.input.size(3) : this.input.size(2));
        int inW = (int)(isNCDHW ? this.input.size(4) : this.input.size(3));
        int[] kernel = ((org.deeplearning4j.nn.conf.layers.Subsampling3DLayer)this.layerConf()).getKernelSize();
        int[] strides = ((org.deeplearning4j.nn.conf.layers.Subsampling3DLayer)this.layerConf()).getStride();
        int[] dilation = ((org.deeplearning4j.nn.conf.layers.Subsampling3DLayer)this.layerConf()).getDilation();
        if (this.convolutionMode == ConvolutionMode.Same) {
            int[] outSize = Convolution3DUtils.get3DOutputSize(this.input, kernel, strides, null, this.convolutionMode, dilation, isNCDHW);
            pad = Convolution3DUtils.get3DSameModeTopLeftPadding(outSize, new int[]{inD, inH, inW}, kernel, strides, dilation);
        } else {
            pad = ((org.deeplearning4j.nn.conf.layers.Subsampling3DLayer)this.layerConf()).getPadding();
        }
        DataType dataType = epsilon.dataType();
        if (isNCDHW) {
            long[] lArray2 = new long[5];
            lArray2[0] = miniBatch;
            lArray2[1] = inChannels;
            lArray2[2] = inD;
            lArray2[3] = inH;
            lArray = lArray2;
            lArray2[4] = inW;
        } else {
            long[] lArray3 = new long[5];
            lArray3[0] = miniBatch;
            lArray3[1] = inD;
            lArray3[2] = inH;
            lArray3[3] = inW;
            lArray = lArray3;
            lArray3[4] = inChannels;
        }
        INDArray outEpsilon = workspaceMgr.createUninitialized(ArrayType.ACTIVATION_GRAD, dataType, lArray, 'c');
        int[] intArgs = new int[]{kernel[0], kernel[1], kernel[2], strides[0], strides[1], strides[2], pad[0], pad[1], pad[2], dilation[0], dilation[1], dilation[2], this.convolutionMode == ConvolutionMode.Same ? 1 : 0, 0, isNCDHW ? 0 : 1};
        String opName = ((org.deeplearning4j.nn.conf.layers.Subsampling3DLayer)this.layerConf()).getPoolingType() == PoolingType.MAX ? "maxpool3dnew_bp" : "avgpool3dnew_bp";
        DynamicCustomOp op = DynamicCustomOp.builder((String)opName).addInputs(new INDArray[]{this.input, epsilon}).addIntegerArguments(intArgs).addOutputs(new INDArray[]{outEpsilon}).callInplace(false).build();
        Nd4j.getExecutioner().exec((CustomOp)op);
        DefaultGradient retGradient = new DefaultGradient();
        outEpsilon = this.backpropDropOutIfPresent(outEpsilon);
        return new Pair((Object)retGradient, (Object)outEpsilon);
    }

    @Override
    public INDArray activate(boolean training, LayerWorkspaceMgr workspaceMgr) {
        long[] lArray;
        int[] pad;
        int[] outSize;
        boolean isNCDHW;
        this.assertInputSet(false);
        if (training && !this.dropoutApplied && ((org.deeplearning4j.nn.conf.layers.Subsampling3DLayer)this.layerConf()).getIDropout() != null) {
            this.applyDropOutIfNecessary(true, workspaceMgr);
        }
        boolean bl = isNCDHW = ((org.deeplearning4j.nn.conf.layers.Subsampling3DLayer)this.layerConf()).getDataFormat() == Convolution3D.DataFormat.NCDHW;
        if (this.input.rank() != 5) {
            if (isNCDHW) {
                throw new DL4JInvalidInputException("Got rank " + this.input.rank() + " array as input to Subsampling3DLayer with shape " + Arrays.toString(this.input.shape()) + ". Expected rank 5 array with shape [minibatchSize, channels, inputDepth, inputHeight, inputWidth] when dataFormat=NCDHW. " + this.layerId());
            }
            throw new DL4JInvalidInputException("Got rank " + this.input.rank() + " array as input to Subsampling3DLayer with shape " + Arrays.toString(this.input.shape()) + ". Expected rank 5 array with shape [minibatchSize, inputDepth, inputHeight, inputWidth, channels] when dataFormat=NDHWC. " + this.layerId());
        }
        long miniBatch = this.input.size(0);
        long inChannels = isNCDHW ? this.input.size(1) : this.input.size(4);
        int inD = (int)(isNCDHW ? this.input.size(2) : this.input.size(1));
        int inH = (int)(isNCDHW ? this.input.size(3) : this.input.size(2));
        int inW = (int)(isNCDHW ? this.input.size(4) : this.input.size(3));
        int[] kernel = ((org.deeplearning4j.nn.conf.layers.Subsampling3DLayer)this.layerConf()).getKernelSize();
        int[] strides = ((org.deeplearning4j.nn.conf.layers.Subsampling3DLayer)this.layerConf()).getStride();
        int[] dilation = ((org.deeplearning4j.nn.conf.layers.Subsampling3DLayer)this.layerConf()).getDilation();
        if (this.convolutionMode == ConvolutionMode.Same) {
            int[] inShape = new int[]{inD, inH, inW};
            outSize = Convolution3DUtils.get3DOutputSize(this.input, kernel, strides, null, this.convolutionMode, dilation, isNCDHW);
            pad = Convolution3DUtils.get3DSameModeTopLeftPadding(outSize, inShape, kernel, strides, dilation);
        } else {
            pad = ((org.deeplearning4j.nn.conf.layers.Subsampling3DLayer)this.layerConf()).getPadding();
            outSize = Convolution3DUtils.get3DOutputSize(this.input, kernel, strides, pad, this.convolutionMode, dilation, isNCDHW);
        }
        long outD = outSize[0];
        long outH = outSize[1];
        long outW = outSize[2];
        String opName = ((org.deeplearning4j.nn.conf.layers.Subsampling3DLayer)this.layerConf()).getPoolingType() == PoolingType.MAX ? "maxpool3dnew" : "avgpool3dnew";
        DataType dataType = this.input.dataType();
        if (isNCDHW) {
            long[] lArray2 = new long[5];
            lArray2[0] = miniBatch;
            lArray2[1] = inChannels;
            lArray2[2] = outD;
            lArray2[3] = outH;
            lArray = lArray2;
            lArray2[4] = outW;
        } else {
            long[] lArray3 = new long[5];
            lArray3[0] = miniBatch;
            lArray3[1] = outD;
            lArray3[2] = outH;
            lArray3[3] = outW;
            lArray = lArray3;
            lArray3[4] = inChannels;
        }
        INDArray output = workspaceMgr.createUninitialized(ArrayType.ACTIVATIONS, dataType, lArray, 'c');
        int[] intArgs = new int[]{kernel[0], kernel[1], kernel[2], strides[0], strides[1], strides[2], pad[0], pad[1], pad[2], dilation[0], dilation[1], dilation[2], this.convolutionMode == ConvolutionMode.Same ? 1 : 0, 0, isNCDHW ? 0 : 1};
        DynamicCustomOp op = DynamicCustomOp.builder((String)opName).addInputs(new INDArray[]{this.input}).addIntegerArguments(intArgs).addOutputs(new INDArray[]{output}).callInplace(false).build();
        Nd4j.getExecutioner().exec((CustomOp)op);
        return output;
    }

    @Override
    public boolean isPretrainLayer() {
        return false;
    }

    @Override
    public void clearNoiseWeightParams() {
    }

    @Override
    public Gradient gradient() {
        throw new UnsupportedOperationException("Not supported - no parameters");
    }

    @Override
    public void fit() {
    }

    @Override
    public long numParams() {
        return 0L;
    }

    @Override
    public void fit(INDArray input, LayerWorkspaceMgr workspaceMgr) {
    }

    @Override
    public double score() {
        return 0.0;
    }

    @Override
    public void update(INDArray gradient, String paramType) {
    }

    @Override
    public INDArray params() {
        return null;
    }

    @Override
    public INDArray getParam(String param) {
        return this.params();
    }

    @Override
    public void setParams(INDArray params) {
    }
}

