/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.layers;

import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.gradient.DefaultGradient;
import org.deeplearning4j.nn.gradient.Gradient;
import org.deeplearning4j.nn.layers.BaseLayer;
import org.deeplearning4j.nn.workspace.ArrayType;
import org.deeplearning4j.nn.workspace.LayerWorkspaceMgr;
import org.nd4j.common.primitives.Pair;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;

public class DropoutLayer
extends BaseLayer<org.deeplearning4j.nn.conf.layers.DropoutLayer> {
    public DropoutLayer(NeuralNetConfiguration conf, DataType dataType) {
        super(conf, dataType);
    }

    @Override
    public double calcRegularizationScore(boolean backpropParamsOnly) {
        return 0.0;
    }

    @Override
    public Layer.Type type() {
        return Layer.Type.FEED_FORWARD;
    }

    @Override
    public void fit(INDArray input, LayerWorkspaceMgr workspaceMgr) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public Pair<Gradient, INDArray> backpropGradient(INDArray epsilon, LayerWorkspaceMgr workspaceMgr) {
        INDArray delta = workspaceMgr.dup(ArrayType.ACTIVATION_GRAD, epsilon);
        if (this.maskArray != null) {
            delta.muliColumnVector(this.maskArray);
        }
        DefaultGradient ret = new DefaultGradient();
        delta = this.backpropDropOutIfPresent(delta);
        return new Pair((Object)ret, (Object)delta);
    }

    @Override
    public INDArray activate(boolean training, LayerWorkspaceMgr workspaceMgr) {
        INDArray ret;
        this.assertInputSet(false);
        if (!training) {
            ret = this.input;
        } else if (((org.deeplearning4j.nn.conf.layers.DropoutLayer)this.layerConf()).getIDropout() != null) {
            INDArray result = this.inputModificationAllowed ? this.input : workspaceMgr.createUninitialized(ArrayType.INPUT, this.input.dataType(), this.input.shape(), this.input.ordering());
            ret = ((org.deeplearning4j.nn.conf.layers.DropoutLayer)this.layerConf()).getIDropout().applyDropout(this.input, result, this.getIterationCount(), this.getEpochCount(), workspaceMgr);
        } else {
            ret = workspaceMgr.leverageTo(ArrayType.ACTIVATIONS, this.input);
        }
        if (this.maskArray != null) {
            ret.muliColumnVector(this.maskArray);
        }
        ret = workspaceMgr.leverageTo(ArrayType.ACTIVATIONS, ret);
        return ret;
    }

    @Override
    public boolean isPretrainLayer() {
        return false;
    }

    @Override
    public INDArray params() {
        return null;
    }
}

