/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.layers.objdetect;

import java.io.IOException;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.serde.jackson.shaded.NDArrayTextDeSerializer;
import org.nd4j.shade.jackson.core.JsonParser;
import org.nd4j.shade.jackson.core.JsonProcessingException;
import org.nd4j.shade.jackson.databind.DeserializationContext;
import org.nd4j.shade.jackson.databind.JsonDeserializer;
import org.nd4j.shade.jackson.databind.JsonNode;

public class BoundingBoxesDeserializer
extends JsonDeserializer<INDArray> {
    public INDArray deserialize(JsonParser jp, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        if (node.has("dataBuffer")) {
            JsonNode arr = node.get("dataBuffer");
            int rank = node.get("rankField").asInt();
            int numElements = node.get("numElements").asInt();
            int offset = node.get("offsetField").asInt();
            JsonNode shape = node.get("shapeField");
            JsonNode stride = node.get("strideField");
            int[] shapeArr = new int[rank];
            int[] strideArr = new int[rank];
            DataBuffer buff = Nd4j.createBuffer((long)numElements);
            for (int i = 0; i < numElements; ++i) {
                buff.put((long)i, arr.get(i).asDouble());
            }
            String ordering = node.get("orderingField").asText();
            for (int i = 0; i < rank; ++i) {
                shapeArr[i] = shape.get(i).asInt();
                strideArr[i] = stride.get(i).asInt();
            }
            return Nd4j.create((DataBuffer)buff, (int[])shapeArr, (int[])strideArr, (long)offset, (char)ordering.charAt(0));
        }
        return new NDArrayTextDeSerializer().deserialize(node);
    }
}

