/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.layers;

import java.util.Collection;
import java.util.Map;
import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.conf.CNN2DFormat;
import org.deeplearning4j.nn.conf.InputPreProcessor;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.RNNFormat;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.layers.InputTypeUtil;
import org.deeplearning4j.nn.conf.layers.PoolingType;
import org.deeplearning4j.nn.conf.layers.SubsamplingLayer;
import org.deeplearning4j.optimize.api.TrainingListener;
import org.deeplearning4j.util.Convolution1DUtils;
import org.deeplearning4j.util.ConvolutionUtils;
import org.deeplearning4j.util.ValidationUtils;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;

public class Subsampling1DLayer
extends SubsamplingLayer {
    private Subsampling1DLayer(Builder builder) {
        super(builder);
    }

    @Override
    public Layer instantiate(NeuralNetConfiguration conf, Collection<TrainingListener> trainingListeners, int layerIndex, INDArray layerParamsView, boolean initializeParams, DataType networkDataType) {
        org.deeplearning4j.nn.layers.convolution.subsampling.Subsampling1DLayer ret = new org.deeplearning4j.nn.layers.convolution.subsampling.Subsampling1DLayer(conf, networkDataType);
        ret.setListeners(trainingListeners);
        ret.setIndex(layerIndex);
        ret.setParamsViewArray(layerParamsView);
        Map<String, INDArray> paramTable = this.initializer().init(conf, layerParamsView, initializeParams);
        ret.setParamTable(paramTable);
        ret.setConf(conf);
        return ret;
    }

    @Override
    public InputType getOutputType(int layerIndex, InputType inputType) {
        if (inputType == null || inputType.getType() != InputType.Type.RNN) {
            throw new IllegalStateException("Invalid input for Subsampling1D layer (layer name=\"" + this.getLayerName() + "\"): Expected RNN input, got " + inputType);
        }
        InputType.InputTypeRecurrent r = (InputType.InputTypeRecurrent)inputType;
        long inputTsLength = r.getTimeSeriesLength();
        long outLength = inputTsLength < 0L ? -1L : Convolution1DUtils.getOutputSize(inputTsLength, this.kernelSize[0], this.stride[0], this.padding[0], this.convolutionMode, this.dilation[0]);
        return InputType.recurrent(r.getSize(), outLength, r.getFormat());
    }

    @Override
    public void setNIn(InputType inputType, boolean override) {
        if (this.cnn2dDataFormat == null || override) {
            if (inputType.getType() == InputType.Type.RNN) {
                InputType.InputTypeRecurrent inputTypeConvolutional = (InputType.InputTypeRecurrent)inputType;
                this.cnn2dDataFormat = inputTypeConvolutional.getFormat() == RNNFormat.NCW ? CNN2DFormat.NCHW : CNN2DFormat.NHWC;
            } else if (inputType.getType() == InputType.Type.CNN) {
                InputType.InputTypeConvolutional inputTypeConvolutional = (InputType.InputTypeConvolutional)inputType;
                this.cnn2dDataFormat = inputTypeConvolutional.getFormat();
            }
        }
    }

    @Override
    public InputPreProcessor getPreProcessorForInputType(InputType inputType) {
        if (inputType == null) {
            throw new IllegalStateException("Invalid input for Subsampling1D layer (layer name=\"" + this.getLayerName() + "\"): input is null");
        }
        return InputTypeUtil.getPreprocessorForInputTypeRnnLayers(inputType, RNNFormat.NCW, this.getLayerName());
    }

    @Override
    public Subsampling1DLayer clone() {
        Subsampling1DLayer clone = (Subsampling1DLayer)super.clone();
        if (clone.kernelSize != null) {
            clone.kernelSize = (int[])clone.kernelSize.clone();
        }
        if (clone.stride != null) {
            clone.stride = (int[])clone.stride.clone();
        }
        if (clone.padding != null) {
            clone.padding = (int[])clone.padding.clone();
        }
        if (clone.dilation != null) {
            clone.dilation = (int[])clone.dilation.clone();
        }
        return clone;
    }

    public Subsampling1DLayer() {
    }

    @Override
    public String toString() {
        return "Subsampling1DLayer(super=" + super.toString() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Subsampling1DLayer)) {
            return false;
        }
        Subsampling1DLayer other = (Subsampling1DLayer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Subsampling1DLayer;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    public static class Builder
    extends SubsamplingLayer.BaseSubsamplingBuilder<Builder> {
        private static final PoolingType DEFAULT_POOLING = PoolingType.MAX;
        private static final int DEFAULT_KERNEL = 2;
        private static final int DEFAULT_STRIDE = 1;
        private static final int DEFAULT_PADDING = 0;

        public Builder(SubsamplingLayer.PoolingType poolingType, int kernelSize, int stride) {
            this(poolingType, kernelSize, stride, 0);
        }

        public Builder(SubsamplingLayer.PoolingType poolingType, int kernelSize) {
            this(poolingType, kernelSize, 1, 0);
        }

        public Builder(PoolingType poolingType, int kernelSize) {
            this(poolingType, kernelSize, 1, 0);
        }

        public Builder(int kernelSize, int stride, int padding) {
            this(DEFAULT_POOLING, kernelSize, stride, padding);
        }

        public Builder(int kernelSize, int stride) {
            this(DEFAULT_POOLING, kernelSize, stride, 0);
        }

        public Builder(int kernelSize) {
            this(DEFAULT_POOLING, kernelSize, 1, 0);
        }

        public Builder(SubsamplingLayer.PoolingType poolingType) {
            this(poolingType, 2, 1, 0);
        }

        public Builder(PoolingType poolingType) {
            this(poolingType, 2, 1, 0);
        }

        @Override
        protected boolean allowCausal() {
            return true;
        }

        public Builder() {
            this(DEFAULT_POOLING, 2, 1, 0);
        }

        public Builder(PoolingType poolingType, int kernelSize, int stride, int padding) {
            this.setKernelSize(kernelSize);
            this.setPadding(padding);
            this.setStride(stride);
        }

        public Builder(SubsamplingLayer.PoolingType poolingType, int kernelSize, int stride, int padding) {
            this.poolingType = poolingType.toPoolingType();
            this.setKernelSize(kernelSize);
            this.setStride(stride);
            this.setPadding(padding);
        }

        @Override
        public Subsampling1DLayer build() {
            if (this.poolingType == PoolingType.PNORM && this.pnorm <= 0) {
                throw new IllegalStateException("Incorrect Subsampling config: p-norm must be set when using PoolingType.PNORM");
            }
            ConvolutionUtils.validateConvolutionModePadding(this.convolutionMode, this.padding);
            ConvolutionUtils.validateCnnKernelStridePadding(this.kernelSize, this.stride, this.padding);
            return new Subsampling1DLayer(this);
        }

        public Builder kernelSize(int kernelSize) {
            this.setKernelSize(kernelSize);
            return this;
        }

        public Builder stride(int stride) {
            this.setStride(stride);
            return this;
        }

        public Builder padding(int padding) {
            this.setPadding(padding);
            return this;
        }

        @Override
        public void setKernelSize(int ... kernelSize) {
            this.kernelSize[0] = ValidationUtils.validate1NonNegative(kernelSize, "kernelSize")[0];
        }

        @Override
        public void setStride(int ... stride) {
            this.stride = ConvolutionUtils.getIntConfig(stride, 1);
        }

        @Override
        public void setPadding(int ... padding) {
            this.padding = ConvolutionUtils.getIntConfig(padding, 1);
        }
    }
}

