/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.layers;

import java.util.Collection;
import java.util.Map;
import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.api.ParamInitializer;
import org.deeplearning4j.nn.conf.CNN2DFormat;
import org.deeplearning4j.nn.conf.InputPreProcessor;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.layers.InputTypeUtil;
import org.deeplearning4j.nn.conf.layers.Layer;
import org.deeplearning4j.nn.conf.layers.NoParamLayer;
import org.deeplearning4j.nn.conf.memory.LayerMemoryReport;
import org.deeplearning4j.nn.conf.memory.MemoryReport;
import org.deeplearning4j.nn.layers.convolution.SpaceToDepth;
import org.deeplearning4j.nn.params.EmptyParamInitializer;
import org.deeplearning4j.optimize.api.TrainingListener;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;

public class SpaceToDepthLayer
extends NoParamLayer {
    protected int blockSize;
    protected CNN2DFormat dataFormat;

    protected SpaceToDepthLayer(Builder builder) {
        super(builder);
        this.setBlockSize(builder.blockSize);
        this.setDataFormat(builder.dataFormat);
    }

    @Override
    public SpaceToDepthLayer clone() {
        return (SpaceToDepthLayer)super.clone();
    }

    @Override
    public Layer instantiate(NeuralNetConfiguration conf, Collection<TrainingListener> trainingListeners, int layerIndex, INDArray layerParamsView, boolean initializeParams, DataType networkDataType) {
        SpaceToDepth ret = new SpaceToDepth(conf, networkDataType);
        ret.setListeners(trainingListeners);
        ret.setIndex(layerIndex);
        ret.setParamsViewArray(layerParamsView);
        Map<String, INDArray> paramTable = this.initializer().init(conf, layerParamsView, initializeParams);
        ret.setParamTable(paramTable);
        ret.setConf(conf);
        return ret;
    }

    @Override
    public LayerMemoryReport getMemoryReport(InputType inputType) {
        InputType.InputTypeConvolutional outputType = (InputType.InputTypeConvolutional)this.getOutputType(-1, inputType);
        return new LayerMemoryReport.Builder(this.layerName, SpaceToDepthLayer.class, inputType, outputType).standardMemory(0L, 0L).cacheMemory(MemoryReport.CACHE_MODE_ALL_ZEROS, MemoryReport.CACHE_MODE_ALL_ZEROS).build();
    }

    @Override
    public InputType getOutputType(int layerIndex, InputType inputType) {
        if (inputType == null || inputType.getType() != InputType.Type.CNN) {
            throw new IllegalStateException("Invalid input for space to channels layer (layer name=\"" + this.getLayerName() + "\"): Expected CNN input, got " + inputType);
        }
        InputType.InputTypeConvolutional i = (InputType.InputTypeConvolutional)inputType;
        return InputType.convolutional(i.getHeight() / (long)this.blockSize, i.getWidth() / (long)this.blockSize, i.getChannels() * (long)this.blockSize * (long)this.blockSize, i.getFormat());
    }

    @Override
    public ParamInitializer initializer() {
        return EmptyParamInitializer.getInstance();
    }

    @Override
    public void setNIn(InputType inputType, boolean override) {
        this.dataFormat = ((InputType.InputTypeConvolutional)inputType).getFormat();
    }

    @Override
    public InputPreProcessor getPreProcessorForInputType(InputType inputType) {
        if (inputType == null) {
            throw new IllegalStateException("Invalid input for space to channels layer (layer name=\"" + this.getLayerName() + "\"): input is null");
        }
        return InputTypeUtil.getPreProcessorForInputTypeCnnLayers(inputType, this.getLayerName());
    }

    @Override
    public boolean isPretrainParam(String paramName) {
        throw new UnsupportedOperationException("SpaceToDepthLayer does not contain parameters");
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public CNN2DFormat getDataFormat() {
        return this.dataFormat;
    }

    public void setBlockSize(int blockSize) {
        this.blockSize = blockSize;
    }

    public void setDataFormat(CNN2DFormat dataFormat) {
        this.dataFormat = dataFormat;
    }

    public SpaceToDepthLayer() {
    }

    @Override
    public String toString() {
        return "SpaceToDepthLayer(super=" + super.toString() + ", blockSize=" + this.getBlockSize() + ", dataFormat=" + this.getDataFormat() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SpaceToDepthLayer)) {
            return false;
        }
        SpaceToDepthLayer other = (SpaceToDepthLayer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getBlockSize() != other.getBlockSize()) {
            return false;
        }
        CNN2DFormat this$dataFormat = this.getDataFormat();
        CNN2DFormat other$dataFormat = other.getDataFormat();
        return !(this$dataFormat == null ? other$dataFormat != null : !this$dataFormat.equals(other$dataFormat));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof SpaceToDepthLayer;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getBlockSize();
        CNN2DFormat $dataFormat = this.getDataFormat();
        result = result * 59 + ($dataFormat == null ? 43 : $dataFormat.hashCode());
        return result;
    }

    public static class Builder<T extends Builder<T>>
    extends Layer.Builder<T> {
        protected int blockSize;
        protected CNN2DFormat dataFormat = CNN2DFormat.NCHW;

        public Builder(int blockSize) {
            this.setBlockSize(blockSize);
        }

        @Deprecated
        public Builder(int blockSize, DataFormat dataFormat) {
            this(blockSize, dataFormat.toFormat());
        }

        public Builder(int blockSize, CNN2DFormat dataFormat) {
            this.setBlockSize(blockSize);
            this.setDataFormat(dataFormat);
        }

        public T blocks(int blockSize) {
            this.setBlockSize(blockSize);
            return (T)this;
        }

        @Deprecated
        public T dataFormat(DataFormat dataFormat) {
            return this.dataFormat(dataFormat.toFormat());
        }

        public T dataFormat(CNN2DFormat dataFormat) {
            this.setDataFormat(dataFormat);
            return (T)this;
        }

        @Override
        public T name(String layerName) {
            this.setLayerName(layerName);
            return (T)this;
        }

        @Override
        public SpaceToDepthLayer build() {
            return new SpaceToDepthLayer(this);
        }

        public Builder() {
        }

        public int getBlockSize() {
            return this.blockSize;
        }

        public CNN2DFormat getDataFormat() {
            return this.dataFormat;
        }

        public void setBlockSize(int blockSize) {
            this.blockSize = blockSize;
        }

        public void setDataFormat(CNN2DFormat dataFormat) {
            this.dataFormat = dataFormat;
        }
    }

    @Deprecated
    public static enum DataFormat {
        NCHW,
        NHWC;


        public CNN2DFormat toFormat() {
            return this == NCHW ? CNN2DFormat.NCHW : CNN2DFormat.NHWC;
        }
    }
}

