/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.earlystopping.termination;

import org.deeplearning4j.earlystopping.termination.EpochTerminationCondition;
import org.nd4j.shade.jackson.annotation.JsonProperty;

public class BestScoreEpochTerminationCondition
implements EpochTerminationCondition {
    @JsonProperty
    private final double bestExpectedScore;

    public BestScoreEpochTerminationCondition(@JsonProperty(value="bestExpectedScore") double bestExpectedScore) {
        this.bestExpectedScore = bestExpectedScore;
    }

    @Deprecated
    public BestScoreEpochTerminationCondition(double bestExpectedScore, boolean lesserBetter) {
        this(bestExpectedScore);
    }

    @Override
    public void initialize() {
    }

    @Override
    public boolean terminate(int epochNum, double score, boolean minimize) {
        if (minimize) {
            return score < this.bestExpectedScore;
        }
        return this.bestExpectedScore < score;
    }

    public String toString() {
        return "BestScoreEpochTerminationCondition(" + this.bestExpectedScore + ")";
    }

    public double getBestExpectedScore() {
        return this.bestExpectedScore;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BestScoreEpochTerminationCondition)) {
            return false;
        }
        BestScoreEpochTerminationCondition other = (BestScoreEpochTerminationCondition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return Double.compare(this.getBestExpectedScore(), other.getBestExpectedScore()) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof BestScoreEpochTerminationCondition;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $bestExpectedScore = Double.doubleToLongBits(this.getBestExpectedScore());
        result = result * 59 + (int)($bestExpectedScore >>> 32 ^ $bestExpectedScore);
        return result;
    }
}

