/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.layers.convolution.upsampling;

import java.util.Arrays;
import org.deeplearning4j.exception.DL4JInvalidInputException;
import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.conf.CacheMode;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.layers.Convolution3D;
import org.deeplearning4j.nn.gradient.DefaultGradient;
import org.deeplearning4j.nn.gradient.Gradient;
import org.deeplearning4j.nn.layers.AbstractLayer;
import org.deeplearning4j.nn.workspace.ArrayType;
import org.deeplearning4j.nn.workspace.LayerWorkspaceMgr;
import org.nd4j.common.primitives.Pair;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.memory.MemoryWorkspace;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.CustomOp;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.nd4j.linalg.factory.Nd4j;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Upsampling3D
extends AbstractLayer<org.deeplearning4j.nn.conf.layers.Upsampling3D> {
    private static final Logger log = LoggerFactory.getLogger(Upsampling3D.class);

    public Upsampling3D(NeuralNetConfiguration conf, DataType dataType) {
        super(conf, dataType);
    }

    @Override
    public double calcRegularizationScore(boolean backpropParamsOnly) {
        return 0.0;
    }

    @Override
    public Layer.Type type() {
        return Layer.Type.UPSAMPLING;
    }

    @Override
    public Pair<Gradient, INDArray> backpropGradient(INDArray epsilon, LayerWorkspaceMgr workspaceMgr) {
        int[] intArgs;
        long inW;
        long inH;
        long inD;
        long inChannels;
        this.assertInputSet(true);
        boolean ncdhw = ((org.deeplearning4j.nn.conf.layers.Upsampling3D)this.layerConf()).getDataFormat() == Convolution3D.DataFormat.NCDHW;
        long miniBatch = this.input.size(0);
        if (ncdhw) {
            inChannels = this.input.size(1);
            inD = this.input.size(2);
            inH = this.input.size(3);
            inW = this.input.size(4);
            intArgs = new int[]{1};
        } else {
            inD = this.input.size(1);
            inH = this.input.size(2);
            inW = this.input.size(3);
            inChannels = this.input.size(4);
            intArgs = new int[]{0};
        }
        INDArray epsOut = ncdhw ? workspaceMgr.createUninitialized(ArrayType.ACTIVATION_GRAD, epsilon.dataType(), new long[]{miniBatch, inChannels, inD, inH, inW}, 'c') : workspaceMgr.createUninitialized(ArrayType.ACTIVATION_GRAD, epsilon.dataType(), new long[]{miniBatch, inD, inH, inW, inChannels}, 'c');
        DefaultGradient gradient = new DefaultGradient();
        DynamicCustomOp op = DynamicCustomOp.builder((String)"upsampling3d_bp").addIntegerArguments(intArgs).addInputs(new INDArray[]{this.input, epsilon}).addOutputs(new INDArray[]{epsOut}).callInplace(false).build();
        Nd4j.getExecutioner().exec((CustomOp)op);
        epsOut = this.backpropDropOutIfPresent(epsOut);
        return new Pair((Object)gradient, (Object)epsOut);
    }

    protected int[] getSize() {
        return ((org.deeplearning4j.nn.conf.layers.Upsampling3D)this.layerConf()).getSize();
    }

    protected INDArray preOutput(boolean training, boolean forBackprop, LayerWorkspaceMgr workspaceMgr) {
        int[] intArgs;
        long inW;
        long inH;
        long inD;
        long inChannels;
        this.assertInputSet(false);
        this.applyDropOutIfNecessary(training, workspaceMgr);
        if (this.input.rank() != 5) {
            throw new DL4JInvalidInputException("Got rank " + this.input.rank() + " array as input to Upsampling3DLayer with shape " + Arrays.toString(this.input.shape()) + ". Expected rank 5 array with shape [minibatchSize, channels, inputDepth, inputHeight, inputWidth]. " + this.layerId());
        }
        if (this.preOutput != null && forBackprop) {
            return this.preOutput;
        }
        boolean ncdhw = ((org.deeplearning4j.nn.conf.layers.Upsampling3D)this.layerConf()).getDataFormat() == Convolution3D.DataFormat.NCDHW;
        long miniBatch = this.input.size(0);
        int[] size = this.getSize();
        if (ncdhw) {
            inChannels = (int)this.input.size(1);
            inD = (int)this.input.size(2);
            inH = (int)this.input.size(3);
            inW = (int)this.input.size(4);
            intArgs = new int[]{size[0], size[1], size[2], 1};
        } else {
            inD = (int)this.input.size(1);
            inH = (int)this.input.size(2);
            inW = (int)this.input.size(3);
            inChannels = (int)this.input.size(4);
            intArgs = new int[]{size[0], size[1], size[2], 0};
        }
        long outD = inD * (long)size[0];
        long outH = inH * (long)size[1];
        long outW = inW * (long)size[2];
        INDArray output = ncdhw ? workspaceMgr.createUninitialized(ArrayType.ACTIVATIONS, this.input.dataType(), new long[]{miniBatch, inChannels, outD, outH, outW}, 'c') : workspaceMgr.createUninitialized(ArrayType.ACTIVATIONS, this.input.dataType(), new long[]{miniBatch, outD, outH, outW, inChannels}, 'c');
        DynamicCustomOp upsampling = DynamicCustomOp.builder((String)"upsampling3d").addIntegerArguments(intArgs).addInputs(new INDArray[]{this.input}).addOutputs(new INDArray[]{output}).callInplace(false).build();
        Nd4j.getExecutioner().exec((CustomOp)upsampling);
        return output;
    }

    @Override
    public INDArray activate(boolean training, LayerWorkspaceMgr workspaceMgr) {
        this.assertInputSet(false);
        this.applyDropOutIfNecessary(training, workspaceMgr);
        if (this.cacheMode == null) {
            this.cacheMode = CacheMode.NONE;
        }
        INDArray z = this.preOutput(training, false, workspaceMgr);
        if (training && this.cacheMode != CacheMode.NONE && workspaceMgr.hasConfiguration(ArrayType.FF_CACHE) && workspaceMgr.isWorkspaceOpen(ArrayType.FF_CACHE)) {
            try (MemoryWorkspace wsB = workspaceMgr.notifyScopeBorrowed(ArrayType.FF_CACHE);){
                this.preOutput = z.unsafeDuplication();
            }
        }
        return z;
    }

    @Override
    public boolean isPretrainLayer() {
        return false;
    }

    @Override
    public void clearNoiseWeightParams() {
    }

    @Override
    public Gradient gradient() {
        throw new UnsupportedOperationException("Not supported - no parameters");
    }

    @Override
    public void fit() {
    }

    @Override
    public long numParams() {
        return 0L;
    }

    @Override
    public void fit(INDArray input, LayerWorkspaceMgr workspaceMgr) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public double score() {
        return 0.0;
    }

    @Override
    public void update(INDArray gradient, String paramType) {
    }

    @Override
    public INDArray params() {
        return null;
    }

    @Override
    public INDArray getParam(String param) {
        return this.params();
    }

    @Override
    public void setParams(INDArray params) {
    }
}

