/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.layers.convolution.subsampling;

import java.util.Arrays;
import org.deeplearning4j.exception.DL4JInvalidInputException;
import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.api.MaskState;
import org.deeplearning4j.nn.conf.CNN2DFormat;
import org.deeplearning4j.nn.conf.ConvolutionMode;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.gradient.DefaultGradient;
import org.deeplearning4j.nn.gradient.Gradient;
import org.deeplearning4j.nn.layers.AbstractLayer;
import org.deeplearning4j.nn.layers.HelperUtils;
import org.deeplearning4j.nn.layers.LayerHelper;
import org.deeplearning4j.nn.layers.convolution.subsampling.SubsamplingHelper;
import org.deeplearning4j.nn.layers.mkldnn.MKLDNNSubsamplingHelper;
import org.deeplearning4j.nn.workspace.ArrayType;
import org.deeplearning4j.nn.workspace.LayerWorkspaceMgr;
import org.deeplearning4j.util.ConvolutionUtils;
import org.nd4j.common.primitives.Pair;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.CustomOp;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.nd4j.linalg.api.shape.LongShapeDescriptor;
import org.nd4j.linalg.exception.ND4JOpProfilerException;
import org.nd4j.linalg.factory.Nd4j;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubsamplingLayer
extends AbstractLayer<org.deeplearning4j.nn.conf.layers.SubsamplingLayer> {
    private static final Logger log = LoggerFactory.getLogger(SubsamplingLayer.class);
    protected SubsamplingHelper helper = null;
    protected int helperCountFail = 0;
    protected ConvolutionMode convolutionMode;
    public static final String CUDNN_SUBSAMPLING_HELPER_CLASS_NAME = "org.deeplearning4j.cuda.convolution.subsampling.CudnnSubsamplingHelper";

    public SubsamplingLayer(NeuralNetConfiguration conf, DataType dataType) {
        super(conf, dataType);
        this.initializeHelper();
        this.convolutionMode = ((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)conf.getLayer()).getConvolutionMode();
    }

    void initializeHelper() {
        this.helper = (SubsamplingHelper)HelperUtils.createHelper(CUDNN_SUBSAMPLING_HELPER_CLASS_NAME, MKLDNNSubsamplingHelper.class.getName(), SubsamplingHelper.class, ((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)this.layerConf()).getLayerName(), this.dataType);
    }

    @Override
    public double calcRegularizationScore(boolean backpropOnlyParams) {
        return 0.0;
    }

    @Override
    public Layer.Type type() {
        return Layer.Type.SUBSAMPLING;
    }

    @Override
    public Pair<Gradient, INDArray> backpropGradient(INDArray epsilon, LayerWorkspaceMgr workspaceMgr) {
        DynamicCustomOp.DynamicCustomOpsBuilder b;
        this.assertInputSet(true);
        INDArray input = this.input.castTo(this.dataType);
        if (epsilon.dataType() != this.dataType) {
            epsilon = epsilon.castTo(this.dataType);
        }
        CNN2DFormat dataFormat = ((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)this.layerConf()).getCnn2dDataFormat();
        int hIdx = 2;
        int wIdx = 3;
        if (dataFormat == CNN2DFormat.NHWC) {
            hIdx = 1;
            wIdx = 2;
        }
        int inH = (int)input.size(hIdx);
        int inW = (int)input.size(wIdx);
        int[] kernel = ((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)this.layerConf()).getKernelSize();
        int[] strides = ((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)this.layerConf()).getStride();
        int[] dilation = ((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)this.layerConf()).getDilation();
        int[] outSizeFwd = new int[]{(int)epsilon.size(hIdx), (int)epsilon.size(wIdx)};
        boolean same = this.convolutionMode == ConvolutionMode.Same;
        int[] pad = same ? ConvolutionUtils.getSameModeTopLeftPadding(outSizeFwd, new int[]{inH, inW}, kernel, strides, dilation) : ((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)this.layerConf()).getPadding();
        if (!(this.helper == null || this.helperCountFail != 0 && ((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)this.layerConf()).isCudnnAllowFallback())) {
            Pair<Gradient, INDArray> ret = null;
            try {
                ret = this.helper.backpropGradient(input, epsilon, kernel, strides, pad, ((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)this.layerConf()).getPoolingType(), this.convolutionMode, dilation, dataFormat, workspaceMgr);
            }
            catch (ND4JOpProfilerException e) {
                throw e;
            }
            catch (Exception e) {
                if (e.getMessage() != null && e.getMessage().contains("Failed to allocate")) {
                    throw e;
                }
                if (((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)this.layerConf()).isCudnnAllowFallback()) {
                    ++this.helperCountFail;
                    if (this.helper instanceof MKLDNNSubsamplingHelper) {
                        log.warn("MKL-DNN execution failed - falling back on built-in implementation", (Throwable)e);
                    } else {
                        log.warn("CuDNN execution failed - falling back on built-in implementation", (Throwable)e);
                    }
                }
                throw new RuntimeException(e);
            }
            if (ret != null) {
                return ret;
            }
        }
        DefaultGradient retGradient = new DefaultGradient();
        INDArray epsAtInput = workspaceMgr.createUninitialized(ArrayType.ACTIVATION_GRAD, input.dataType(), input.shape(), 'c');
        int extra = 0;
        switch (((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)this.layerConf()).getPoolingType()) {
            case MAX: {
                b = DynamicCustomOp.builder((String)"maxpool2d_bp");
                break;
            }
            case AVG: {
                b = DynamicCustomOp.builder((String)"avgpool2d_bp");
                if (((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)this.layerConf()).isAvgPoolIncludePadInDivisor()) {
                    extra = 1;
                    break;
                }
                extra = 0;
                break;
            }
            case PNORM: {
                b = DynamicCustomOp.builder((String)"pnormpool2d_bp");
                extra = ((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)this.layerConf()).getPnorm();
                b.addFloatingPointArguments(new Double[]{((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)this.layerConf()).getEps()});
                break;
            }
            default: {
                throw new UnsupportedOperationException("Pooling mode not supported in SubsamplingLayer: " + ((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)this.layerConf()).getPoolingType());
            }
        }
        b.addInputs(new INDArray[]{input, epsilon}).addOutputs(new INDArray[]{epsAtInput}).addIntegerArguments(new int[]{kernel[0], kernel[1], strides[0], strides[1], pad[0], pad[1], dilation[0], dilation[1], same ? 1 : 0, extra, dataFormat == CNN2DFormat.NCHW ? 0 : 1});
        Nd4j.exec((CustomOp)b.build());
        return new Pair((Object)retGradient, (Object)epsAtInput);
    }

    @Override
    public INDArray activate(boolean training, LayerWorkspaceMgr workspaceMgr) {
        DynamicCustomOp.DynamicCustomOpsBuilder b;
        this.assertInputSet(false);
        if (this.input.rank() != 4) {
            throw new DL4JInvalidInputException("Got rank " + this.input.rank() + " array as input to SubsamplingLayer with shape " + Arrays.toString(this.input.shape()) + ". Expected rank 4 array with shape " + ((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)this.layerConf()).getCnn2dDataFormat().dimensionNames() + ". " + this.layerId());
        }
        INDArray input = this.input.castTo(this.dataType);
        boolean same = this.convolutionMode == ConvolutionMode.Same;
        int[] kernel = ((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)this.layerConf()).getKernelSize();
        int[] strides = ((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)this.layerConf()).getStride();
        int[] dilation = ((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)this.layerConf()).getDilation();
        int[] pad = ((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)this.layerConf()).getPadding();
        int extra = 0;
        switch (((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)this.layerConf()).getPoolingType()) {
            case MAX: {
                b = DynamicCustomOp.builder((String)"maxpool2d");
                break;
            }
            case AVG: {
                b = DynamicCustomOp.builder((String)"avgpool2d");
                if (((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)this.layerConf()).isAvgPoolIncludePadInDivisor()) {
                    extra = 1;
                    break;
                }
                extra = 0;
                break;
            }
            case PNORM: {
                b = DynamicCustomOp.builder((String)"pnormpool2d");
                extra = ((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)this.layerConf()).getPnorm();
                break;
            }
            default: {
                throw new UnsupportedOperationException("Not supported: " + ((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)this.layerConf()).getPoolingType());
            }
        }
        b.addInputs(new INDArray[]{input}).addIntegerArguments(new int[]{kernel[0], kernel[1], strides[0], strides[1], pad[0], pad[1], dilation[0], dilation[1], same ? 1 : 0, extra, ((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)this.layerConf()).getCnn2dDataFormat() == CNN2DFormat.NCHW ? 0 : 1});
        DynamicCustomOp build = b.build();
        long[] shape = ((LongShapeDescriptor)build.calculateOutputShape().get(0)).getShape();
        INDArray output = workspaceMgr.createUninitialized(ArrayType.ACTIVATIONS, input.dataType(), shape, 'c');
        build.addOutputArgument(new INDArray[]{output});
        Nd4j.exec((CustomOp)build);
        return output;
    }

    @Override
    public boolean isPretrainLayer() {
        return false;
    }

    @Override
    public void clearNoiseWeightParams() {
    }

    @Override
    public LayerHelper getHelper() {
        return this.helper;
    }

    @Override
    public Gradient gradient() {
        throw new UnsupportedOperationException("Not supported - no parameters");
    }

    @Override
    public void fit() {
    }

    @Override
    public long numParams() {
        return 0L;
    }

    @Override
    public void fit(INDArray input, LayerWorkspaceMgr workspaceMgr) {
    }

    @Override
    public double score() {
        return 0.0;
    }

    @Override
    public void update(INDArray gradient, String paramType) {
    }

    @Override
    public INDArray params() {
        return null;
    }

    @Override
    public INDArray getParam(String param) {
        return this.params();
    }

    @Override
    public void setParams(INDArray params) {
    }

    @Override
    public Pair<INDArray, MaskState> feedForwardMaskArray(INDArray maskArray, MaskState currentMaskState, int minibatchSize) {
        if (maskArray == null) {
            return new Pair((Object)maskArray, (Object)currentMaskState);
        }
        INDArray outMask = ConvolutionUtils.cnn2dMaskReduction(maskArray, ((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)this.layerConf()).getKernelSize(), ((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)this.layerConf()).getStride(), ((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)this.layerConf()).getPadding(), ((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)this.layerConf()).getDilation(), ((org.deeplearning4j.nn.conf.layers.SubsamplingLayer)this.layerConf()).getConvolutionMode());
        return super.feedForwardMaskArray(outMask, currentMaskState, minibatchSize);
    }
}

