/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.layers.convolution;

import java.util.Arrays;
import org.deeplearning4j.exception.DL4JInvalidInputException;
import org.deeplearning4j.nn.conf.CNN2DFormat;
import org.deeplearning4j.nn.conf.CacheMode;
import org.deeplearning4j.nn.conf.ConvolutionMode;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.gradient.DefaultGradient;
import org.deeplearning4j.nn.gradient.Gradient;
import org.deeplearning4j.nn.layers.convolution.ConvolutionLayer;
import org.deeplearning4j.nn.workspace.ArrayType;
import org.deeplearning4j.nn.workspace.LayerWorkspaceMgr;
import org.deeplearning4j.util.ConvolutionUtils;
import org.nd4j.common.primitives.Pair;
import org.nd4j.linalg.activations.IActivation;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.CustomOp;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.nd4j.linalg.exception.ND4JArraySizeException;
import org.nd4j.linalg.factory.Nd4j;

public class DepthwiseConvolution2DLayer
extends ConvolutionLayer {
    public DepthwiseConvolution2DLayer(NeuralNetConfiguration conf, DataType dataType) {
        super(conf, dataType);
    }

    @Override
    void initializeHelper() {
    }

    @Override
    public Pair<Gradient, INDArray> backpropGradient(INDArray epsilon, LayerWorkspaceMgr workspaceMgr) {
        INDArray[] outputs;
        INDArray[] inputs;
        long[] lArray;
        int[] pad;
        boolean nchw;
        this.assertInputSet(true);
        CNN2DFormat format = ((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).getCnn2dDataFormat();
        boolean bl = nchw = format == CNN2DFormat.NCHW;
        if (this.input.rank() != 4) {
            throw new DL4JInvalidInputException("Got rank " + this.input.rank() + " array as input to Convolution layer with shape " + Arrays.toString(this.input.shape()) + ". Expected rank 4 array with shape " + ((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).getCnn2dDataFormat().dimensionNames() + ". " + this.layerId());
        }
        INDArray depthWiseWeights = this.getParamWithNoise("W", true, workspaceMgr);
        INDArray input = this.input.castTo(this.dataType);
        long miniBatch = input.size(0);
        int inH = (int)input.size(nchw ? 2 : 1);
        int inW = (int)input.size(nchw ? 3 : 2);
        long inDepth = depthWiseWeights.size(2);
        int kH = (int)depthWiseWeights.size(0);
        int kW = (int)depthWiseWeights.size(1);
        int[] dilation = ((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).getDilation();
        int[] kernel = ((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).getKernelSize();
        int[] strides = ((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).getStride();
        if (this.convolutionMode == ConvolutionMode.Same) {
            int[] outSize = ConvolutionUtils.getOutputSize(input, kernel, strides, null, this.convolutionMode, dilation, format);
            pad = ConvolutionUtils.getSameModeTopLeftPadding(outSize, new int[]{inH, inW}, kernel, strides, dilation);
        } else {
            pad = ((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).getPadding();
            ConvolutionUtils.getOutputSize(input, kernel, strides, pad, this.convolutionMode, dilation, format);
        }
        INDArray biasGradView = (INDArray)this.gradientViews.get("b");
        INDArray weightGradView = (INDArray)this.gradientViews.get("W");
        if (nchw) {
            long[] lArray2 = new long[4];
            lArray2[0] = miniBatch;
            lArray2[1] = inDepth;
            lArray2[2] = inH;
            lArray = lArray2;
            lArray2[3] = inW;
        } else {
            long[] lArray3 = new long[4];
            lArray3[0] = miniBatch;
            lArray3[1] = inH;
            lArray3[2] = inW;
            lArray = lArray3;
            lArray3[3] = inDepth;
        }
        long[] epsShape = lArray;
        INDArray outEpsilon = workspaceMgr.create(ArrayType.ACTIVATION_GRAD, depthWiseWeights.dataType(), epsShape, 'c');
        int sameMode = this.convolutionMode == ConvolutionMode.Same ? 1 : 0;
        int[] args = new int[]{kH, kW, strides[0], strides[1], pad[0], pad[1], dilation[0], dilation[1], sameMode, nchw ? 0 : 1};
        IActivation afn = ((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).getActivationFn();
        Pair<INDArray, INDArray> p = this.preOutput4d(true, true, workspaceMgr);
        INDArray delta = (INDArray)afn.backprop((INDArray)p.getFirst(), epsilon).getFirst();
        if (((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).hasBias()) {
            INDArray bias = this.getParamWithNoise("b", true, workspaceMgr);
            inputs = new INDArray[]{input, depthWiseWeights, bias, delta};
            outputs = new INDArray[]{outEpsilon, weightGradView, biasGradView};
        } else {
            inputs = new INDArray[]{input, depthWiseWeights, delta};
            outputs = new INDArray[]{outEpsilon, weightGradView};
        }
        DynamicCustomOp op = DynamicCustomOp.builder((String)"depthwise_conv2d_bp").addInputs(inputs).addIntegerArguments(args).addOutputs(outputs).callInplace(false).build();
        Nd4j.getExecutioner().exec((CustomOp)op);
        DefaultGradient retGradient = new DefaultGradient();
        if (((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).hasBias()) {
            retGradient.setGradientFor("b", biasGradView);
        }
        retGradient.setGradientFor("W", weightGradView, Character.valueOf('c'));
        this.weightNoiseParams.clear();
        outEpsilon = this.backpropDropOutIfPresent(outEpsilon);
        return new Pair((Object)retGradient, (Object)outEpsilon);
    }

    @Override
    protected Pair<INDArray, INDArray> preOutput(boolean training, boolean forBackprop, LayerWorkspaceMgr workspaceMgr) {
        long[] lArray;
        int[] pad;
        int[] outSize;
        this.assertInputSet(false);
        INDArray bias = this.getParamWithNoise("b", training, workspaceMgr);
        INDArray depthWiseWeights = this.getParamWithNoise("W", training, workspaceMgr);
        if (this.input.rank() != 4) {
            String layerName = this.conf.getLayer().getLayerName();
            if (layerName == null) {
                layerName = "(not named)";
            }
            throw new DL4JInvalidInputException("Got rank " + this.input.rank() + " array as input to DepthwiseConvolution2D (layer name = " + layerName + ", layer index = " + this.index + ") with shape " + Arrays.toString(this.input.shape()) + ". Expected rank 4 array with shape " + ((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).getCnn2dDataFormat().dimensionNames() + "." + (this.input.rank() == 2 ? " (Wrong input type (see InputType.convolutionalFlat()) or wrong data type?)" : "") + " " + this.layerId());
        }
        INDArray input = this.input.castTo(this.dataType);
        CNN2DFormat format = ((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).getCnn2dDataFormat();
        boolean nchw = format == CNN2DFormat.NCHW;
        long inDepth = depthWiseWeights.size(2);
        long depthMultiplier = depthWiseWeights.size(3);
        long outDepth = depthMultiplier * inDepth;
        if (input.size(nchw ? 1 : 3) != inDepth) {
            int dimIfWrongFormat;
            String layerName = this.conf.getLayer().getLayerName();
            if (layerName == null) {
                layerName = "(not named)";
            }
            String s = "Cannot do forward pass in DepthwiseConvolution2D layer (layer name = " + layerName + ", layer index = " + this.index + "): input array channels does not match CNN layer configuration (data format = " + format + ", data input channels = " + input.size(1) + ", " + (nchw ? "[minibatch,inputDepth,height,width]=" : "[minibatch,height,width,inputDepth]=") + Arrays.toString(input.shape()) + "; expected input channels = " + inDepth + ") " + this.layerId();
            int n = dimIfWrongFormat = format == CNN2DFormat.NHWC ? 1 : 3;
            if (input.size(dimIfWrongFormat) == inDepth) {
                s = s + "\nNote: Convolution layers can be configured for either NCHW (channels first) or NHWC (channels last) format for input images and activations.\nLayers can be configured using .dataFormat(CNN2DFormat.NCHW/NHWC) when constructing the layer, or for the entire net using .setInputType(InputType.convolutional(height, width, depth, CNN2DForman.NCHW/NHWC)).\nImageRecordReader and NativeImageLoader can also be configured to load image data in either NCHW or NHWC format which must match the network";
            }
            throw new DL4JInvalidInputException(s);
        }
        int kH = (int)depthWiseWeights.size(0);
        int kW = (int)depthWiseWeights.size(1);
        int[] dilation = ((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).getDilation();
        int[] kernel = ((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).getKernelSize();
        int[] strides = ((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).getStride();
        if (this.convolutionMode == ConvolutionMode.Same) {
            outSize = ConvolutionUtils.getOutputSize(input, kernel, strides, null, this.convolutionMode, dilation, format);
            if (input.size(2) > Integer.MAX_VALUE || input.size(3) > Integer.MAX_VALUE) {
                throw new ND4JArraySizeException();
            }
            pad = ConvolutionUtils.getSameModeTopLeftPadding(outSize, new int[]{(int)input.size(nchw ? 2 : 1), (int)input.size(nchw ? 3 : 2)}, kernel, strides, dilation);
        } else {
            pad = ((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).getPadding();
            outSize = ConvolutionUtils.getOutputSize(input, kernel, strides, pad, this.convolutionMode, dilation, format);
        }
        long outH = outSize[0];
        long outW = outSize[1];
        long miniBatch = input.size(0);
        if (nchw) {
            long[] lArray2 = new long[4];
            lArray2[0] = miniBatch;
            lArray2[1] = outDepth;
            lArray2[2] = outH;
            lArray = lArray2;
            lArray2[3] = outW;
        } else {
            long[] lArray3 = new long[4];
            lArray3[0] = miniBatch;
            lArray3[1] = outH;
            lArray3[2] = outW;
            lArray = lArray3;
            lArray3[3] = outDepth;
        }
        long[] outShape = lArray;
        INDArray output = workspaceMgr.create(ArrayType.ACTIVATIONS, depthWiseWeights.dataType(), outShape, 'c');
        int sameMode = this.convolutionMode == ConvolutionMode.Same ? 1 : 0;
        int[] args = new int[]{kH, kW, strides[0], strides[1], pad[0], pad[1], dilation[0], dilation[1], sameMode, nchw ? 0 : 1};
        INDArray[] inputs = ((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).hasBias() ? new INDArray[]{input, depthWiseWeights, bias} : new INDArray[]{input, depthWiseWeights};
        DynamicCustomOp op = DynamicCustomOp.builder((String)"depthwise_conv2d").addInputs(inputs).addIntegerArguments(args).addOutputs(new INDArray[]{output}).callInplace(false).build();
        Nd4j.getExecutioner().exec((CustomOp)op);
        return new Pair((Object)output, null);
    }

    @Override
    public INDArray activate(boolean training, LayerWorkspaceMgr workspaceMgr) {
        this.assertInputSet(false);
        if (this.cacheMode == null) {
            this.cacheMode = CacheMode.NONE;
        }
        this.applyDropOutIfNecessary(training, workspaceMgr);
        INDArray z = (INDArray)this.preOutput(training, false, workspaceMgr).getFirst();
        IActivation afn = ((org.deeplearning4j.nn.conf.layers.ConvolutionLayer)this.layerConf()).getActivationFn();
        INDArray activation = afn.getActivation(z, training);
        return activation;
    }
}

