/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.optimize.listeners;

import java.io.Serializable;
import java.util.Date;
import java.util.concurrent.atomic.AtomicLong;
import org.deeplearning4j.nn.api.Model;
import org.deeplearning4j.optimize.api.BaseTrainingListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeIterationListener
extends BaseTrainingListener
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(TimeIterationListener.class);
    private final int frequency;
    private final long start;
    private final int iterationCount;
    private final AtomicLong iterationCounter = new AtomicLong(0L);

    public TimeIterationListener(int iterationCount) {
        this(1, iterationCount);
    }

    public TimeIterationListener(int frequency, int iterationCount) {
        this.frequency = frequency;
        this.iterationCount = iterationCount;
        this.start = System.currentTimeMillis();
    }

    @Override
    public void iterationDone(Model model, int iteration, int epoch) {
        long currentIteration = this.iterationCounter.incrementAndGet();
        if (iteration % this.frequency == 0) {
            long elapsed = System.currentTimeMillis() - this.start;
            long remaining = ((long)this.iterationCount - currentIteration) * elapsed / currentIteration;
            long minutes = remaining / 60000L;
            Date date = new Date(this.start + elapsed + remaining);
            log.info("Remaining time : " + minutes + "mn - End expected : " + date.toString());
        }
    }
}

