/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.graph.vertex.impl;

import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.api.MaskState;
import org.deeplearning4j.nn.gradient.Gradient;
import org.deeplearning4j.nn.graph.ComputationGraph;
import org.deeplearning4j.nn.graph.vertex.BaseGraphVertex;
import org.deeplearning4j.nn.graph.vertex.VertexIndices;
import org.deeplearning4j.nn.workspace.ArrayType;
import org.deeplearning4j.nn.workspace.LayerWorkspaceMgr;
import org.nd4j.common.primitives.Pair;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.memory.MemoryWorkspace;
import org.nd4j.linalg.api.ndarray.INDArray;

public class ScaleVertex
extends BaseGraphVertex {
    private double scaleFactor;

    public ScaleVertex(ComputationGraph graph, String name, int vertexIndex, double scaleFactor, DataType dataType) {
        this(graph, name, vertexIndex, null, null, scaleFactor, dataType);
    }

    public ScaleVertex(ComputationGraph graph, String name, int vertexIndex, VertexIndices[] inputVertices, VertexIndices[] outputVertices, double scaleFactor, DataType dataType) {
        super(graph, name, vertexIndex, inputVertices, outputVertices, dataType);
        this.scaleFactor = scaleFactor;
    }

    @Override
    public boolean hasLayer() {
        return false;
    }

    @Override
    public Layer getLayer() {
        return null;
    }

    @Override
    public INDArray doForward(boolean training, LayerWorkspaceMgr workspaceMgr) {
        if (!this.canDoForward()) {
            throw new IllegalStateException("Cannot do forward pass: inputs not set (ScaleVertex " + this.vertexName + " idx " + this.vertexIndex + ")");
        }
        if (this.inputs.length > 1) {
            throw new IllegalArgumentException("ScaleVertex (name " + this.vertexName + " idx " + this.vertexIndex + ") only supports 1 input.");
        }
        try (MemoryWorkspace ws = workspaceMgr.notifyScopeBorrowed(ArrayType.ACTIVATIONS);){
            INDArray iNDArray = this.inputs[0].mul((Number)this.scaleFactor);
            return iNDArray;
        }
    }

    @Override
    public Pair<Gradient, INDArray[]> doBackward(boolean tbptt, LayerWorkspaceMgr workspaceMgr) {
        if (!this.canDoBackward()) {
            throw new IllegalStateException("Cannot do backward pass: errors not set (ScaleVertex " + this.vertexName + " idx " + this.vertexIndex + ")");
        }
        try (MemoryWorkspace ws = workspaceMgr.notifyScopeBorrowed(ArrayType.ACTIVATION_GRAD);){
            Pair pair = new Pair(null, (Object)new INDArray[]{this.epsilon.mul((Number)this.scaleFactor)});
            return pair;
        }
    }

    @Override
    public void setBackpropGradientsViewArray(INDArray backpropGradientsViewArray) {
        if (backpropGradientsViewArray != null) {
            throw new RuntimeException("Vertex does not have gradients; gradients view array cannot be set here (ScaleVertex " + this.vertexName + " idx " + this.vertexIndex + ")");
        }
    }

    @Override
    public String toString() {
        return "ScaleVertex(id=" + this.getVertexIndex() + ",name=\"" + this.getVertexName() + "\",scaleFactor=" + this.scaleFactor + ")";
    }

    @Override
    public Pair<INDArray, MaskState> feedForwardMaskArrays(INDArray[] maskArrays, MaskState currentMaskState, int minibatchSize) {
        if (maskArrays == null || maskArrays.length == 0) {
            return null;
        }
        return new Pair((Object)maskArrays[0], (Object)currentMaskState);
    }
}

