/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.layers;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.conf.CNN2DFormat;
import org.deeplearning4j.nn.conf.InputPreProcessor;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.layers.BaseUpsamplingLayer;
import org.deeplearning4j.nn.conf.layers.InputTypeUtil;
import org.deeplearning4j.nn.conf.memory.LayerMemoryReport;
import org.deeplearning4j.nn.conf.memory.MemoryReport;
import org.deeplearning4j.nn.conf.serde.legacy.LegacyIntArrayDeserializer;
import org.deeplearning4j.optimize.api.TrainingListener;
import org.deeplearning4j.util.ValidationUtils;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.shade.jackson.databind.annotation.JsonDeserialize;

public class Upsampling2D
extends BaseUpsamplingLayer {
    @JsonDeserialize(using=LegacyIntArrayDeserializer.class)
    protected int[] size;
    protected CNN2DFormat format = CNN2DFormat.NCHW;

    protected Upsampling2D(BaseUpsamplingLayer.UpsamplingBuilder builder) {
        super(builder);
        this.size = builder.size;
        this.format = ((Builder)builder).format;
    }

    @Override
    public Upsampling2D clone() {
        Upsampling2D clone = (Upsampling2D)super.clone();
        return clone;
    }

    @Override
    public Layer instantiate(NeuralNetConfiguration conf, Collection<TrainingListener> trainingListeners, int layerIndex, INDArray layerParamsView, boolean initializeParams, DataType networkDataType) {
        org.deeplearning4j.nn.layers.convolution.upsampling.Upsampling2D ret = new org.deeplearning4j.nn.layers.convolution.upsampling.Upsampling2D(conf, networkDataType);
        ret.setListeners(trainingListeners);
        ret.setIndex(layerIndex);
        ret.setParamsViewArray(layerParamsView);
        Map<String, INDArray> paramTable = this.initializer().init(conf, layerParamsView, initializeParams);
        ret.setParamTable(paramTable);
        ret.setConf(conf);
        return ret;
    }

    @Override
    public InputType getOutputType(int layerIndex, InputType inputType) {
        if (inputType == null || inputType.getType() != InputType.Type.CNN) {
            throw new IllegalStateException("Invalid input for Upsampling 2D layer (layer name=\"" + this.getLayerName() + "\"): Expected CNN input, got " + inputType);
        }
        InputType.InputTypeConvolutional i = (InputType.InputTypeConvolutional)inputType;
        long inHeight = i.getHeight();
        long inWidth = i.getWidth();
        long inDepth = i.getChannels();
        return InputType.convolutional((long)this.size[0] * inHeight, (long)this.size[1] * inWidth, inDepth, i.getFormat());
    }

    @Override
    public InputPreProcessor getPreProcessorForInputType(InputType inputType) {
        if (inputType == null) {
            throw new IllegalStateException("Invalid input for Upsampling 2D layer (layer name=\"" + this.getLayerName() + "\"): input is null");
        }
        return InputTypeUtil.getPreProcessorForInputTypeCnnLayers(inputType, this.getLayerName());
    }

    @Override
    public LayerMemoryReport getMemoryReport(InputType inputType) {
        long im2colSizePerEx;
        InputType.InputTypeConvolutional c = (InputType.InputTypeConvolutional)inputType;
        InputType.InputTypeConvolutional outputType = (InputType.InputTypeConvolutional)this.getOutputType(-1, inputType);
        long trainingWorkingSizePerEx = im2colSizePerEx = c.getChannels() * outputType.getHeight() * outputType.getWidth() * (long)this.size[0] * (long)this.size[1];
        if (this.getIDropout() != null) {
            trainingWorkingSizePerEx += inputType.arrayElementsPerExample();
        }
        return new LayerMemoryReport.Builder(this.layerName, Upsampling2D.class, inputType, outputType).standardMemory(0L, 0L).workingMemory(0L, im2colSizePerEx, 0L, trainingWorkingSizePerEx).cacheMemory(MemoryReport.CACHE_MODE_ALL_ZEROS, MemoryReport.CACHE_MODE_ALL_ZEROS).build();
    }

    @Override
    public void setNIn(InputType inputType, boolean override) {
        if (inputType == null || inputType.getType() != InputType.Type.CNN) {
            throw new IllegalStateException("Invalid input for Upsampling 2D layer (layer name=\"" + this.getLayerName() + "\"): Expected CNN input, got " + inputType);
        }
        this.format = ((InputType.InputTypeConvolutional)inputType).getFormat();
    }

    @Override
    public int[] getSize() {
        return this.size;
    }

    public CNN2DFormat getFormat() {
        return this.format;
    }

    @Override
    public void setSize(int[] size) {
        this.size = size;
    }

    public void setFormat(CNN2DFormat format) {
        this.format = format;
    }

    public Upsampling2D() {
    }

    @Override
    public String toString() {
        return "Upsampling2D(super=" + super.toString() + ", size=" + Arrays.toString(this.getSize()) + ", format=" + this.getFormat() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Upsampling2D)) {
            return false;
        }
        Upsampling2D other = (Upsampling2D)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (!Arrays.equals(this.getSize(), other.getSize())) {
            return false;
        }
        CNN2DFormat this$format = this.getFormat();
        CNN2DFormat other$format = other.getFormat();
        return !(this$format == null ? other$format != null : !this$format.equals(other$format));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Upsampling2D;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + Arrays.hashCode(this.getSize());
        CNN2DFormat $format = this.getFormat();
        result = result * 59 + ($format == null ? 43 : $format.hashCode());
        return result;
    }

    public static class Builder
    extends BaseUpsamplingLayer.UpsamplingBuilder<Builder> {
        protected CNN2DFormat format = CNN2DFormat.NCHW;

        public Builder(int size) {
            super(new int[]{size, size});
        }

        public Builder dataFormat(CNN2DFormat format) {
            this.format = format;
            return this;
        }

        public Builder size(int size) {
            this.setSize(size, size);
            return this;
        }

        public Builder size(int[] size) {
            this.setSize(size);
            return this;
        }

        @Override
        public Upsampling2D build() {
            return new Upsampling2D(this);
        }

        @Override
        public void setSize(int ... size) {
            this.size = ValidationUtils.validate2NonNegative(size, false, "size");
        }

        public Builder() {
        }
    }
}

