/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.optimize.listeners;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.deeplearning4j.nn.api.Model;
import org.deeplearning4j.optimize.api.IterationListener;
import org.nd4j.linalg.primitives.Pair;

public class CollectScoresIterationListener
implements IterationListener {
    private int frequency;
    private int iterationCount = 0;
    private List<Pair<Integer, Double>> scoreVsIter = new ArrayList<Pair<Integer, Double>>();

    public CollectScoresIterationListener() {
        this(1);
    }

    public CollectScoresIterationListener(int frequency) {
        if (frequency <= 0) {
            frequency = 1;
        }
        this.frequency = frequency;
    }

    @Override
    public boolean invoked() {
        return false;
    }

    @Override
    public void invoke() {
    }

    @Override
    public void iterationDone(Model model, int iteration) {
        if (++this.iterationCount % this.frequency == 0) {
            double score = model.score();
            this.scoreVsIter.add((Pair<Integer, Double>)new Pair((Object)this.iterationCount, (Object)score));
        }
    }

    public List<Pair<Integer, Double>> getScoreVsIter() {
        return this.getScoreVsIter();
    }

    public void exportScores(OutputStream outputStream) throws IOException {
        this.exportScores(outputStream, "\t");
    }

    public void exportScores(OutputStream outputStream, String delimiter) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append("Iteration").append(delimiter).append("Score");
        for (Pair<Integer, Double> p : this.scoreVsIter) {
            sb.append("\n").append(p.getFirst()).append(delimiter).append(p.getSecond());
        }
        outputStream.write(sb.toString().getBytes("UTF-8"));
    }

    public void exportScores(File file) throws IOException {
        this.exportScores(file, "\t");
    }

    public void exportScores(File file, String delimiter) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(file);){
            this.exportScores(fos, delimiter);
        }
    }
}

