/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.simple.binary;

import java.util.Arrays;

public class BinaryClassificationResult {
    private double decisionThreshold = 0.5;
    private double[] classWeights;

    public double getDecisionThreshold() {
        return this.decisionThreshold;
    }

    public double[] getClassWeights() {
        return this.classWeights;
    }

    public void setDecisionThreshold(double decisionThreshold) {
        this.decisionThreshold = decisionThreshold;
    }

    public void setClassWeights(double[] classWeights) {
        this.classWeights = classWeights;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BinaryClassificationResult)) {
            return false;
        }
        BinaryClassificationResult other = (BinaryClassificationResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getDecisionThreshold(), other.getDecisionThreshold()) != 0) {
            return false;
        }
        return Arrays.equals(this.getClassWeights(), other.getClassWeights());
    }

    protected boolean canEqual(Object other) {
        return other instanceof BinaryClassificationResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $decisionThreshold = Double.doubleToLongBits(this.getDecisionThreshold());
        result = result * 59 + (int)($decisionThreshold >>> 32 ^ $decisionThreshold);
        result = result * 59 + Arrays.hashCode(this.getClassWeights());
        return result;
    }

    public String toString() {
        return "BinaryClassificationResult(decisionThreshold=" + this.getDecisionThreshold() + ", classWeights=" + Arrays.toString(this.getClassWeights()) + ")";
    }
}

