/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.datasets.iterator.impl;

import java.util.concurrent.atomic.AtomicLong;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.dataset.MultiDataSet;
import org.nd4j.linalg.dataset.api.MultiDataSetPreProcessor;
import org.nd4j.linalg.dataset.api.iterator.MultiDataSetIterator;
import org.nd4j.linalg.factory.Nd4j;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BenchmarkMultiDataSetIterator
implements MultiDataSetIterator {
    private static final Logger log = LoggerFactory.getLogger(BenchmarkMultiDataSetIterator.class);
    private INDArray[] baseFeatures;
    private INDArray[] baseLabels;
    private long limit;
    private AtomicLong counter = new AtomicLong(0L);

    public BenchmarkMultiDataSetIterator(int[][] featuresShape, int[] numLabels, int totalIterations) {
        int i;
        if (featuresShape.length != numLabels.length) {
            throw new IllegalArgumentException("Number of input features must match length of input labels.");
        }
        this.baseFeatures = new INDArray[featuresShape.length];
        for (i = 0; i < featuresShape.length; ++i) {
            this.baseFeatures[i] = Nd4j.rand((int[])featuresShape[i]);
        }
        this.baseLabels = new INDArray[featuresShape.length];
        for (i = 0; i < featuresShape.length; ++i) {
            this.baseLabels[i] = Nd4j.create((int)featuresShape[i][0], (int)numLabels[i]);
            this.baseLabels[i].getColumn(1).assign((Number)1.0);
        }
        Nd4j.getExecutioner().commit();
        this.limit = totalIterations;
    }

    public BenchmarkMultiDataSetIterator(MultiDataSet example, int totalIterations) {
        int i;
        this.baseFeatures = new INDArray[example.getFeatures().length];
        for (i = 0; i < example.getFeatures().length; ++i) {
            this.baseFeatures[i] = example.getFeatures()[i].dup();
        }
        this.baseLabels = new INDArray[example.getLabels().length];
        for (i = 0; i < example.getLabels().length; ++i) {
            this.baseFeatures[i] = example.getLabels()[i].dup();
        }
        Nd4j.getExecutioner().commit();
        this.limit = totalIterations;
    }

    public MultiDataSet next(int i) {
        throw new UnsupportedOperationException();
    }

    public boolean resetSupported() {
        return true;
    }

    public boolean asyncSupported() {
        return true;
    }

    public void reset() {
        this.counter.set(0L);
    }

    public void setPreProcessor(MultiDataSetPreProcessor dataSetPreProcessor) {
    }

    public MultiDataSetPreProcessor getPreProcessor() {
        return null;
    }

    public boolean hasNext() {
        return this.counter.get() < this.limit;
    }

    public MultiDataSet next() {
        this.counter.incrementAndGet();
        INDArray[] features = new INDArray[this.baseFeatures.length];
        for (int i = 0; i < this.baseFeatures.length; ++i) {
            features[i] = this.baseFeatures[i];
        }
        INDArray[] labels = new INDArray[this.baseLabels.length];
        for (int i = 0; i < this.baseLabels.length; ++i) {
            labels[i] = this.baseLabels[i];
        }
        MultiDataSet ds = new MultiDataSet(features, labels);
        return ds;
    }

    public void remove() {
    }
}

