/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.deeplearning4j.util.FingerPrintKeyer;

public class StringCluster
extends HashMap<String, Map<String, Integer>> {
    private static final long serialVersionUID = -4120559428585520276L;

    public StringCluster(List<String> list) {
        for (int i = 0; i < list.size(); ++i) {
            Map<String, Integer> m;
            FingerPrintKeyer keyer = new FingerPrintKeyer();
            String s = list.get(i);
            String key = keyer.key(s, new Object[0]);
            if (this.containsKey(key)) {
                m = (Map)this.get(key);
                if (m.containsKey(s)) {
                    m.put(s, (Integer)m.get(s) + 1);
                    continue;
                }
                m.put(s, 1);
                continue;
            }
            m = new TreeMap();
            m.put(s, 1);
            this.put(key, m);
        }
    }

    public List<Map<String, Integer>> getClusters() {
        ArrayList<Map<String, Integer>> _clusters = new ArrayList<Map<String, Integer>>(this.values());
        Collections.sort(_clusters, new SizeComparator());
        return _clusters;
    }

    public void sort() {
        Collections.sort(new ArrayList(this.values()), new SizeComparator());
    }

    public static class SizeComparator
    implements Comparator<Map<String, Integer>>,
    Serializable {
        private static final long serialVersionUID = -1390696157208674054L;

        @Override
        public int compare(Map<String, Integer> o1, Map<String, Integer> o2) {
            int s2;
            int s1 = o1.size();
            if (s1 == (s2 = o2.size())) {
                int total1 = 0;
                for (int i : o1.values()) {
                    total1 += i;
                }
                int total2 = 0;
                for (int i : o2.values()) {
                    total2 += i;
                }
                if (total2 < total1) {
                    return -1;
                }
                if (total2 > total1) {
                    return 1;
                }
                return 0;
            }
            if (s2 < s1) {
                return -1;
            }
            return 1;
        }
    }
}

