/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.util;

import java.util.HashSet;
import java.util.Queue;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OneTimeLogger {
    private static final Logger log = LoggerFactory.getLogger(OneTimeLogger.class);
    protected static HashSet<String> hashSet = new HashSet();
    protected static final Queue<String> buffer = new LinkedTransferQueue<String>();
    private static final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    protected static boolean isEligible(String message) {
        try {
            lock.readLock().lock();
            if (hashSet.contains(message)) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            lock.readLock().unlock();
        }
        try {
            lock.writeLock().lock();
            if (buffer.size() >= 100) {
                String rem = buffer.remove();
                hashSet.remove(rem);
            }
            buffer.add(message);
            hashSet.add(message);
            boolean bl = true;
            return bl;
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    public static void info(Logger logger, String format, Object ... arguments) {
        if (!OneTimeLogger.isEligible(format)) {
            return;
        }
        logger.info(format, arguments);
    }

    public static void warn(Logger logger, String format, Object ... arguments) {
        if (!OneTimeLogger.isEligible(format)) {
            return;
        }
        logger.warn(format, arguments);
    }

    public static void error(Logger logger, String format, Object ... arguments) {
        if (!OneTimeLogger.isEligible(format)) {
            return;
        }
        logger.error(format, arguments);
    }

    public static void reset() {
        buffer.clear();
    }
}

