/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.util;

import java.util.ArrayList;
import java.util.List;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;

public class MovingWindowMatrix {
    private int windowRowSize = 28;
    private int windowColumnSize = 28;
    private INDArray toSlice;
    private boolean addRotate = false;

    public MovingWindowMatrix(INDArray toSlice, int windowRowSize, int windowColumnSize, boolean addRotate) {
        this.toSlice = toSlice;
        this.windowRowSize = windowRowSize;
        this.windowColumnSize = windowColumnSize;
        this.addRotate = addRotate;
    }

    public MovingWindowMatrix(INDArray toSlice, int windowRowSize, int windowColumnSize) {
        this(toSlice, windowRowSize, windowColumnSize, false);
    }

    public List<INDArray> windows() {
        return this.windows(false);
    }

    public List<INDArray> windows(boolean flattened) {
        ArrayList<INDArray> ret = new ArrayList<INDArray>();
        int window = 0;
        for (int i = 0; i < this.toSlice.length() && window < this.toSlice.length(); window += this.windowRowSize * this.windowColumnSize, ++i) {
            double[] w = new double[this.windowRowSize * this.windowColumnSize];
            for (int count = 0; count < this.windowRowSize * this.windowColumnSize; ++count) {
                w[count] = this.toSlice.getDouble(count + window);
            }
            INDArray add = Nd4j.create((double[])w);
            add = flattened ? add.ravel() : add.reshape(this.windowRowSize, this.windowColumnSize);
            if (this.addRotate) {
                INDArray currRotation = add.dup();
                for (int rotation = 0; rotation < 3; ++rotation) {
                    Nd4j.rot90((INDArray)currRotation);
                    ret.add(currRotation.dup());
                }
            }
            ret.add(add);
        }
        return ret;
    }
}

