/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.layers;

import org.deeplearning4j.berkeley.Pair;
import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.gradient.DefaultGradient;
import org.deeplearning4j.nn.gradient.Gradient;
import org.deeplearning4j.nn.layers.BaseLayer;
import org.nd4j.linalg.api.ndarray.INDArray;

public class DropoutLayer
extends BaseLayer<org.deeplearning4j.nn.conf.layers.DropoutLayer> {
    public DropoutLayer(NeuralNetConfiguration conf) {
        super(conf);
    }

    public DropoutLayer(NeuralNetConfiguration conf, INDArray input) {
        super(conf, input);
    }

    @Override
    public double calcL2(boolean backpropParamsOnly) {
        return 0.0;
    }

    @Override
    public double calcL1(boolean backpropParamsOnly) {
        return 0.0;
    }

    @Override
    public Layer.Type type() {
        return Layer.Type.FEED_FORWARD;
    }

    @Override
    public void fit(INDArray input) {
    }

    @Override
    public Pair<Gradient, INDArray> backpropGradient(INDArray epsilon) {
        INDArray delta = epsilon.dup();
        if (this.maskArray != null) {
            delta.muliColumnVector(this.maskArray);
        }
        DefaultGradient ret = new DefaultGradient();
        return new Pair<Gradient, INDArray>(ret, delta);
    }

    @Override
    public INDArray preOutput(boolean training) {
        if (this.input == null) {
            throw new IllegalArgumentException("Cannot perform forward pass with null input " + this.layerId());
        }
        INDArray dummy = this.input;
        this.applyDropOutIfNecessary(training);
        INDArray ret = training ? this.input.dup() : this.input;
        if (this.maskArray != null) {
            ret.muliColumnVector(this.maskArray);
        }
        return ret;
    }

    @Override
    public INDArray activate(boolean training) {
        INDArray z = this.preOutput(training);
        return z;
    }

    @Override
    public Layer transpose() {
        throw new UnsupportedOperationException("Not supported - " + this.layerId());
    }

    @Override
    public boolean isPretrainLayer() {
        return false;
    }

    @Override
    public Gradient calcGradient(Gradient layerError, INDArray indArray) {
        throw new UnsupportedOperationException("Not supported " + this.layerId());
    }

    @Override
    public void merge(Layer layer, int batchSize) {
        throw new UnsupportedOperationException("Not supported - " + this.layerId());
    }

    @Override
    public INDArray params() {
        return null;
    }
}

